/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui;

import de.datomino.peppergis.areamanager.gui.AreaDelivererDialog;
import de.datomino.peppergis.client.gui.ErrorMessagesDialog;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.tour.AreaDelivererMaxSalaryModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererMaxSalaryModelImpl;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererNightSurchargeModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererNightSurchargeModelImpl;
import de.datomino.peppergis.client.model.tour.AreaDelivererRewardModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererRewardModelImpl;
import de.datomino.peppergis.client.model.tour.AreaDelivererSurchargeModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererSurchargeModelImpl;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.NumericUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Holder;
import org.ktde.util.datatypes.Tripel;

public class AreaDelivererRewardPane
extends JPanel {
    private static final long serialVersionUID = -755279579746865123L;
    private AreaDelivererModel deliverer;
    private List<SubRewardDialog> rewardList;
    private Box rewardBox;
    private List<Tripel<AreaDelivererMaxSalaryModel, Component, Boolean>> maxSalaryList;
    private Box maxSalaryBox;
    private List<Tripel<AreaDelivererSurchargeModel, Component, Boolean>> surchargeList;
    private Box surchargeBox;
    private List<Tripel<AreaDelivererNightSurchargeModel, Component, Boolean>> nightSurchargeList;
    private Box nightSurchargeBox;
    private AreaDelivererDialog parent;

    public AreaDelivererRewardPane(AreaDelivererModel deliverer, AreaDelivererDialog parent) {
        super(new SpringLayout());
        this.deliverer = deliverer;
        this.parent = parent;
        this.initialize();
    }

    private void initialize() {
        this.rewardList = new ArrayList<SubRewardDialog>(this.deliverer.countReward());
        for (AreaDelivererRewardModel areaDelivererRewardModel : this.deliverer.iterableReward()) {
            if (NumericUtil.getDoubleValue(areaDelivererRewardModel.getHourReward()) == 0.0) continue;
            this.rewardList.add(new SubRewardDialog(areaDelivererRewardModel, false));
        }
        this.maxSalaryList = new ArrayList<Tripel<AreaDelivererMaxSalaryModel, Component, Boolean>>(this.deliverer.countMaxSalary());
        for (AreaDelivererMaxSalaryModel areaDelivererMaxSalaryModel : this.deliverer.iterableMaxSalary()) {
            this.maxSalaryList.add(new Tripel<AreaDelivererMaxSalaryModel, Component, Boolean>(areaDelivererMaxSalaryModel, this.createMaxSalarySubPane(areaDelivererMaxSalaryModel, false), false));
        }
        Collections.sort(this.maxSalaryList, new Comparator<Tripel<AreaDelivererMaxSalaryModel, Component, Boolean>>(){

            @Override
            public int compare(Tripel<AreaDelivererMaxSalaryModel, Component, Boolean> o1, Tripel<AreaDelivererMaxSalaryModel, Component, Boolean> o2) {
                return AreaDelivererRewardPane.this.compareDate(o1.getElement1().getStartTime(), o2.getElement1().getStartTime());
            }
        });
        this.surchargeList = new ArrayList<Tripel<AreaDelivererSurchargeModel, Component, Boolean>>(this.deliverer.countSurcharge());
        for (AreaDelivererSurchargeModel areaDelivererSurchargeModel : this.deliverer.iterableSurcharge()) {
            this.surchargeList.add(new Tripel<AreaDelivererSurchargeModel, Component, Boolean>(areaDelivererSurchargeModel, this.createSurchargeSubPane(areaDelivererSurchargeModel, false), false));
        }
        Collections.sort(this.surchargeList, new Comparator<Tripel<AreaDelivererSurchargeModel, Component, Boolean>>(){

            @Override
            public int compare(Tripel<AreaDelivererSurchargeModel, Component, Boolean> o1, Tripel<AreaDelivererSurchargeModel, Component, Boolean> o2) {
                return AreaDelivererRewardPane.this.compareDate(o1.getElement1().getStartTime(), o2.getElement1().getStartTime());
            }
        });
        this.nightSurchargeList = new ArrayList<Tripel<AreaDelivererNightSurchargeModel, Component, Boolean>>(this.deliverer.countNightSurcharge());
        for (AreaDelivererNightSurchargeModel areaDelivererNightSurchargeModel : this.deliverer.iterableNightSurcharge()) {
            this.nightSurchargeList.add(new Tripel<AreaDelivererNightSurchargeModel, Component, Boolean>(areaDelivererNightSurchargeModel, this.createNightSurchargeSubPane(areaDelivererNightSurchargeModel, false), false));
        }
        Collections.sort(this.nightSurchargeList, new Comparator<Tripel<AreaDelivererNightSurchargeModel, Component, Boolean>>(){

            @Override
            public int compare(Tripel<AreaDelivererNightSurchargeModel, Component, Boolean> o1, Tripel<AreaDelivererNightSurchargeModel, Component, Boolean> o2) {
                return AreaDelivererRewardPane.this.compareDate(o1.getElement1().getStartTime(), o2.getElement1().getStartTime());
            }
        });
        this.addRewardBox();
        this.addMaxSalaryBox();
        this.addSurchargeBox();
        this.addNightSurchargeBox();
        SpringUtilities.makeCompactGrid(this, 4, 2, 5, 5, 5, 5);
        this.fillData();
    }

    private void addRewardBox() {
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.deliverer.wage", new Serializable[0])));
        final JButton removeButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 5618093758838171047L;

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = AreaDelivererRewardPane.this.rewardList;
                if (!list.isEmpty() && ((SubRewardDialog)list.get(list.size() - 1)).editable) {
                    SubRewardDialog last = (SubRewardDialog)list.remove(list.size() - 1);
                    AreaDelivererRewardPane.this.deliverer.removeAReward(last.reward);
                    last.reward.delete();
                    AreaDelivererRewardPane.this.fillData();
                    if (list.isEmpty() || !((SubRewardDialog)list.get(list.size() - 1)).editable) {
                        ((JButton)e.getSource()).setEnabled(false);
                    }
                }
                AreaDelivererRewardPane.this.fillData();
            }
        });
        JButton addButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -1120541285990896045L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AreaDelivererRewardPane.this.deliverer != null) {
                    if (!AreaDelivererRewardPane.this.checkRewards(null)) {
                        return;
                    }
                    final AreaDelivererRewardModelImpl newModel = new AreaDelivererRewardModelImpl();
                    newModel.setStartTime(new Date());
                    final SubRewardDialog dialog = new SubRewardDialog(newModel, true);
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent e) {
                            dialog.display.setText(AreaDelivererRewardPane.this.getRewardString(newModel));
                        }
                    });
                    dialog.buildLayout();
                    dialog.pack();
                    SwingUtils.center((Window)dialog, AreaDelivererRewardPane.this.parent);
                    dialog.setVisible(true);
                }
                AreaDelivererRewardPane.this.fillData();
            }
        });
        this.rewardBox = new Box(1){
            private static final long serialVersionUID = 7189695040704594181L;

            @Override
            public void repaint(long tm) {
                super.repaint(tm);
                List list = AreaDelivererRewardPane.this.rewardList;
                if (!list.isEmpty() && ((SubRewardDialog)list.get(list.size() - 1)).editable) {
                    removeButton.setEnabled(true);
                } else {
                    removeButton.setEnabled(false);
                }
            }
        };
        this.createScrollPane(this.rewardBox, addButton, removeButton);
    }

    private String getRewardString(AreaDelivererRewardModel m) {
        String hourValue = ClientFormUtil.numberToString(m.getHourReward(), 2);
        String kmValue = ClientFormUtil.numberToString(m.getKilometerRewardMotor(), 2) + "/" + ClientFormUtil.numberToString(m.getKilometerRewardFoot(), 2) + "/" + ClientFormUtil.numberToString(m.getKilometerRewardBike(), 2);
        String dateFrom = TimeUtil.formatDate(m.getStartTime(), FormUtil.DATEFORMAT);
        dateFrom = StringUtil.isEmpty(dateFrom) ? "00.00.0000" : dateFrom;
        return hourValue + " - " + kmValue + " - " + dateFrom;
    }

    private void addMaxSalaryBox() {
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.reward.maxSalary", new Serializable[0])));
        final JButton removeButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -2320987021868339069L;

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = AreaDelivererRewardPane.this.maxSalaryList;
                if (!list.isEmpty() && ((Boolean)((Tripel)list.get(list.size() - 1)).getElement3()).booleanValue()) {
                    Tripel last = (Tripel)list.remove(list.size() - 1);
                    AreaDelivererRewardPane.this.deliverer.removeAMaxSalary((AreaDelivererMaxSalaryModel)last.getElement1());
                    ((AreaDelivererMaxSalaryModel)last.getElement1()).delete();
                    AreaDelivererRewardPane.this.fillData();
                    if (list.isEmpty() || !((Boolean)((Tripel)list.get(list.size() - 1)).getElement3()).booleanValue()) {
                        ((JButton)e.getSource()).setEnabled(false);
                    }
                }
                AreaDelivererRewardPane.this.fillData();
            }
        });
        JButton addButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -8940004468391978749L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AreaDelivererRewardPane.this.deliverer != null) {
                    AreaDelivererMaxSalaryModelImpl newModel = new AreaDelivererMaxSalaryModelImpl();
                    newModel.setStartTime(new Date());
                    AreaDelivererRewardPane.this.deliverer.addAMaxSalary(newModel);
                    AreaDelivererRewardPane.this.maxSalaryList.add(new Tripel<AreaDelivererMaxSalaryModelImpl, Component, Boolean>(newModel, AreaDelivererRewardPane.this.createMaxSalarySubPane(newModel, true), true));
                    AreaDelivererRewardPane.this.fillData();
                    removeButton.setEnabled(true);
                }
                AreaDelivererRewardPane.this.fillData();
            }
        });
        this.maxSalaryBox = Box.createVerticalBox();
        this.createScrollPane(this.maxSalaryBox, addButton, removeButton);
    }

    private Component createMaxSalarySubPane(AreaDelivererMaxSalaryModel m, boolean editable) {
        JPanel pane = new JPanel(new SpringLayout());
        if (m != null) {
            Holder<AreaDelivererMaxSalaryModel> holder = new Holder<AreaDelivererMaxSalaryModel>(m);
            pane.add(ClientSwingUtil.createParameterTextField(20, ClientFormUtil.numberToString(m.getValue(), 2), editable, "Value", holder, pane));
            pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.starttime", new Serializable[0])));
            pane.add(ClientSwingUtil.createParameterTextField(20, TimeUtil.formatDate(m.getStartTime(), FormUtil.DATEFORMAT), editable, "StartTime", holder, pane));
            SpringUtilities.makeCompactGrid(pane, 1, 3, 5, 5, 5, 5);
        }
        return pane;
    }

    private void addSurchargeBox() {
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.reward.surcharge", new Serializable[0])));
        final JButton removeButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 3367598745624963408L;

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = AreaDelivererRewardPane.this.surchargeList;
                if (!list.isEmpty() && ((Boolean)((Tripel)list.get(list.size() - 1)).getElement3()).booleanValue()) {
                    Tripel last = (Tripel)list.remove(list.size() - 1);
                    AreaDelivererRewardPane.this.deliverer.removeASurcharge((AreaDelivererSurchargeModel)last.getElement1());
                    ((AreaDelivererSurchargeModel)last.getElement1()).delete();
                    AreaDelivererRewardPane.this.fillData();
                    if (list.isEmpty() || !((Boolean)((Tripel)list.get(list.size() - 1)).getElement3()).booleanValue()) {
                        ((JButton)e.getSource()).setEnabled(false);
                    }
                }
                AreaDelivererRewardPane.this.fillData();
            }
        });
        JButton addButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -6490172414957455193L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AreaDelivererRewardPane.this.deliverer != null) {
                    AreaDelivererSurchargeModelImpl newModel = new AreaDelivererSurchargeModelImpl();
                    newModel.setStartTime(new Date());
                    AreaDelivererRewardPane.this.deliverer.addASurcharge(newModel);
                    AreaDelivererRewardPane.this.surchargeList.add(new Tripel<AreaDelivererSurchargeModelImpl, Component, Boolean>(newModel, AreaDelivererRewardPane.this.createSurchargeSubPane(newModel, true), true));
                    AreaDelivererRewardPane.this.fillData();
                    removeButton.setEnabled(true);
                }
                AreaDelivererRewardPane.this.fillData();
            }
        });
        this.surchargeBox = Box.createVerticalBox();
        this.createScrollPane(this.surchargeBox, addButton, removeButton);
    }

    private Component createSurchargeSubPane(AreaDelivererSurchargeModel m, boolean editable) {
        JPanel pane = new JPanel(new SpringLayout());
        if (m != null) {
            Holder<AreaDelivererSurchargeModel> holder = new Holder<AreaDelivererSurchargeModel>(m);
            pane.add(ClientSwingUtil.createParameterTextField(20, ClientFormUtil.numberToString(m.getValue(), 2), editable, "Value", holder, pane));
            pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.starttime", new Serializable[0])));
            pane.add(ClientSwingUtil.createParameterTextField(20, TimeUtil.formatDate(m.getStartTime(), FormUtil.DATEFORMAT), editable, "StartTime", holder, pane));
            SpringUtilities.makeCompactGrid(pane, 1, 3, 5, 5, 5, 5);
        }
        return pane;
    }

    private void addNightSurchargeBox() {
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.reward.nightsurcharge", new Serializable[0])));
        final JButton removeButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 7476903977792167207L;

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = AreaDelivererRewardPane.this.nightSurchargeList;
                if (!list.isEmpty() && ((Boolean)((Tripel)list.get(list.size() - 1)).getElement3()).booleanValue()) {
                    Tripel last = (Tripel)list.remove(list.size() - 1);
                    AreaDelivererRewardPane.this.deliverer.removeANightSurcharge((AreaDelivererNightSurchargeModel)last.getElement1());
                    ((AreaDelivererNightSurchargeModel)last.getElement1()).delete();
                    AreaDelivererRewardPane.this.fillData();
                    if (list.isEmpty() || !((Boolean)((Tripel)list.get(list.size() - 1)).getElement3()).booleanValue()) {
                        ((JButton)e.getSource()).setEnabled(false);
                    }
                }
                AreaDelivererRewardPane.this.fillData();
            }
        });
        JButton addButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -5837411285408040364L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AreaDelivererRewardPane.this.deliverer != null) {
                    AreaDelivererNightSurchargeModelImpl newModel = new AreaDelivererNightSurchargeModelImpl();
                    newModel.setStartTime(new Date());
                    AreaDelivererRewardPane.this.deliverer.addANightSurcharge(newModel);
                    AreaDelivererRewardPane.this.nightSurchargeList.add(new Tripel<AreaDelivererNightSurchargeModelImpl, Component, Boolean>(newModel, AreaDelivererRewardPane.this.createNightSurchargeSubPane(newModel, true), true));
                    AreaDelivererRewardPane.this.fillData();
                    removeButton.setEnabled(true);
                }
                AreaDelivererRewardPane.this.fillData();
            }
        });
        this.nightSurchargeBox = Box.createVerticalBox();
        this.createScrollPane(this.nightSurchargeBox, addButton, removeButton);
    }

    private Component createNightSurchargeSubPane(AreaDelivererNightSurchargeModel m, boolean editable) {
        JPanel pane = new JPanel(new SpringLayout());
        if (m != null) {
            Holder<AreaDelivererNightSurchargeModel> holder = new Holder<AreaDelivererNightSurchargeModel>(m);
            pane.add(ClientSwingUtil.createParameterTextField(20, ClientFormUtil.numberToString(m.getValue(), 2), editable, "Value", holder, pane));
            pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.starttime", new Serializable[0])));
            pane.add(ClientSwingUtil.createParameterTextField(20, TimeUtil.formatDate(m.getStartTime(), FormUtil.DATEFORMAT), editable, "StartTime", holder, pane));
            SpringUtilities.makeCompactGrid(pane, 1, 3, 5, 5, 5, 5);
        }
        return pane;
    }

    private void fillData() {
        this.rewardBox.removeAll();
        Collections.sort(this.rewardList, new Comparator<SubRewardDialog>(){

            @Override
            public int compare(SubRewardDialog o1, SubRewardDialog o2) {
                int c = AreaDelivererRewardPane.this.compareModel(o1.reward, o2.reward);
                if (c == 0) {
                    return AreaDelivererRewardPane.this.compareDate(o1.reward.getStartTime(), o2.reward.getStartTime());
                }
                return c;
            }
        });
        for (SubRewardDialog subRewardDialog : this.rewardList) {
            this.rewardBox.add(subRewardDialog.display);
        }
        this.rewardBox.repaint(10L);
        this.maxSalaryBox.removeAll();
        Collections.sort(this.maxSalaryList, new Comparator<Tripel<AreaDelivererMaxSalaryModel, Component, Boolean>>(){

            @Override
            public int compare(Tripel<AreaDelivererMaxSalaryModel, Component, Boolean> o1, Tripel<AreaDelivererMaxSalaryModel, Component, Boolean> o2) {
                return AreaDelivererRewardPane.this.compareDate(o1.getElement1().getStartTime(), o2.getElement1().getStartTime());
            }
        });
        for (Tripel tripel : this.maxSalaryList) {
            this.maxSalaryBox.add((Component)tripel.getElement2());
        }
        this.maxSalaryBox.repaint(10L);
        this.surchargeBox.removeAll();
        Collections.sort(this.surchargeList, new Comparator<Tripel<AreaDelivererSurchargeModel, Component, Boolean>>(){

            @Override
            public int compare(Tripel<AreaDelivererSurchargeModel, Component, Boolean> o1, Tripel<AreaDelivererSurchargeModel, Component, Boolean> o2) {
                return AreaDelivererRewardPane.this.compareDate(o1.getElement1().getStartTime(), o2.getElement1().getStartTime());
            }
        });
        for (Tripel tripel : this.surchargeList) {
            this.surchargeBox.add((Component)tripel.getElement2());
        }
        this.surchargeBox.repaint(10L);
        this.nightSurchargeBox.removeAll();
        Collections.sort(this.nightSurchargeList, new Comparator<Tripel<AreaDelivererNightSurchargeModel, Component, Boolean>>(){

            @Override
            public int compare(Tripel<AreaDelivererNightSurchargeModel, Component, Boolean> o1, Tripel<AreaDelivererNightSurchargeModel, Component, Boolean> o2) {
                return AreaDelivererRewardPane.this.compareDate(o1.getElement1().getStartTime(), o2.getElement1().getStartTime());
            }
        });
        for (Tripel tripel : this.nightSurchargeList) {
            this.nightSurchargeBox.add((Component)tripel.getElement2());
        }
        this.nightSurchargeBox.repaint(10L);
        if (this.parent != null) {
            Dimension size = this.parent.getSize();
            this.parent.pack();
            this.parent.setSize(size);
        }
        this.repaint(10L);
    }

    private int compareModel(Model m1, Model m2) {
        Long i1 = m1.getId();
        Long i2 = m2.getId();
        if (i1 == null && i2 == null) {
            return 0;
        }
        if (i1 == null && i2 != null) {
            return 1;
        }
        if (i1 != null && i2 == null) {
            return -1;
        }
        return 0;
    }

    private int compareDate(Date d1, Date d2) {
        long l1 = d1 == null ? Long.MIN_VALUE : d1.getTime();
        long l2 = d2 == null ? Long.MIN_VALUE : d2.getTime();
        return Long.compare(l1, l2);
    }

    private void createScrollPane(Component c, JButton addButton, JButton removeButton) {
        addButton.setText("+");
        addButton.setBorder(BorderFactory.createEmptyBorder());
        removeButton.setText("-");
        removeButton.setBorder(BorderFactory.createEmptyBorder());
        removeButton.setEnabled(false);
        JPanel buttonPane = new JPanel(new GridLayout(1, 2));
        buttonPane.add(addButton);
        buttonPane.add(removeButton);
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)new JScrollPane(c), "Center");
        pane.add((Component)buttonPane, "South");
        this.add(pane);
    }

    private boolean checkRewards(SubRewardDialog dialog) {
        String errorKey;
        HashSet<AreaDelivererRewardModel> rs = new HashSet<AreaDelivererRewardModel>();
        CollectionUtil.transform(this.rewardList, rs, new Transformer<SubRewardDialog, AreaDelivererRewardModel>(){

            @Override
            public AreaDelivererRewardModel transform(SubRewardDialog t) {
                return t.reward;
            }
        });
        if (dialog != null) {
            rs.add(dialog.reward);
        }
        if ((errorKey = DelivererModelUtil.checkRewards(rs)) != null) {
            ErrorMessagesDialog.creatAndShow(ModelEnviroment.getMessageResolver().resolveMessage(errorKey, new Serializable[0]), this);
        }
        return errorKey == null;
    }

    private class SubRewardDialog
    extends CommonDialog {
        private static final long serialVersionUID = 6431855393570945991L;
        private AreaDelivererRewardModel reward;
        private JTextField display;
        private boolean editable;
        private Date oldStartTime;
        private Double OldHourReward;
        private Double oldBike;
        private Double oldFoot;
        private Double oldMotor;

        public SubRewardDialog(AreaDelivererRewardModel reward, boolean editable) {
            super((Component)AreaDelivererRewardPane.this.parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.deliverer.wage", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
            this.reward = reward;
            this.editable = editable;
            this.createRewardSubPane(reward, editable);
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            if (b) {
                this.oldStartTime = this.reward.getStartTime();
                this.OldHourReward = this.reward.getHourReward();
                this.oldBike = this.reward.getKilometerRewardBike();
                this.oldFoot = this.reward.getKilometerRewardFoot();
                this.oldMotor = this.reward.getKilometerRewardMotor();
            }
        }

        @Override
        protected Component getMainComponent() {
            Holder<AreaDelivererRewardModel> holder = new Holder<AreaDelivererRewardModel>(this.reward);
            JPanel pane = new JPanel(new SpringLayout());
            pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.hour", new Serializable[0])));
            pane.add(ClientSwingUtil.createParameterTextField(20, this.reward.getHourReward() == null ? null : ClientFormUtil.numberToString(this.reward.getHourReward(), 2), this.editable, "HourReward", holder, pane));
            pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.km.motor", new Serializable[0])));
            pane.add(ClientSwingUtil.createParameterTextField(20, this.reward.getKilometerRewardMotor() == null ? null : ClientFormUtil.numberToString(this.reward.getKilometerRewardMotor(), 2), this.editable, "KilometerRewardMotor", holder, pane));
            pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.km.foot", new Serializable[0])));
            pane.add(ClientSwingUtil.createParameterTextField(20, this.reward.getKilometerRewardFoot() == null ? null : ClientFormUtil.numberToString(this.reward.getKilometerRewardFoot(), 2), this.editable, "KilometerRewardFoot", holder, pane));
            pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.km.bike", new Serializable[0])));
            pane.add(ClientSwingUtil.createParameterTextField(20, this.reward.getKilometerRewardBike() == null ? null : ClientFormUtil.numberToString(this.reward.getKilometerRewardBike(), 2), this.editable, "KilometerRewardBike", holder, pane));
            pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.reward.starttime", new Serializable[0])));
            pane.add(ClientSwingUtil.createParameterTextField(20, TimeUtil.formatDate(this.reward.getStartTime(), FormUtil.DATEFORMAT), this.editable, "StartTime", holder, pane));
            SpringUtilities.makeCompactGrid(pane, 5, 2, 5, 5, 5, 5);
            return pane;
        }

        @Override
        protected Action getOkAction() {
            return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
                private static final long serialVersionUID = -1968753147880472466L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AreaDelivererRewardPane.this.checkRewards(SubRewardDialog.this)) {
                        SubRewardDialog.this.dispose();
                        AreaDelivererRewardPane.this.deliverer.addAReward(SubRewardDialog.this.reward);
                        AreaDelivererRewardPane.this.rewardList.add(SubRewardDialog.this);
                        AreaDelivererRewardPane.this.fillData();
                    }
                }
            };
        }

        @Override
        protected Action getCancelAction() {
            return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
                private static final long serialVersionUID = -5719685265883680209L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AreaDelivererRewardPane.this.rewardList.contains(SubRewardDialog.this)) {
                        SubRewardDialog.this.reward.delete();
                    } else if (SubRewardDialog.this.editable) {
                        SubRewardDialog.this.reward.setStartTime(SubRewardDialog.this.oldStartTime);
                        SubRewardDialog.this.reward.setHourReward(SubRewardDialog.this.OldHourReward);
                        SubRewardDialog.this.reward.setKilometerRewardBike(SubRewardDialog.this.oldBike);
                        SubRewardDialog.this.reward.setKilometerRewardFoot(SubRewardDialog.this.oldFoot);
                        SubRewardDialog.this.reward.setKilometerRewardMotor(SubRewardDialog.this.oldMotor);
                    }
                    SubRewardDialog.this.dispose();
                    AreaDelivererRewardPane.this.fillData();
                }
            };
        }

        private void createRewardSubPane(final AreaDelivererRewardModel m, boolean editable) {
            this.display = new JTextField(AreaDelivererRewardPane.this.getRewardString(m));
            this.display.setBorder(new EmptyBorder(5, 5, 5, 5));
            if (m != null) {
                this.display.setEnabled(false);
                this.display.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        SubRewardDialog dialog = SubRewardDialog.this;
                        dialog.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent e) {
                                SubRewardDialog.this.display.setText(AreaDelivererRewardPane.this.getRewardString(m));
                            }
                        });
                        dialog.buildLayout();
                        dialog.pack();
                        SwingUtils.center((Window)dialog, AreaDelivererRewardPane.this.parent);
                        dialog.setVisible(true);
                    }
                });
            }
        }
    }
}

