/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.action;

import de.datomino.peppergis.areamanager.gui.AreaManagerCalendarGui;
import de.datomino.peppergis.areamanager.gui.AreaManagerMapGui;
import de.datomino.peppergis.areamanager.util.AreaScheduleEntity;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModel;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.ktde.util.datatypes.Tupel;

public class ShowSelectedSchedulesAction
extends AbstractAction {
    private static final long serialVersionUID = 3300804306807965436L;
    private AreaManagerCalendarGui areaManager;

    public ShowSelectedSchedulesAction(AreaManagerCalendarGui areaManager) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("gui.historyTour.show", new Serializable[0]));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 0));
        this.areaManager = areaManager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AreaManagerMapGui mapGui = this.areaManager.getAreaManagerMapGui();
        Map<AreaScheduleEntity, Tupel<Integer, Integer>> selectedSchedules = this.areaManager.getPlanTablePane().getSelectedObjects();
        if (selectedSchedules == null || selectedSchedules.isEmpty() || !this.hasHistoryTour(selectedSchedules)) {
            JOptionPane.showMessageDialog(this.areaManager, ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.noTour", new Serializable[0]));
            return;
        }
        this.areaManager.getTabbedPane().setSelectedComponent(mapGui);
        for (AreaScheduleEntity entity : selectedSchedules.keySet()) {
            AreaObjectModel area = null;
            for (AreaTourScheduleModel schedule : entity.getModel()) {
                if (schedule.getAreaObject() == null) continue;
                area = schedule.getAreaObject();
                break;
            }
            for (HistoryAreaTourModelWageResult t : entity.getHistoryResult()) {
                mapGui.addAreaTourMapNode(area, t);
            }
        }
        mapGui.repaintGui(true);
    }

    private boolean hasHistoryTour(Map<AreaScheduleEntity, Tupel<Integer, Integer>> selectedSchedules) {
        for (AreaScheduleEntity entity : selectedSchedules.keySet()) {
            if (entity.getHistoryResult().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

