/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.action;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.logistic.dto.LogisticTourPartDto;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.areamanager.action.gpxhack.ExtensionsType;
import de.datomino.peppergis.areamanager.action.gpxhack.GpxType;
import de.datomino.peppergis.areamanager.action.gpxhack.MetadataType;
import de.datomino.peppergis.areamanager.action.gpxhack.ObjectFactory;
import de.datomino.peppergis.areamanager.action.gpxhack.TrkType;
import de.datomino.peppergis.areamanager.action.gpxhack.TrksegType;
import de.datomino.peppergis.areamanager.action.gpxhack.WptType;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.util.DefaultLogisticTourUtil;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutableLineStringDto;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.geo.util.GeoUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.datatypes.Tupel;

public class GpxHack {
    private static final ObjectFactory GPX_OBJECT_FACTORY = new ObjectFactory();
    private static final DatatypeFactory DATATYPE_FACTORY;
    private static final JAXBContext JAXB_CONTEXT;

    public static void createGpx(LogisticTourDto<PointEntityId> tour, ModelEnviroment modelEnviroment) {
        Double parcelLocation = tour.getParcelLocation() == null ? 1.0 : tour.getParcelLocation() / 100.0;
        GpxType gpx = GPX_OBJECT_FACTORY.createGpxType();
        gpx.setVersion("1.1");
        MetadataType metadata = GPX_OBJECT_FACTORY.createMetadataType();
        gpx.setMetadata(metadata);
        TrkType trk = GPX_OBJECT_FACTORY.createTrkType();
        ExtensionsType ext = GPX_OBJECT_FACTORY.createExtensionsType();
        ext.setDistance(BigInteger.valueOf(tour.getDistanceSum().intValue()));
        ext.setDuration(BigInteger.valueOf(tour.getDurationSum().intValue()));
        ext.setParcelDistance(BigInteger.valueOf(PrimitiveUtil.nullToZero(tour.getAccessSum())));
        ext.setStreetDistance(BigInteger.valueOf(PrimitiveUtil.nullToZero(tour.getDistanceSum()) - PrimitiveUtil.nullToZero(tour.getAccessSum())));
        double speed = 1.3888888888888888;
        RouteVehicleType routeVehicleType = tour.getTourParts().get(0).getRouteVehicleType() == null ? RouteVehicleType.FOOT : tour.getTourParts().get(0).getRouteVehicleType();
        switch (routeVehicleType) {
            case BIKE: {
                speed = 2.0833333333333335;
                break;
            }
            case FOOT: {
                break;
            }
            case MOTORCAR: {
                speed = 13.88888888888889;
            }
        }
        Double difficultLevel = tour.getDifficultLevel();
        speed = speed * difficultLevel / 100.0;
        long parcelDuration = Math.round((double)PrimitiveUtil.nullToZero(tour.getAccessSum()) / speed);
        ext.setParcelDuration(BigInteger.valueOf(parcelDuration));
        ext.setStreetDuration(BigInteger.valueOf((long)tour.getDurationSum().intValue() - parcelDuration));
        trk.setExtensions(ext);
        trk.setName("Tour");
        TrksegType seg = GPX_OBJECT_FACTORY.createTrksegType();
        List<WptType> trkpt = seg.getTrkpt();
        GregorianCalendar gc = new GregorianCalendar();
        int count = 0;
        ImmutablePoint lastPoint = null;
        LogisticStopDto<PointEntityId> lastStop = null;
        LogisticStopDto<PointEntityId> nextStop = null;
        ArrayList<Tupel<Integer, Integer>> distanceTupels = new ArrayList<Tupel<Integer, Integer>>();
        for (LogisticTourPartDto<PointEntityId> tourPart : tour.getTourParts()) {
            for (int j = 0; j < tourPart.getStopDtos().size(); ++j) {
                ImmutableLineString lineString;
                DefaultLogisticTourUtil.calculateAccessDistance(tourPart.getStopDtos());
                WptType wpt = null;
                LogisticStopDto<PointEntityId> stop = tourPart.getStopDtos().get(j);
                nextStop = j + 1 < tourPart.getStopDtos().size() ? tourPart.getStopDtos().get(j + 1) : null;
                ImmutableLineStringDto lineStringDto = stop.getLocation().getLineString();
                ImmutableLineString immutableLineString = lineString = lineStringDto == null ? null : (ImmutableLineString)lineStringDto.getGeoObject();
                if (lineString == null) {
                    ImmutablePoint geom;
                    ImmutablePointDto geomDto = stop.getLocation().getGeom();
                    ImmutablePoint immutablePoint = geom = geomDto == null ? null : (ImmutablePoint)geomDto.getGeoObject();
                    if (!(geom == null || lastPoint != null && lastPoint.equals(geom))) {
                        geom = (ImmutablePoint)geom.getTransformed(Wgs84Factory.INSTANCE);
                        wpt = GPX_OBJECT_FACTORY.createWptType();
                        wpt.setName(Integer.toString(count));
                        wpt.setLat(BigDecimal.valueOf(geom.getY()));
                        wpt.setLon(BigDecimal.valueOf(geom.getX()));
                        wpt.setDesc("");
                        trkpt.add(wpt);
                        ++count;
                        lastPoint = geom;
                    }
                } else {
                    for (ImmutablePoint geom : lineString.getCoordinates()) {
                        if (geom == null || lastPoint != null && lastPoint.equals(geom)) continue;
                        geom = (ImmutablePoint)geom.getTransformed(Wgs84Factory.INSTANCE);
                        wpt = GPX_OBJECT_FACTORY.createWptType();
                        wpt.setName(Integer.toString(count));
                        wpt.setLat(BigDecimal.valueOf(geom.getY()));
                        wpt.setLon(BigDecimal.valueOf(geom.getX()));
                        wpt.setDesc("");
                        trkpt.add(wpt);
                        ++count;
                        lastPoint = geom;
                    }
                }
                if (wpt != null) {
                    ExtensionsType stopExt = GPX_OBJECT_FACTORY.createExtensionsType();
                    GpxHack.addTimesAndDistances(stopExt, lastStop, stop, nextStop, distanceTupels, parcelLocation, speed, modelEnviroment);
                    BigInteger add = stopExt.getParcelDuration().add(stopExt.getStreetDuration());
                    gc.add(13, add.intValue());
                    wpt.setTime(DATATYPE_FACTORY.newXMLGregorianCalendar(gc));
                    wpt.setExtensions(stopExt);
                }
                lastStop = stop;
            }
        }
        if (!trkpt.isEmpty()) {
            WptType last = trkpt.get(trkpt.size() - 1);
            ExtensionsType lastExtensions = last.getExtensions();
            lastExtensions.setStreetDistance(ext.getStreetDistance());
            lastExtensions.setStreetDuration(ext.getStreetDuration());
        }
        boolean found = false;
        trk.getTrkseg().add(seg);
        gpx.getTrk().add(trk);
        try {
            FileOutputStream fos = new FileOutputStream("/tmp/test.gpx");
            JAXB_CONTEXT.createMarshaller().marshal(GPX_OBJECT_FACTORY.createGpx(gpx), fos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    private static void addTimesAndDistances(ExtensionsType stopExt, LogisticStopDto<PointEntityId> pred, LogisticStopDto<PointEntityId> succ, LogisticStopDto<PointEntityId> next, List<Tupel<Integer, Integer>> distanceTupels, Double parcelLocation, double speed, ModelEnviroment modelEnviroment) {
        int predMetersFromStart = 0;
        int succMetersFromStart = 0;
        double accessDistance = succ.getAccessDistanceFromPred();
        double streetDistance = distanceTupels.isEmpty() ? 0.0 : (double)distanceTupels.get(distanceTupels.size() - 1).getElement1().intValue();
        LogisticLocationDto<PointEntityId> succLocation = succ.getLocation();
        Coordinate accessSucc = ((ImmutablePoint)succLocation.getAccessGeom().getGeoObject()).getCoordinate();
        Coordinate geomSucc = ((ImmutablePoint)succLocation.getGeom().getGeoObject()).getCoordinate();
        double distanceSucc = GeoUtils.getDistanceInMeter(accessSucc, geomSucc) * (succLocation.getParcelLocation() == null ? parcelLocation : succLocation.getParcelLocation());
        if (pred != null) {
            predMetersFromStart = pred.getStreetMileageMetersFromStart() == null ? 0 : pred.getStreetMileageMetersFromStart();
            succMetersFromStart = succ.getStreetMileageMetersFromStart() == null ? 0 : succ.getStreetMileageMetersFromStart();
            streetDistance += (double)(succMetersFromStart - predMetersFromStart) - accessDistance;
        } else {
            streetDistance = 0.0;
            accessDistance = distanceSucc;
        }
        int streetDistanceInt = (int)Math.round(streetDistance);
        int accessDistanceInt = (int)Math.round(accessDistance);
        distanceTupels.add(new Tupel<Integer, Integer>(streetDistanceInt, accessDistanceInt));
        stopExt.setParcelDistance(BigInteger.valueOf(accessDistanceInt));
        stopExt.setStreetDistance(BigInteger.valueOf(streetDistanceInt));
        stopExt.setParcelDuration(BigInteger.valueOf(Math.round(accessDistance / speed)));
        stopExt.setStreetDuration(BigInteger.valueOf(Math.round(streetDistance / speed)));
        GpxHack.addObjectIdentifiers(stopExt, succ, modelEnviroment);
    }

    private static void addObjectIdentifiers(ExtensionsType stopExt, LogisticStopDto<PointEntityId> succ, ModelEnviroment modelEnviroment) {
        PointEntityId pointEntityId = (PointEntityId)succ.getId();
        Long rId = pointEntityId.getId();
        switch (pointEntityId.getPointEnityType()) {
            case PARCEL: {
                ParcelModel parcel = modelEnviroment.getModelCache().getModel(ParcelModel.class, rId);
                if (parcel == null) break;
                stopExt.getIdParcel().add(parcel.getImportKey());
                break;
            }
            case SUBSCRIPTION: {
                SubscriptionModel sub = modelEnviroment.getModelCache().getModel(SubscriptionModel.class, rId);
                if (sub == null) break;
                stopExt.getIdSubscription().add(sub.getSubscriptionNumber());
            }
        }
    }

    static {
        try {
            DATATYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            JAXB_CONTEXT = JAXBContext.newInstance(GpxType.class);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

