/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.action;

import de.datomino.logistic.dto.OptimizationAlgorithmType;
import de.datomino.logistic.type.RouteBackType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.logistic.type.RoutingType;
import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.areamanager.gui.AreaManagerCalendarGui;
import de.datomino.peppergis.areamanager.gui.AreaManagerMapGui;
import de.datomino.peppergis.areamanager.gui.calculation.AreaTourCalculationPane;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectLogisticTourMapNode;
import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.file.FileUtil;
import de.datomino.peppergis.client.gui.areatour.AbstractAreaTourCalculationOrderNotPossibleDialog;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.BlockDescriptor;
import de.datomino.peppergis.client.manager.filter.AllObjectFilterLayerRenderer;
import de.datomino.peppergis.client.manager.legend.AreaObjectTourLegendType;
import de.datomino.peppergis.client.model.AreaTourExportModelsHolder;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.client.util.DeliveryRoundModelUtil;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.exporter.AreaTourExportDto;
import de.datomino.peppergis.dto.exporter.TourExportDto;
import de.datomino.peppergis.dto.exporter.TourExportFormat;
import de.datomino.peppergis.tour.AreaTourParameter;
import de.datomino.peppergis.tour.CalculationWay;
import de.datomino.peppergis.tour.ParcelParameter;
import de.datomino.peppergis.tour.SubscriptionParameter;
import de.datomino.peppergis.type.LetterDeliveryType;
import de.datomino.peppergis.type.SubscriptionDeliveryType;
import de.datomino.peppergis.type.SubscriptionStatus;
import de.datomino.peppergis.type.areatourtype.AreaCalculationType;
import de.datomino.peppergis.type.areatourtype.AreaObjectType;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import de.datomino.peppergis.util.StringComparator;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.ErrorMessageDialog;
import de.datomino.util.swing.ExceptionMessageDialog;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.lang.math.NumberUtils;
import org.ktde.util.NameGenerator;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateAreasAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculateAreasAction.class);
    private static final long serialVersionUID = 4471364620815287608L;
    private AreaManagerCalendarGui areaManager;
    private AreaTourCalculationPane areaTourCalculationPane;

    public CalculateAreasAction(String titel, AreaManagerCalendarGui areaManager) {
        super(titel);
        this.areaManager = areaManager;
        this.areaTourCalculationPane = new AreaTourCalculationPane(this.areaManager.getModelEnviroment(), this.areaManager.getCurrentLayer()){
            private static final long serialVersionUID = 6101889981991365102L;

            @Override
            protected List<Model> getPreOrder(AreaObjectModel area, RouteVehicleType routeVehicleType) {
                AreaObjectTourLegendType tourLegendType = null;
                if (routeVehicleType != null) {
                    switch (routeVehicleType) {
                        case BIKE: {
                            tourLegendType = AreaObjectTourLegendType.BIKE;
                            break;
                        }
                        case FOOT: {
                            tourLegendType = AreaObjectTourLegendType.FOOT;
                            break;
                        }
                        case MOTORCAR: {
                            tourLegendType = AreaObjectTourLegendType.MOTORCAR;
                        }
                    }
                }
                return CalculateAreasAction.this.areaManager.getCurrentlyShownModelsForArea(area, tourLegendType);
            }
        };
        this.areaTourCalculationPane.setCalculationWays(CalculationWay.values());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final JDialog routingDialog = new JDialog(SwingUtils.findWindowParent(this.areaManager), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.tours.calculation", new Serializable[0]), Dialog.ModalityType.DOCUMENT_MODAL);
        routingDialog.setIconImage(PeppergisConstants.ICON_IMAGE);
        routingDialog.getContentPane().setLayout(new BorderLayout());
        routingDialog.getContentPane().add((Component)this.areaTourCalculationPane, "Center");
        JPanel buttonPane = new JPanel(new FlowLayout());
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -3226483284028024783L;

            @Override
            public void actionPerformed(ActionEvent e) {
                routingDialog.dispose();
            }
        }));
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.show1", new Serializable[0])){
            private static final long serialVersionUID = 3902069770389895154L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                routingDialog.dispose();
                Collection<BlockDescriptor> blocks = CalculateAreasAction.this.areaTourCalculationPane.getBlockDescriptors();
                RoutingType routingType = CalculateAreasAction.this.areaTourCalculationPane.getRoutingType();
                Collection<Tripel<RouteVehicleType, RouteVehicleType, RouteVehicleType>> vehicles = CalculateAreasAction.this.areaTourCalculationPane.getRouteVehicleTypes();
                int sizeOfStartBlock = CalculateAreasAction.this.areaTourCalculationPane.getSizeOfStartBlock();
                int sizeOfEndBlock = CalculateAreasAction.this.areaTourCalculationPane.getSizeOfEndBlock();
                RouteVehicleType mainRouteVehicleType = null;
                Iterator<Tripel<RouteVehicleType, RouteVehicleType, RouteVehicleType>> iter = vehicles.iterator();
                if (iter.hasNext()) {
                    mainRouteVehicleType = iter.next().getElement1();
                }
                boolean fixingNotSetOrAllowed = true;
                if (sizeOfStartBlock > 0 || sizeOfEndBlock > 0) {
                    while (iter.hasNext()) {
                        RouteVehicleType next = iter.next().getElement1();
                        if (next == mainRouteVehicleType) continue;
                        fixingNotSetOrAllowed = false;
                        break;
                    }
                } else {
                    mainRouteVehicleType = null;
                }
                if (!fixingNotSetOrAllowed) {
                    JOptionPane.showMessageDialog(SwingUtils.findWindowParent(CalculateAreasAction.this.areaManager), ModelEnviroment.getMessageResolver().resolveMessage("messages.areatour.calculation.fixingOnlyWithOneVehicleAllowed", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                } else {
                    ArrayList<AreaTourParameter.BlockDescriptor> blockDescriptorDtos = new ArrayList<AreaTourParameter.BlockDescriptor>(blocks.size());
                    for (BlockDescriptor block : blocks) {
                        blockDescriptorDtos.add(new AreaTourParameter.BlockDescriptor(block.getParcelAttributeValueDescriptorModel().getKey(), block.getValue(), block.getParcelBlockType()));
                    }
                    boolean preferExclusions = CalculateAreasAction.this.areaTourCalculationPane.isPreferExclusions();
                    RouteBackType back = CalculateAreasAction.this.areaTourCalculationPane.getRouteBackType();
                    DeliveryRoundModel deliveryRoundModel = CalculateAreasAction.this.areaTourCalculationPane.getDeliveryRound();
                    final Collection<Tupel<AreaObjectModel, List<Model>>> areas = CalculateAreasAction.this.areaTourCalculationPane.getSelectedAreaObjects(mainRouteVehicleType);
                    TreeSet<Tupel<String, String>> noPreSortAvaiable = new TreeSet<Tupel<String, String>>();
                    if (sizeOfStartBlock > 0 || sizeOfEndBlock > 0) {
                        for (Tupel<AreaObjectModel, List<Model>> tupel : areas) {
                            if (tupel.getElement2() != null) continue;
                            AreaObjectModel area = tupel.getElement1();
                            noPreSortAvaiable.add(new Tupel<String, String>(area.getShortcut(), area.getDisplayname()));
                        }
                    }
                    if (!noPreSortAvaiable.isEmpty()) {
                        String areaString = StringUtil.implode(noPreSortAvaiable, "\n", new NameGenerator<Tupel<String, String>>(){

                            @Override
                            public String getName(Tupel<String, String> tupel) {
                                return tupel.getElement1() + " - " + tupel.getElement2();
                            }
                        });
                        JOptionPane.showMessageDialog(SwingUtils.findWindowParent(CalculateAreasAction.this.areaManager), ModelEnviroment.getMessageResolver().resolveMessage("messages.areatour.calculation.noPreSortOrderAvaiable", new Serializable[]{areaString}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                    } else if (deliveryRoundModel == null) {
                        JOptionPane.showMessageDialog(SwingUtils.findWindowParent(CalculateAreasAction.this.areaManager), ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound.error.noDeliveryRoundSelected", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                    } else if (CalculateAreasAction.this.checkSelection(areas, routingType)) {
                        Collection<Tupel<AreaObjectModel, List<Model>>> noRounds;
                        final HashSet<AreaTourParameter> parameters = new HashSet<AreaTourParameter>();
                        AreaObjectType areaObjectType = DeliveryRoundModelUtil.getAreaObjectTypeForDeliveryRound(deliveryRoundModel);
                        AreaCalculationType areaCalculationType = CalculateAreasAction.this.areaTourCalculationPane.getAreaCalculationType();
                        if (CalculateAreasAction.this.areaTourCalculationPane.getSelectedCalculationWay() == CalculationWay.PARCEL_ORDER) {
                            areaCalculationType = AreaCalculationType.PARCEL_SORT_ORDER;
                        }
                        AreaTourType areaTourType = new AreaTourType(areaObjectType, areaCalculationType);
                        Date date = CalculateAreasAction.this.areaTourCalculationPane.getDate();
                        boolean isPoi = CalculateAreasAction.this.areaTourCalculationPane.isPoi();
                        boolean isStartPickPoint = CalculateAreasAction.this.areaTourCalculationPane.isStartPickPoint();
                        boolean isEndPickPoint = CalculateAreasAction.this.areaTourCalculationPane.isEndPickPoint();
                        Collection<SubscriptionDeliveryType> subscriptionTypes = CalculateAreasAction.this.areaTourCalculationPane.getSubscriptionDeliveryTypes();
                        Collection<SubscriptionStatus> subscriptionStatus = CalculateAreasAction.this.areaTourCalculationPane.getSubscriptionStatus();
                        Collection<LetterDeliveryType> letterTypes = CalculateAreasAction.this.areaTourCalculationPane.getLetterDeliveryTypes();
                        for (Tripel<RouteVehicleType, RouteVehicleType, RouteVehicleType> vehicle : vehicles) {
                            Object algorithmType;
                            AreaTourParameter parameter = null;
                            switch (areaTourType.getAreaObjectType()) {
                                case PARCEL: {
                                    parameter = new ParcelParameter(areaTourType, isPoi, isStartPickPoint, isEndPickPoint, back, date);
                                    break;
                                }
                                case PARCEL_WITHOUT_SUBSCRIPTION: 
                                case SUBSCRIPTION: 
                                case LETTER: 
                                case PARCEL_WITH_LETTER: 
                                case PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER: 
                                case SUBSCRIPTION_WITH_LETTER: 
                                case PARCEL_SUBSCRIPTION: 
                                case PARCEL_SUBSCRIPTION_LETTER: {
                                    parameter = new SubscriptionParameter(areaTourType, isPoi, isStartPickPoint, isEndPickPoint, back, date, subscriptionStatus, subscriptionTypes, letterTypes);
                                }
                            }
                            Object object = algorithmType = areaTourType.getAreaCalculationType() == AreaCalculationType.SIDE ? OptimizationAlgorithmType.DEFAULT_STREET_SIDE : OptimizationAlgorithmType.DEFAULT_SEGMENT_MIDDLE;
                            if (parameter == null) {
                                return;
                            }
                            parameter.setParcelBlock(blockDescriptorDtos);
                            parameter.setPreferExclusion(preferExclusions);
                            parameter.setRouteVehicleTypeInArea(vehicle.getElement1());
                            parameter.setRouteTypeInArea(vehicle.getElement1().getRouteType());
                            parameter.setRouteVehicleTypeFromPoi(vehicle.getElement2());
                            parameter.setRouteTypeFromPoi(vehicle.getElement2().getRouteType());
                            parameter.setRouteVehicleTypeFromPickPoint(vehicle.getElement3());
                            parameter.setRouteTypeFromPickPoint(vehicle.getElement3().getRouteType());
                            parameter.setRoutingType(routingType);
                            parameter.setCalculateWithoutPoi(true);
                            parameter.setAlgorithmType((OptimizationAlgorithmType)((Object)algorithmType));
                            parameter.setSizeOfStartBlock(sizeOfStartBlock);
                            parameter.setSizeOfEndBlock(sizeOfEndBlock);
                            parameter.setRewardEntity(CalculateAreasAction.this.areaTourCalculationPane.getRewardEntity());
                            parameter.setNight(CalculateAreasAction.this.areaTourCalculationPane.getNight());
                            parameter.setDeliveryRoundId(deliveryRoundModel.getId());
                            parameter.setDifficultyLevelDescriptor(CalculateAreasAction.this.areaTourCalculationPane.isWithDifficultyLevel());
                            parameter.setParcelLocationDescriptor(CalculateAreasAction.this.areaTourCalculationPane.isWithParcelLocation());
                            parameters.add(parameter);
                        }
                        if (CalculateAreasAction.this.areaTourCalculationPane.isSelfParameter() && !(noRounds = AreaObjectModelUtil.checkDeliveryRound(areas, CalculateAreasAction.this.areaTourCalculationPane.getDate())).isEmpty()) {
                            int d;
                            StringBuilder sb = new StringBuilder();
                            int i = 0;
                            for (Tupel tupel : noRounds) {
                                if (i > 10) {
                                    sb.append("\n ......");
                                    break;
                                }
                                sb.append("\n").append(AreaObjectModelUtil.getShortcutAndDisplayname((AreaObjectModel)tupel.getElement1()));
                                ++i;
                            }
                            if ((d = JOptionPane.showConfirmDialog(CalculateAreasAction.this.areaTourCalculationPane, ModelEnviroment.getMessageResolver().resolveMessage("gui.area.ignore.noDeliveryRounds", new Serializable[]{Integer.valueOf(noRounds.size()), sb.toString()}), "", 0)) != 0) {
                                return;
                            }
                            areas.removeAll(noRounds);
                        }
                        final CalculationWay selectedCalculationWay = CalculateAreasAction.this.areaTourCalculationPane.getSelectedCalculationWay();
                        final TourExportFormat tourExportType = CalculateAreasAction.this.areaTourCalculationPane.getTourExportType();
                        Tupel<Collection<Tupel<AreaObjectModel, List<Model>>>, Collection<Tupel<AreaObjectModel, List<Model>>>> tupel = CalculateAreasAction.this.areaTourCalculationPane.checkForBrokenOrders();
                        final Collection<Tupel<AreaObjectModel, List<Model>>> origAreas = tupel.getElement1();
                        final Collection<Tupel<AreaObjectModel, List<Model>>> collection = tupel.getElement2();
                        if (origAreas.isEmpty() && collection.isEmpty()) {
                            try {
                                CalculateAreasAction.this.executeCalculation(areas, parameters, selectedCalculationWay, tourExportType, CalculateAreasAction.this.areaTourCalculationPane.isSelfParameter());
                            }
                            finally {
                                routingDialog.dispose();
                            }
                        } else {
                            AbstractAreaTourCalculationOrderNotPossibleDialog areaTourCalculationOrderNotPossibleDialog = new AbstractAreaTourCalculationOrderNotPossibleDialog(SwingUtils.findWindowParent(CalculateAreasAction.this.areaManager), origAreas, collection){
                                private static final long serialVersionUID = 865379616950158146L;

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                protected void doOk(Collection<Tupel<AreaObjectModel, List<Model>>> areaObjectsToSkip, Collection<Tupel<AreaObjectModel, List<Model>>> areaObjectsForOptimize, Collection<Tupel<AreaObjectModel, List<Model>>> areaObjectsForOrig, Collection<Tupel<AreaObjectModel, List<Model>>> areaObjectsForParcel) {
                                    CollectionUtil.removeFromOnlyFirstMatch(areas, origAreas);
                                    CollectionUtil.removeFromOnlyFirstMatch(areas, collection);
                                    LinkedList<Tupel<AreaObjectModel, List<Model>>> toOptimize = new LinkedList<Tupel<AreaObjectModel, List<Model>>>(areaObjectsForOptimize);
                                    LinkedList<Tupel<AreaObjectModel, List<Model>>> toOrig = new LinkedList<Tupel<AreaObjectModel, List<Model>>>(areaObjectsForOrig);
                                    LinkedList<Tupel<AreaObjectModel, List<Model>>> toParcel = new LinkedList<Tupel<AreaObjectModel, List<Model>>>(areaObjectsForParcel);
                                    switch (selectedCalculationWay) {
                                        case OPTIMIZE: {
                                            toOptimize.addAll(areas);
                                            break;
                                        }
                                        case PARCEL_ORDER: {
                                            toParcel.addAll(areas);
                                            break;
                                        }
                                        case SAVED_ORDER: {
                                            toOrig.addAll(areas);
                                            break;
                                        }
                                    }
                                    try {
                                        if (!toOptimize.isEmpty()) {
                                            CalculateAreasAction.this.executeCalculation(toOptimize, parameters, CalculationWay.OPTIMIZE, tourExportType, CalculateAreasAction.this.areaTourCalculationPane.isSelfParameter());
                                        }
                                        if (!toOrig.isEmpty()) {
                                            CalculateAreasAction.this.executeCalculation(toOrig, parameters, CalculationWay.SAVED_ORDER, tourExportType, CalculateAreasAction.this.areaTourCalculationPane.isSelfParameter());
                                        }
                                        if (!toParcel.isEmpty()) {
                                            CalculateAreasAction.this.executeCalculation(toParcel, parameters, CalculationWay.PARCEL_ORDER, tourExportType, CalculateAreasAction.this.areaTourCalculationPane.isSelfParameter());
                                        }
                                    }
                                    finally {
                                        routingDialog.dispose();
                                    }
                                }
                            };
                            areaTourCalculationOrderNotPossibleDialog.setVisible(true);
                        }
                    }
                }
            }
        }));
        JPanel bottomPane = new JPanel(new BorderLayout());
        bottomPane.add((Component)buttonPane, "East");
        routingDialog.getContentPane().add((Component)bottomPane, "South");
        routingDialog.pack();
        SwingUtils.centerDialog(routingDialog, SwingUtils.findWindowParent(this.areaManager));
        routingDialog.setVisible(true);
    }

    private void saveResult(Map<String, byte[]> content) {
        try {
            FileUtil.saveFile(content, this.areaManager, "csv");
        }
        catch (IOException e) {
            ExceptionMessageDialog errorMessageDialog = new ExceptionMessageDialog(SwingUtils.findWindowParent(this.areaManager), e, PeppergisConstants.ICON_IMAGE);
            errorMessageDialog.setVisible(true);
        }
    }

    private void showOnMap(Map<AreaTourParameter, Map<Long, AreaTourExportDto>> map) {
        AreaCaller areaCaller = this.areaManager.getModelEnviroment().getAllCaller().getAreaCaller();
        HashSet<Long> areaObjectIds = new HashSet<Long>();
        for (Map<Long, AreaTourExportDto> value : map.values()) {
            areaObjectIds.addAll(value.keySet());
        }
        Collection<AreaObjectModel> models = areaCaller.fetchAreaObjectsById(areaObjectIds);
        AreaManagerMapGui mapGui = this.areaManager.getAreaManagerMapGui();
        for (AreaObjectModel model : models) {
            for (AreaTourParameter parameter : map.keySet()) {
                Map<Long, AreaTourExportDto> areaObjectMap = map.get(parameter);
                AreaTourExportDto exportDto = areaObjectMap.get(model.getId());
                if (exportDto == null) continue;
                AreaObjectLogisticTourMapNode tourNode = new AreaObjectLogisticTourMapNode(model, exportDto, parameter, new AreaTourExportModelsHolder(this.areaManager.getModelEnviroment(), exportDto));
                AllObjectFilterLayerRenderer renderer = new AllObjectFilterLayerRenderer(true);
                renderer.setWithIndex(true);
                renderer.setNavigatorPanel(this.areaManager.getCurrentNavigatorPanel());
                renderer.setSortOrder(mapGui.getAreaSortOrder(model));
                renderer.setLegendType(AreaObjectTourLegendType.valueOf(parameter.getRouteVehicleTypeInArea().name()));
                renderer.setArea(model, null);
                tourNode.setAllObjectFilterLayerRenderer(renderer);
                Color color = Color.BLACK;
                if (parameter.getRouteVehicleTypeInArea() != null) {
                    switch (parameter.getRouteVehicleTypeInArea()) {
                        case BIKE: {
                            color = PeppergisConstants.BIKE_SEGMENT_COLOR;
                            break;
                        }
                        case FOOT: {
                            color = PeppergisConstants.FOOT_SEGMENT_COLOR;
                            break;
                        }
                        case MOTORCAR: {
                            color = PeppergisConstants.MOTOR_SEGMENT_COLOR;
                        }
                    }
                }
                tourNode.setColor(color);
                if (exportDto.getGroup().isEmpty()) {
                    mapGui.addAreaTourMapNode(model, tourNode);
                    continue;
                }
                ArrayList<Long> ids = new ArrayList<Long>();
                for (AreaTourExportDto dto : exportDto.getGroup()) {
                    ids.add(dto.getAreaObjectId());
                }
                ArrayList<AreaObjectModel> children = new ArrayList<AreaObjectModel>();
                Collection<AreaObjectModel> as = areaCaller.fetchAreaObjectsById(ids);
                block9: for (Long id : ids) {
                    for (AreaObjectModel a : as) {
                        if (!a.getId().equals(id)) continue;
                        children.add(a);
                        continue block9;
                    }
                }
                mapGui.addAreaGroupMapNode(children, exportDto.getGroupName(), tourNode);
            }
        }
        mapGui.repaintGui(true);
    }

    private boolean checkSelection(Collection<Tupel<AreaObjectModel, List<Model>>> areas, RoutingType routingType) {
        int maxSize = 10;
        String maxSizeString = StringUtil.getNotNull(ModelEnviroment.getProperties().getProperty("area.calculation.maxSize")).trim();
        if (NumberUtils.isDigits(maxSizeString)) {
            maxSize = Integer.parseInt(maxSizeString);
        } else if (!StringUtil.isBlank(maxSizeString)) {
            LOGGER.warn("calculation max size is not acceptable +" + maxSizeString);
        }
        if (areas == null || areas.isEmpty()) {
            JOptionPane.showMessageDialog(this.areaManager, ModelEnviroment.getMessageResolver().resolveMessage("gui.input.selectError.area", new Serializable[0]), "", 2);
            return false;
        }
        if (areas.size() > maxSize) {
            JOptionPane.showMessageDialog(this.areaManager, ModelEnviroment.getMessageResolver().resolveMessage("gui.area.calculation.maxSize", Integer.valueOf(maxSize)), "", 2);
            return false;
        }
        if (routingType.isStartWithPoi()) {
            HashSet<AreaObjectModel> noPoi = new HashSet<AreaObjectModel>();
            for (Tupel<AreaObjectModel, List<Model>> t : areas) {
                AreaObjectModel a2 = t.getElement1();
                if (a2.getPoi() != null) continue;
                noPoi.add(a2);
            }
            if (!noPoi.isEmpty()) {
                List ss = noPoi.stream().map(a -> a.getShortcut()).collect(Collectors.toList());
                ss.sort(new StringComparator(true));
                ss.add(0, ModelEnviroment.getMessageResolver().resolveMessage("gui.route.message.noPoi", new Serializable[0]));
                JLabel message = new JLabel("<html>" + StringUtil.implode(ss, "<br> - ") + "</html>");
                Object[] options = new Object[]{ModelEnviroment.getMessageResolver().resolveMessage("messages.default.continue", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])};
                int d = JOptionPane.showOptionDialog(this.areaManager, message, "", 0, 2, null, options, options[1]);
                switch (d) {
                    case 1: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private void executeCalculation(final Collection<Tupel<AreaObjectModel, List<Model>>> areas, final Collection<AreaTourParameter> parameters, final CalculationWay selectedCalculationWay, final TourExportFormat tourExportType, final boolean selfParameter) {
        AbstractAsynchronousDialog<TourExportDto> asynchronousDialog = new AbstractAsynchronousDialog<TourExportDto>(SwingUtils.findWindowParent(this.areaManager), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.routing", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]), 1, true, this.areaManager.getModelEnviroment()){
            private static final long serialVersionUID = -9010756475037313167L;

            @Override
            protected AsynchronousDto<TourExportDto> getAsynchronousDto(String token) {
                return this.modelEnviroment.getAllCaller().getAsynchronousCaller().calculateAreasResult(token);
            }

            @Override
            protected String startAsynchronous() {
                return this.modelEnviroment.getAllCaller().getAsynchronousCaller().calculateAreas(areas, parameters, tourExportType, selectedCalculationWay, selfParameter);
            }
        };
        try {
            Tupel run = asynchronousDialog.run();
            TourExportDto result = (TourExportDto)run.getElement1();
            if (result != null && !run.getElement2().booleanValue()) {
                if (result.getErrorMessages().hasErrors()) {
                    ErrorMessageDialog dialog = new ErrorMessageDialog(SwingUtils.findWindowParent(this.areaManager), ModelEnviroment.getMessageResolver(), result.getErrorMessages(), PeppergisConstants.ICON_IMAGE);
                    dialog.setVisible(true);
                } else {
                    this.showOnMap(result.getLogisticTours());
                    if (tourExportType != null) {
                        this.saveResult(result.getContent());
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

