/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.pdf.printer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SvgHandler
extends DefaultHandler {
    private StringBuilder sb = new StringBuilder();
    private boolean firstPassed = false;
    private String toImport;
    private boolean removeSvgAndEnrich;
    private Map<String, String> parentAttributes = new HashMap<String, String>();
    private Stack<Set<String>> attributeStack = new Stack();
    private boolean isEmpty = true;
    private boolean inG = false;
    private Integer fontSize;

    public SvgHandler(String toImport) {
        this.toImport = toImport;
        Set emptySet = Collections.emptySet();
        this.attributeStack.push(emptySet);
    }

    public SvgHandler(boolean removeSvgAndEnrich, Integer fontSize) {
        this.removeSvgAndEnrich = removeSvgAndEnrich;
        this.fontSize = fontSize;
        Set emptySet = Collections.emptySet();
        this.attributeStack.push(emptySet);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.inG) {
            this.isEmpty = false;
        }
        if (qName.equalsIgnoreCase("g")) {
            this.inG = true;
        }
        if (this.firstPassed || !this.removeSvgAndEnrich) {
            this.sb.append("<svg:").append(qName);
            HashSet<Object> names = new HashSet<Object>((Collection)this.attributeStack.peek());
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                this.sb.append(" ");
                String string = attributes.getValue(i);
                this.sb.append(name).append("=\"").append(StringEscapeUtils.escapeXml(string)).append("\"");
                names.add(name);
            }
            if (!this.firstPassed) {
                this.sb.append(" xmlns:svg=\"http://www.w3.org/2000/svg\"");
                this.firstPassed = true;
            }
            if (this.removeSvgAndEnrich) {
                boolean isText = qName.equalsIgnoreCase("text");
                for (Map.Entry entry : this.parentAttributes.entrySet()) {
                    String name = (String)entry.getKey();
                    if (names.contains(name) || isText && name.equalsIgnoreCase("font-size")) continue;
                    this.sb.append(" ").append(name).append("=\"").append((String)entry.getValue()).append("\"");
                }
                if (isText) {
                    this.sb.append(" font-size=\"").append(this.fontSize).append("\"");
                }
                this.attributeStack.push(names);
            }
            this.sb.append(">");
        } else {
            this.firstPassed = true;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                if (name.startsWith("xmlns") || name.startsWith("font")) continue;
                String value = attributes.getValue(i);
                this.parentAttributes.put(name, value);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (qName.equalsIgnoreCase("g")) {
            this.inG = false;
        }
        if (qName.equals("svg")) {
            if (this.toImport != null) {
                this.sb.append(this.toImport);
            }
            if (!this.removeSvgAndEnrich) {
                this.sb.append("</svg:").append(qName).append(">");
            }
        } else {
            this.sb.append("</svg:").append(qName).append(">");
        }
        if (this.removeSvgAndEnrich) {
            this.attributeStack.pop();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        String s = new String(ch, start, length);
        this.sb.append(StringEscapeUtils.escapeXml(s));
    }

    public String getResult() {
        return this.sb.toString();
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }
}

