/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.pdf.printer;

import java.awt.Color;
import java.awt.Image;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.ktde.util.datatypes.Tripel;

public class PrintingObject {
    private String text;
    private Image image;
    private List<Tripel<Integer, String, Color>> header = new LinkedList<Tripel<Integer, String, Color>>();
    private List<Tripel<List<String>, List<String>, Color>> table = new LinkedList<Tripel<List<String>, List<String>, Color>>();

    public PrintingObject(String text, Image image) {
        this.text = this.replaceInvalidChar(text);
        this.image = image;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = this.replaceInvalidChar(text);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public List<Tripel<Integer, String, Color>> getHeader() {
        return this.header;
    }

    public void setHeader(List<Tripel<Integer, String, Color>> header) {
        this.header.clear();
        if (header != null) {
            for (Tripel<Integer, String, Color> tripel : header) {
                this.header.add(new Tripel<Integer, String, Color>(tripel.getElement1(), this.replaceInvalidChar(tripel.getElement2()), tripel.getElement3()));
            }
        }
    }

    public List<Tripel<List<String>, List<String>, Color>> getTable() {
        return this.table;
    }

    public void setTable(List<Tripel<List<String>, List<String>, Color>> table) {
        this.table.clear();
        if (table != null) {
            for (Tripel<List<String>, List<String>, Color> tripel : table) {
                Tripel<Object, Object, Object> newTripel = new Tripel<Object, Object, Object>(null, null, null);
                ArrayList<String> newElements1 = new ArrayList<String>(tripel.getElement1().size());
                for (String s : tripel.getElement1()) {
                    newElements1.add(this.replaceInvalidChar(s));
                }
                newTripel.setElement1(newElements1);
                if (tripel.getElement2() != null && !tripel.getElement2().isEmpty()) {
                    ArrayList<String> newElements2 = new ArrayList<String>(tripel.getElement2().size());
                    for (String s : tripel.getElement2()) {
                        newElements2.add(this.replaceInvalidChar(s));
                    }
                    newTripel.setElement2(newElements2);
                }
                newTripel.setElement3(tripel.getElement3());
                this.table.add(newTripel);
            }
        }
    }

    private String replaceInvalidChar(String s) {
        return s == null ? null : s.replaceAll("&", "/");
    }
}

