/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.pdf.printer;

import de.datomino.pdf.engine.Format;
import de.datomino.pdf.printer.ImageInfoBox;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ktde.util.datatypes.Tupel;

public class PrintingInformation<O> {
    private String headLine;
    private String tailLine;
    private String image;
    private Format imageFormat;
    private List<O> os;
    private Map<O, List<Tupel<String, String>>> attributes = new HashMap<O, List<Tupel<String, String>>>();
    private Boolean withAttributes;
    private ImageInfoBox imageInfoBox;

    public PrintingInformation(List<O> os, String imagePath, Format imageFormat) {
        this.image = imagePath;
        this.imageFormat = imageFormat;
        this.os = os;
    }

    public List<Tupel<String, String>> getAttributes(O o) {
        return this.attributes.get(o);
    }

    public void setAttributes(O o, List<Tupel<String, String>> attributes) {
        this.attributes.put(o, attributes);
    }

    public String getImage() {
        return this.image;
    }

    public Format getImageFormat() {
        return this.imageFormat;
    }

    public String getHeadLine() {
        return this.headLine;
    }

    public void setHeadLine(String headLine) {
        this.headLine = headLine;
    }

    public String getTailLine() {
        return this.tailLine;
    }

    public void setTailLine(String tailLine) {
        this.tailLine = tailLine;
    }

    public void setImagePath(String imagePath) {
        this.image = imagePath;
    }

    public List<O> getOs() {
        return this.os;
    }

    public ImageInfoBox getImageInfoBox() {
        return this.imageInfoBox;
    }

    public void setImageInfoBox(ImageInfoBox imageInfoBox) {
        this.imageInfoBox = imageInfoBox;
    }

    public Boolean getWithAttributes() {
        return this.withAttributes;
    }

    public void setWithAttributes(Boolean withAttributes) {
        this.withAttributes = withAttributes;
    }

    public boolean hasMoreThanOneObjects() {
        return this.os.size() > 1;
    }

    public boolean hasAtLeastOneAttribute() {
        if (this.attributes == null) {
            return false;
        }
        for (List<Tupel<String, String>> list : this.attributes.values()) {
            if (list == null || list.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

