/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.pdf.printer;

import de.datomino.pdf.engine.Format;
import de.datomino.pdf.printer.InfoPrintPosition;
import de.datomino.util.swing.ImagePosition;
import java.awt.Font;

public class PrinterInformation {
    public static final String COPYRIGHT = "Copyright\u00a9 datomino GmbH, powered by OpenStreetMap";
    private PrintType printType;
    private String specialMessage;
    private Format format;
    private boolean printAttributes;
    private InfoPrintPosition NamePrintType;
    private String NameRenderingType;
    private String printPrefix;
    private boolean optimalZoom;
    private int dpi;
    private double scale;
    private boolean useVector;
    private double marginX;
    private double marginY;
    private boolean fillupSpace;
    private Font font;
    private Font printPlacesFont;
    private Font printStreetsFont;
    private Font footerFont;
    private boolean underline;
    private boolean withPoi;
    private boolean whiteBackgroundForScale;
    private ImagePosition position;
    private LineGroupType lineGroupType;

    public PrinterInformation(PrintType printType, Format format, boolean printAttributes, String specialMessage, InfoPrintPosition NamePrintType, String NameRenderingType, String prefix, boolean optimalZoom, Integer dpi, Double scale, boolean useVector, double marginX, double marginY, boolean fillupSpace, Font font, Font printPlacesFont, Font printStreetsFont, boolean underline, boolean whiteBackgroundForScale, Font footerFont) {
        this(printType, format, printAttributes, specialMessage, NamePrintType, NameRenderingType, prefix, optimalZoom, dpi, scale, useVector, marginX, marginY, fillupSpace, font, printPlacesFont, printStreetsFont, underline, whiteBackgroundForScale, footerFont, LineGroupType.NORMAL);
    }

    public PrinterInformation(PrintType printType, Format format, boolean printAttributes, String specialMessage, InfoPrintPosition NamePrintType, String NameRenderingType, String prefix, boolean optimalZoom, Integer dpi, Double scale, boolean useVector, double marginX, double marginY, boolean fillupSpace, Font font, Font printPlacesFont, Font printStreetsFont, boolean underline, boolean whiteBackgroundForScale, Font footerFont, LineGroupType lineGroupType) {
        this.printType = printType;
        this.format = format;
        this.printAttributes = printAttributes;
        this.specialMessage = specialMessage;
        this.NamePrintType = NamePrintType;
        this.NameRenderingType = NameRenderingType;
        this.printPrefix = prefix;
        this.optimalZoom = optimalZoom;
        this.dpi = dpi;
        this.scale = scale;
        this.useVector = useVector;
        this.marginX = marginX;
        this.marginY = marginY;
        this.fillupSpace = fillupSpace;
        this.font = font;
        this.printPlacesFont = printPlacesFont;
        this.printStreetsFont = printStreetsFont;
        this.underline = underline;
        this.withPoi = true;
        this.whiteBackgroundForScale = whiteBackgroundForScale;
        this.footerFont = footerFont;
        this.lineGroupType = lineGroupType;
    }

    public PrintType getPrintType() {
        return this.printType;
    }

    public String getSpecialMessage() {
        return this.specialMessage;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean isPrintAttributes() {
        return this.printAttributes;
    }

    public InfoPrintPosition getNamePrintType() {
        return this.NamePrintType;
    }

    public String getNameRenderingType() {
        return this.NameRenderingType;
    }

    public String getPrintPrefix() {
        return this.printPrefix;
    }

    public boolean isOptimalZoom() {
        return this.optimalZoom;
    }

    public Double getScale() {
        return this.scale;
    }

    public Integer getDpi() {
        return this.dpi;
    }

    public boolean isUseVector() {
        return this.useVector;
    }

    public double getMarginX() {
        return this.marginX;
    }

    public double getMarginY() {
        return this.marginY;
    }

    public boolean isFillupSpace() {
        return this.fillupSpace;
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = new Font("Courier", 0, 9);
        }
        return this.font;
    }

    public Font getPrintPlacesFont() {
        return this.printPlacesFont;
    }

    public Font getPrintStreetsFont() {
        return this.printStreetsFont;
    }

    public Font getFooterFont() {
        if (this.footerFont == null) {
            this.footerFont = new Font("Courier", 0, 9);
        }
        return this.footerFont;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setWithPoi(boolean withPoi) {
        this.withPoi = withPoi;
    }

    public boolean isWithPoi() {
        return this.withPoi;
    }

    public boolean isWhiteBackgroundForScale() {
        return this.whiteBackgroundForScale;
    }

    public ImagePosition getPosition() {
        if (this.position == null) {
            this.position = ImagePosition.TOP_RIGHT;
        }
        return this.position;
    }

    public void setLogoPosition(ImagePosition position) {
        this.position = position;
    }

    public LineGroupType getLineGroupType() {
        return this.lineGroupType;
    }

    public void setLineGroupType(LineGroupType lineGroupType) {
        this.lineGroupType = lineGroupType;
    }

    public static enum LineGroupType {
        NORMAL,
        STREET,
        ADDRESS;

    }

    public static enum PrintType {
        SCREENSHOT,
        ONE_PAGE,
        MULTIPLE_PAGES,
        MULTIPLE_PAGES_ALL,
        LEGEND;

    }
}

