/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.pdf.engine.processors;

import java.io.StringReader;
import java.io.StringWriter;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfVelocityEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfVelocityEmitter.class);
    private VelocityContext velocityContext;
    private String templateName;

    public PdfVelocityEmitter(VelocityContext velocityContext, String templateName) {
        this.velocityContext = velocityContext;
        this.templateName = templateName;
    }

    public StringReader callVelocity() throws Exception {
        Velocity.setProperty("resource.loader", "class");
        Velocity.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.setProperty("runtime.log.logsystem.log4j.logger", VelocityLogger.class.getName());
        Velocity.init();
        Template template = Velocity.getTemplate(this.templateName, "UTF-8");
        StringWriter writer = new StringWriter();
        template.merge(this.velocityContext, writer);
        return new StringReader(writer.toString());
    }

    private static class VelocityLogger
    implements LogChute {
        private VelocityLogger() {
        }

        @Override
        public void init(RuntimeServices rs) throws Exception {
        }

        @Override
        public void log(int level, String message) {
            switch (level) {
                case 0: {
                    LOGGER.debug(message);
                    break;
                }
                case 3: {
                    LOGGER.error(message);
                    break;
                }
                case 1: {
                    LOGGER.info(message);
                    break;
                }
                case -1: {
                    LOGGER.trace(message);
                    break;
                }
                case 2: {
                    LOGGER.warn(message);
                    break;
                }
                default: {
                    LOGGER.info(message);
                }
            }
        }

        @Override
        public void log(int level, String message, Throwable t) {
            switch (level) {
                case 0: {
                    LOGGER.debug(message, t);
                    break;
                }
                case 3: {
                    LOGGER.error(message, t);
                    break;
                }
                case 1: {
                    LOGGER.info(message, t);
                    break;
                }
                case -1: {
                    LOGGER.trace(message, t);
                    break;
                }
                case 2: {
                    LOGGER.warn(message, t);
                    break;
                }
                default: {
                    LOGGER.info(message, t);
                }
            }
        }

        @Override
        public boolean isLevelEnabled(int level) {
            switch (level) {
                case 0: {
                    return LOGGER.isDebugEnabled();
                }
                case 3: {
                    return LOGGER.isErrorEnabled();
                }
                case 1: {
                    return LOGGER.isInfoEnabled();
                }
                case -1: {
                    return LOGGER.isTraceEnabled();
                }
                case 2: {
                    return LOGGER.isWarnEnabled();
                }
            }
            return LOGGER.isInfoEnabled();
        }
    }
}

