/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.osm.domain;

import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.type.ImmutableType;
import org.hibernate.usertype.ParameterizedType;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimalFactory;

public class OsmGeometricalType
extends ImmutableType
implements ParameterizedType {
    private static final long serialVersionUID = 1767688087754357135L;
    private CoordinateFactory coordinateFactory;
    public static final String COORDINATE_FACTORY_PARAMETER_NAME = "coordinateFactory";

    @Override
    public Object fromStringValue(String xml) throws HibernateException {
        try {
            return new WKBReader().read(xml.getBytes());
        }
        catch (ParseException e) {
            throw new HibernateException(e);
        }
    }

    @Override
    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        String wkb = rs.getString(name);
        try {
            return ImmutableGeoObjectFactory.createImmutableGeoObject(new WKBReader().read(WKBReader.hexToBytes(wkb)), this.coordinateFactory);
        }
        catch (RuntimeException e) {
            return ImmutableGeoObjectFactory.createInvalidGeoObject(wkb, this.coordinateFactory);
        }
        catch (ParseException e) {
            return ImmutableGeoObjectFactory.createInvalidGeoObject(wkb, this.coordinateFactory);
        }
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        String valueAsString = null;
        if (value != null) {
            valueAsString = WKBWriter.toHex(new WKBWriter().write(((ImmutableGeoObject)value).getGeometryClone(this.coordinateFactory)));
            st.setObject(index, (Object)valueAsString, 1111);
        } else {
            st.setNull(index, 1111);
        }
    }

    @Override
    public int sqlType() {
        return 1111;
    }

    @Override
    public String toString(Object value) throws HibernateException {
        return WKBWriter.toHex(new WKBWriter().write(((ImmutableGeoObject)value).getGeometryClone(this.coordinateFactory)));
    }

    @Override
    public Class<?> getReturnedClass() {
        return ImmutableGeoObject.class;
    }

    @Override
    public String getName() {
        return OsmGeometricalType.class.getSimpleName();
    }

    @Override
    public void setParameterValues(Properties parameters) {
        String coordinateFactoryName = parameters.getProperty(COORDINATE_FACTORY_PARAMETER_NAME);
        if (coordinateFactoryName == null) {
            this.coordinateFactory = GeoDecimalFactory.INSTANCE;
        } else {
            try {
                Class<?> clazz = Class.forName(coordinateFactoryName);
                Constructor<?> propertiesConstructor = null;
                try {
                    propertiesConstructor = clazz.getConstructor(Properties.class);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                this.coordinateFactory = (CoordinateFactory)(propertiesConstructor == null ? clazz.newInstance() : propertiesConstructor.newInstance(parameters));
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

