/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.osm.dao;

import de.datomino.osm.dao.OsmDao;
import de.datomino.osm.domain.AbstractOsmDo;
import de.datomino.osm.domain.StreetDo;
import de.datomino.osm.domain.highway.HighwayWayDo;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Quad;
import org.ktde.util.datatypes.Tripel;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class OsmDaoImpl
extends HibernateDaoSupport
implements OsmDao {
    private Map<String, Collection<StreetDo>> postcodeCache = new HashMap<String, Collection<StreetDo>>();

    @Override
    public void saveOrUpdate(Object object) {
        this.getSession().saveOrUpdate(object);
    }

    @Override
    public void flush() {
        this.getSession().flush();
    }

    @Override
    public Object getDoById(Class<? extends AbstractOsmDo> clazz, Long id) {
        return this.getSession().get(clazz, (Serializable)id);
    }

    @Override
    public Set<Tripel<String, String, String>> fetchPostcodeCityDistrictRelations() {
        HashSet<Tripel<String, String, String>> set = new HashSet<Tripel<String, String, String>>();
        Criteria criteria = this.getSession().createCriteria(StreetDo.class);
        List streets = criteria.list();
        for (StreetDo street : streets) {
            set.add(new Tripel<String, String, String>(street.getPostcode(), street.getCity(), street.getDistrict()));
        }
        return set;
    }

    @Override
    public Collection<HighwayWayDo> fetchHighwayWay(Long minId, Long maxId) {
        return this.getSession().createCriteria(HighwayWayDo.class).add(Restrictions.between("id", minId, maxId)).list();
    }

    @Override
    public List<HighwayWayDo> fetchHighwayWayPagination(int firstResult, int maxResults) {
        return this.getSession().createCriteria(HighwayWayDo.class).addOrder(Order.asc("id")).setFirstResult(firstResult).setMaxResults(maxResults).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).list();
    }

    @Override
    public Quad<String, String, String, String> fetchStreet(Set<String> aliasNames, String postcodeName) {
        String streetName = null;
        String cityName = null;
        String districtName = null;
        if (!aliasNames.isEmpty()) {
            Collection<StreetDo> streets = this.getStreets(postcodeName);
            for (StreetDo street : streets) {
                if (!this.isSamedStreet(street, aliasNames)) continue;
                streetName = street.getName();
                cityName = street.getCity();
                districtName = street.getDistrict();
                break;
            }
        }
        return new Quad<Object, String, Object, Object>(streetName, postcodeName, cityName, districtName);
    }

    private boolean isSamedStreet(StreetDo street, Set<String> aliasNames) {
        String normalizedName = StringUtil.normalize(street.getName());
        for (String alias : aliasNames) {
            if (!alias.equals(normalizedName)) continue;
            return true;
        }
        return false;
    }

    private Collection<StreetDo> getStreets(String postcodeName) {
        if (!this.postcodeCache.containsKey(postcodeName)) {
            this.postcodeCache.clear();
            Criteria criteria = this.getSession().createCriteria(StreetDo.class);
            criteria.add(Restrictions.eq("postcode", postcodeName));
            this.postcodeCache.put(postcodeName, criteria.list());
        }
        return this.postcodeCache.get(postcodeName);
    }
}

