/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.osm;

import de.datomino.osm.DBConnector;
import de.datomino.osm.ExtractPlaceNameListener;
import de.datomino.osm.ImportHighwayListener;
import de.datomino.osm.ImportOsmListener;
import de.datomino.osm.OsmUtil;
import de.datomino.osm.geodata.datamodel.Osm;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class OsmXmlFileParser {
    private String path;
    private String directory;
    private String logfile;
    private DBConnector databasis;
    private boolean bzip2 = false;

    public OsmXmlFileParser(DBConnector databasis) {
        this.databasis = databasis;
    }

    public void importOsm() throws JAXBException, ParserConfigurationException, SAXException, ClassNotFoundException, SQLException, UnsupportedEncodingException {
        System.out.println("\nOsmXmlFileParser for import started ... ");
        ImportOsmListener listener = new ImportOsmListener(this.databasis, this.logfile);
        this.excute(listener);
    }

    public void importHighway() throws JAXBException, ParserConfigurationException, SAXException, ClassNotFoundException, SQLException, UnsupportedEncodingException {
        System.out.println("\nHighway import started ... ");
        ImportHighwayListener listener = new ImportHighwayListener(this.databasis, this.logfile);
        this.excute(listener);
    }

    public void extractPlaceName() throws JAXBException, ParserConfigurationException, SAXException, ClassNotFoundException, SQLException, UnsupportedEncodingException {
        System.out.println("\nPlace name extract started ... ");
        ExtractPlaceNameListener listener = new ExtractPlaceNameListener(this.databasis, this.logfile);
        this.excute(listener);
    }

    private void excute(ImportOsmListener databaselistener) throws JAXBException, FactoryConfigurationError, SAXException, ParserConfigurationException, SQLException, UnsupportedEncodingException {
        JAXBContext context = JAXBContext.newInstance(Osm.class);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setListener(databaselistener);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XMLReader reader = factory.newSAXParser().getXMLReader();
        reader.setContentHandler(unmarshaller.getUnmarshallerHandler());
        this.readyForStart(databaselistener);
        this.excuteParser(reader, databaselistener);
    }

    private void excuteParser(XMLReader reader, ImportOsmListener databaselistener) throws SAXException, SQLException, UnsupportedEncodingException {
        if (this.directory.equals("null") && !this.path.equals("null")) {
            this.excuteParserForOne(reader, databaselistener);
            this.finishForOne(databaselistener);
        } else if (!this.directory.equals("null") && this.path.equals("null")) {
            this.excuteParserForMore(reader, databaselistener);
            this.finishForMerge(databaselistener);
        } else {
            System.err.println("path or directory is incorrect.");
        }
    }

    private void excuteParserForOne(XMLReader reader, ImportOsmListener databaselistener) throws SAXException, SQLException {
        try {
            InputSource inputSource;
            System.out.println("\nImported file: " + this.path);
            if (this.bzip2) {
                System.out.println("BZ2");
                inputSource = new InputSource(new BZip2CompressorInputStream(new FileInputStream(this.path)));
            } else {
                inputSource = new InputSource(this.path);
            }
            reader.parse(inputSource);
        }
        catch (IOException e) {
            System.err.println(this.path + " is not a valid file.");
        }
    }

    private void excuteParserForMore(XMLReader reader, ImportOsmListener databaselistener) throws SAXException, SQLException {
        File dir = new File(this.directory);
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                this.path = file.getAbsolutePath();
                this.excuteParserForOne(reader, databaselistener);
            }
        } else {
            System.err.println(this.directory + " is not a valid directory.");
        }
    }

    private void finishForOne(ImportOsmListener listener) throws SQLException, UnsupportedEncodingException {
        System.out.print("Waiting for update ids ......");
        this.databasis.executeSqlQuerys(OsmUtil.readInputStream(OsmXmlFileParser.class.getResourceAsStream("/postgresql/osm_datomino_updateIds.sql")));
        System.out.println(" done");
        OsmUtil.writeFile(this.logfile, "Waiting for update sequences ...... done", true);
        System.out.print("Waiting for add indexes ......");
        this.databasis.executeSqlQuerys(OsmUtil.readInputStream(OsmXmlFileParser.class.getResourceAsStream("/postgresql/osm_datomino_addIndexes.sql")));
        System.out.println(" done");
        OsmUtil.writeFile(this.logfile, "Waiting for add indexes ...... done", true);
        System.out.print("Waiting for add constraints ......");
        this.databasis.executeSqlQuerys(OsmUtil.readInputStream(OsmXmlFileParser.class.getResourceAsStream("/postgresql/osm_datomino_addConstraints.sql")));
        System.out.println(" done");
        OsmUtil.writeFile(this.logfile, "Waiting for add constraints ...... done", true);
        listener.writeLogForEnd();
    }

    private void finishForMerge(ImportOsmListener listener) throws SQLException, UnsupportedEncodingException {
        System.out.print("Waiting for remove duplicated rows ......");
        this.databasis.executeSqlQuerys(OsmUtil.readInputStream(OsmXmlFileParser.class.getResourceAsStream("/postgresql/osm_datomino_removeDuplicate.sql")));
        System.out.println(" done");
        OsmUtil.writeFile(this.logfile, "Waiting for remove duplicated rows ...... done", true);
        this.finishForOne(listener);
    }

    private void readyForStart(ImportOsmListener listener) throws SQLException {
        listener.writeLogForStart();
        try {
            System.out.print("Waiting for remove constraints ......");
            String readFile = OsmUtil.readInputStream(OsmXmlFileParser.class.getResourceAsStream("/postgresql/osm_datomino_removeConsAndIdx.sql"));
            this.databasis.executeSqlQuerys(readFile);
            System.out.println(" done");
            OsmUtil.writeFile(this.logfile, "Waiting for remove constraints ...... done", true);
        }
        catch (Exception e) {
            this.databasis.clearBatch();
            System.err.println(e.getMessage());
        }
    }

    public void setDatabasis(DBConnector databasis) {
        this.databasis = databasis;
    }

    public DBConnector getDatabasis() {
        return this.databasis;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setLogfile(String logfile) {
        this.logfile = logfile;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setBzip2(boolean bzip2) {
        this.bzip2 = bzip2;
    }
}

