/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.osm;

import com.graphhopper.reader.ReaderWay;
import de.datomino.osm.domain.highway.HighwayWayDo;
import de.datomino.osm.domain.highway.HighwayWayTagDo;
import de.datomino.util.collection.CollectionUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Set;

public class OsmUtil {
    public static final Set<String> MOTORWAYS = CollectionUtil.buildHashSet("motorway", "motorway_link", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link", "unclassified", "road", "living_street", "track", "residential", "service");
    public static final Set<String> FOOTWAYS = CollectionUtil.buildHashSet("trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link", "unclassified", "road", "living_street", "track", "residential", "service", "pedestrian", "path", "footway", "steps");
    public static final Set<String> BIKEWAYS = CollectionUtil.buildHashSet("cycleway", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link", "unclassified", "road", "living_street", "track", "residential", "service", "pedestrian", "path", "steps");
    public static final Set<String> MOTOR_RESTRICTIONS = CollectionUtil.buildHashSet("motorcar", "motor_vehicle", "vehicle", "access");
    public static final Set<String> MOTOR_RESTRICTED_VALUES = CollectionUtil.buildHashSet("private", "agricultural", "forestry", "no", "restricted", "delivery");
    public static final Set<String> MOTOR_INTENDED_VALUES = CollectionUtil.buildHashSet("yes", "permissive");
    public static final Set<String> FOOT_RESTRICTIONS = CollectionUtil.buildHashSet("access");
    public static final Set<String> FOOT_RESTRICTED_VALUES = CollectionUtil.buildHashSet("no");
    public static final Set<String> FOOT_INTENDED_VALUES = CollectionUtil.buildHashSet("yes", "designated", "official", "permissive");
    public static final Set<String> BIKE_RESTRICTIONS = CollectionUtil.buildHashSet("bicycle", "access");
    public static final Set<String> BIKE_RESTRICTED_VALUES = CollectionUtil.buildHashSet("private", "no", "restricted");
    public static final Set<String> BIKE_INTENDED_VALUES = CollectionUtil.buildHashSet("yes", "designated", "official", "permissive");
    public static int BUFFER_SIZE = 8096;

    public static String formatLongToTimeStr(Long l) {
        int hour = 0;
        int minute = 0;
        int second = 0;
        second = l.intValue() / 1000;
        if (second >= 60) {
            minute = second / 60;
            second %= 60;
        }
        if (minute >= 60) {
            hour = minute / 60;
            minute %= 60;
        }
        return hour + " Stu. " + minute + " Min. " + second + " Sec.";
    }

    public static String getTimeRemaining(long startTime, int totalSize, int currentSize) {
        long currentTime = System.currentTimeMillis();
        long totalTime = (currentTime - startTime) / (long)currentSize * (long)(totalSize - currentSize);
        return OsmUtil.formatLongToTimeStr(totalTime);
    }

    public static String readFile(String filename) {
        try {
            String s;
            StringBuffer sb = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "utf-8"));
            while ((s = in.readLine()) != null) {
                sb.append(s);
                sb.append("\n");
            }
            in.close();
            return sb.toString();
        }
        catch (Exception e) {
            System.err.println(filename + " is no a valid file");
            System.exit(0);
            return null;
        }
    }

    public static String readInputStream(InputStream inputStream) {
        try {
            String s;
            StringBuffer sb = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            while ((s = in.readLine()) != null) {
                sb.append(s);
                sb.append("\n");
            }
            in.close();
            return sb.toString();
        }
        catch (Exception e) {
            System.err.println("The strem is not valid ");
            System.exit(0);
            return null;
        }
    }

    public static void writeFile(String filename, String s, boolean append) {
        if (filename == null || filename.isEmpty()) {
            return;
        }
        if (append) {
            s = OsmUtil.readFile(filename) + s;
        }
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "utf-8");
            out.write(s);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.err.println(filename + " is no a valid file");
        }
    }

    public static boolean hasTag(Set<String> keySet, Set<String> values, Map<String, String> attributeMap) {
        for (String key : keySet) {
            if (!values.contains(attributeMap.get(key))) continue;
            return true;
        }
        return false;
    }

    public static ReaderWay createOsmWay(HighwayWayDo highway) {
        ReaderWay osmWay = new ReaderWay(highway.getId());
        for (HighwayWayTagDo wayTagDo : highway.getTag()) {
            osmWay.setTag(wayTagDo.getKey(), wayTagDo.getValue());
        }
        return osmWay;
    }
}

