/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.osm;

import de.datomino.osm.DBConnector;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.ktde.ee.spring.AccessiblePropertiesConfigurer;
import org.ktde.util.StringUtil;
import org.ktde.util.io.CsvReader;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.xml.sax.SAXException;

public class ImportPostDirektBatch {
    public static void main(String[] args) throws JAXBException, IOException, ParserConfigurationException, SAXException, ClassNotFoundException {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("spring/osm-context.xml");
        AccessiblePropertiesConfigurer placeholderConfig = (AccessiblePropertiesConfigurer)applicationContext.getBean("placeholderConfig");
        String directoryName = placeholderConfig.getProperties().getProperty("postdirekt.directory");
        File directory = new File(directoryName);
        if (!directory.isDirectory()) {
            System.out.println("wrong property - " + directoryName);
            System.exit(0);
        }
        String schema = placeholderConfig.getProperties().getProperty("postdirekt.schema");
        DBConnector databasis = (DBConnector)applicationContext.getBean("databasisPostgres");
        databasis.setSchema("street_postdirekt");
        int total = 0;
        for (File file : directory.listFiles()) {
            List<String> line;
            CsvReader csvReader = new CsvReader(file, "ISO-8859-1");
            csvReader.setDelim(Character.valueOf(';'));
            List<String> header = csvReader.readLine();
            System.out.println("read from the file " + file);
            System.out.println("file header " + header + "\n");
            String sqlQuery = "";
            int sum = 1;
            while ((line = csvReader.readLine()) != null) {
                String x = StringUtil.isEmpty(line.get(7)) ? "0" : line.get(7);
                String y = StringUtil.isEmpty(line.get(8)) ? "0" : line.get(8);
                String name = line.get(0).replaceAll("'", "''");
                String city = line.get(4).replaceAll("'", "''");
                String district = line.get(5).replaceAll("'", "''");
                sqlQuery = sqlQuery + "INSERT INTO " + schema + ".t_streets(id, name, number_from, number_to, postal_code, city, district, kgs, x, y)VALUES (nextval('" + schema + ".s_streets'), '" + name + "', '" + line.get(1) + "', '" + line.get(2) + "', '" + line.get(3) + "', '" + city + "', '" + district + "',  " + line.get(6) + ", " + x + ", " + y + ");";
                if (sum % 100 == 0 && !StringUtil.isBlank(sqlQuery)) {
                    databasis.executeSqlQuerys(sqlQuery);
                    sqlQuery = "";
                    System.out.println("Commit - " + sum);
                }
                ++sum;
            }
            databasis.executeSqlQuerys(sqlQuery);
            total += sum;
            System.out.println("insert streets - " + sum);
        }
        System.out.println("insert streets - " + total);
    }
}

