/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.osm;

import de.datomino.osm.OsmXmlFileParser;
import java.io.IOException;
import java.sql.SQLException;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.xml.sax.SAXException;

public class ImportOsmHighwayBatch {
    static final String VER1 = "importOsm";
    static final String VER2 = "importHighway";

    public static void main(String[] args) throws JAXBException, IOException, ParserConfigurationException, SAXException, ClassNotFoundException {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("spring/osm-context.xml");
        try {
            if (args == null || args.length != 1) {
                System.out.println("Choose the input method: importOsm or importHighway");
            }
        }
        catch (NumberFormatException e) {
            System.err.println("1 Parameter Error");
        }
        try {
            OsmXmlFileParser osmXmlFileParser = (OsmXmlFileParser)applicationContext.getBean("osmXmlFileParser");
            if (args[0].equalsIgnoreCase(VER1)) {
                osmXmlFileParser.getDatabasis().setSchema("osm_plain");
                osmXmlFileParser.importOsm();
            } else if (args[0].equalsIgnoreCase(VER2)) {
                osmXmlFileParser.getDatabasis().setSchema("osm_highway");
                osmXmlFileParser.importHighway();
            } else {
                System.out.print("Wrong Parameter");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            e.getNextException().printStackTrace();
        }
        applicationContext.close();
    }

    public void execute() throws JAXBException, IOException, ParserConfigurationException, SAXException, ClassNotFoundException {
        try (ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("spring/osm-context.xml");){
            OsmXmlFileParser osmXmlFileParser = (OsmXmlFileParser)applicationContext.getBean("osmXmlFileParser");
            osmXmlFileParser.getDatabasis().setSchema("osm_highway");
            osmXmlFileParser.importHighway();
        }
    }
}

