/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic.util;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutableLineStringDto;
import de.datomino.util.geo.dto.ImmutablePointDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ktde.math.projection.GeoDecimal100Factory;

public abstract class StreetSideEntity<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 7698850527642452558L;
    private T id;
    private ImmutableLineStringDto geom;
    private LogisticStopDto<T> start;
    private LogisticStopDto<T> end;
    private List<LogisticStopDto<T>> stops;

    public StreetSideEntity(T id, ImmutableLineStringDto geom) {
        this.id = id;
        this.geom = geom;
    }

    public T getId() {
        return this.id;
    }

    public ImmutableLineStringDto getGeom() {
        if (this.geom == null) {
            this.initGeom();
        }
        return this.geom;
    }

    private void initGeom() {
        if (this.stops == null || this.stops.isEmpty()) {
            return;
        }
        ArrayList<ImmutablePoint> points = new ArrayList<ImmutablePoint>(this.stops.size());
        CollectionUtil.transform(this.stops, points, new Transformer<LogisticStopDto<T>, ImmutablePoint>(){

            @Override
            public ImmutablePoint transform(LogisticStopDto<T> t) {
                return (ImmutablePoint)t.getLocation().getAccessGeom().getGeoObject();
            }
        });
        try {
            this.geom = ImmutableLineStringDto.create(ImmutableGeoObjectFactory.createImmutableLineStringByPoints(points));
        }
        catch (Exception e) {
            ImmutablePoint first = (ImmutablePoint)this.stops.get(0).getLocation().getAccessGeom().getGeoObject();
            ImmutablePoint transformed = (ImmutablePoint)first.getTransformed(GeoDecimal100Factory.INSTANCE);
            ImmutablePoint last = ImmutableGeoObjectFactory.createImmutablePoint(GeoDecimal100Factory.INSTANCE.createCoordinate(transformed.getX() + 10.0, transformed.getY() + 10.0));
            points.add(first);
            points.add(last);
            this.geom = ImmutableLineStringDto.create(ImmutableGeoObjectFactory.createImmutableLineStringByPoints(points));
        }
    }

    public LogisticStopDto<T> getStart() {
        if (this.start == null) {
            ImmutablePoint startPoint = ((ImmutableLineString)this.getGeom().getGeoObject()).getStartPoint();
            ImmutablePointDto startPointDto = ImmutablePointDto.create(startPoint);
            LogisticLocationDto<T> location = new LogisticLocationDto<T>(this.id, startPointDto, startPointDto, null, null, null, null, null, (Integer)null, null);
            this.start = new LogisticStopDto<T>(this.id, location);
        }
        return this.start;
    }

    public void setStart(LogisticStopDto<T> start) {
        this.start = start;
    }

    public LogisticStopDto<T> getEnd() {
        if (this.end == null) {
            ImmutablePoint endPoint = ((ImmutableLineString)this.getGeom().getGeoObject()).getEndPoint();
            ImmutablePointDto endPointDto = ImmutablePointDto.create(endPoint);
            LogisticLocationDto<T> location = new LogisticLocationDto<T>(this.getReverseId(this.id), endPointDto, endPointDto, null, null, null, null, null, (Integer)null, null);
            this.end = new LogisticStopDto<T>(this.getReverseId(this.id), location);
        }
        return this.end;
    }

    protected abstract T getReverseId(T var1);

    public void setEnd(LogisticStopDto<T> end) {
        this.end = end;
    }

    public List<LogisticStopDto<T>> getStops() {
        if (this.stops == null) {
            this.stops = new ArrayList<LogisticStopDto<T>>();
        }
        return this.stops;
    }

    public void setStops(List<LogisticStopDto<T>> stops) {
        this.stops = stops;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof StreetSideEntity) {
            StreetSideEntity other = (StreetSideEntity)o;
            if (this.id.equals(other.id) && this.getGeom().equals(other.getGeom())) {
                return true;
            }
        }
        return false;
    }
}

