/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic.util;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.logistic.dto.LogisticTourPartDto;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.logistic.type.StopType;
import de.datomino.util.NumericUtil;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ktde.math.graph.Node;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class LogisticServicesUtil {
    public static Double calculateDuration(Double distance, RouteVehicleType vehicleType) {
        Double duration = null;
        vehicleType = vehicleType == null ? RouteVehicleType.MOTORCAR : vehicleType;
        switch (vehicleType) {
            case MOTORCAR: {
                duration = distance / 13.88888888888889;
                break;
            }
            case BIKE: {
                duration = distance / 2.0833333333333335;
                break;
            }
            case FOOT: {
                duration = distance / 1.3888888888888888;
            }
        }
        return duration;
    }

    public static <S extends Serializable> List<Tupel<LogisticStopDto<S>, Double>> sortLogisticStopFromStart(ImmutableLineString lineString, List<LogisticStopDto<S>> logisticStops) {
        ArrayList<Tupel<LogisticStopDto<S>, Double>> distancesFromStart = new ArrayList<Tupel<LogisticStopDto<S>, Double>>(logisticStops.size());
        for (LogisticStopDto<S> logisticStopDto : logisticStops) {
            distancesFromStart.add(new Tupel<LogisticStopDto<S>, Double>(logisticStopDto, GeoUtils.getDistanceFromStart(lineString, (ImmutablePoint)logisticStopDto.getLocation().getAccessGeom().getGeoObject())));
        }
        Collections.sort(distancesFromStart, new LogisticStopDistanceComparator());
        return distancesFromStart;
    }

    public static <T extends Serializable> List<LogisticStopDto<T>> getAllStops(LogisticTourDto<T> logisticTourDto) {
        ArrayList<LogisticStopDto<T>> stops = new ArrayList<LogisticStopDto<T>>();
        if (logisticTourDto != null) {
            for (LogisticTourPartDto<T> tourPart : logisticTourDto.getTourParts()) {
                stops.addAll(tourPart.getStopDtos());
            }
        }
        return stops;
    }

    public static <O> Node<O> createNode(O o, StopType stopType, double ... costs) {
        if (o == null) {
            return new Node();
        }
        int[] values = new int[]{0, 0};
        if (stopType != null && stopType == StopType.POI_START) {
            values = new int[]{1, 0};
        } else if (stopType != null && stopType == StopType.POI_END) {
            values = new int[]{0, 1};
        }
        if (costs.length == 0) {
            costs = new double[]{0.0};
        }
        return new Node<O>(o, costs, values);
    }

    public static class LogisticStopDistanceComparator<S extends Serializable>
    implements Comparator<Tupel<LogisticStopDto<S>, Double>> {
        @Override
        public int compare(Tupel<LogisticStopDto<S>, Double> o1, Tupel<LogisticStopDto<S>, Double> o2) {
            ImmutablePoint access2;
            LogisticLocationDto<S> location1 = o1.getElement1().getLocation();
            LogisticLocationDto<S> location2 = o2.getElement1().getLocation();
            ImmutablePoint geom1 = (ImmutablePoint)location1.getGeom().getGeoObject();
            ImmutablePoint geom2 = (ImmutablePoint)location2.getGeom().getGeoObject();
            ImmutablePoint access1 = (ImmutablePoint)location1.getAccessGeom().getGeoObject();
            if (GeoUtils.areSamedPoints(access1, access2 = (ImmutablePoint)location2.getAccessGeom().getGeoObject(), (Double)0.0)) {
                Double g12 = GeoUtils.getDistanceInMeter(geom1.getCoordinate(), geom2.getCoordinate());
                Double a1 = GeoUtils.getDistanceInMeter(geom1.getCoordinate(), access1.getCoordinate());
                Double a2 = GeoUtils.getDistanceInMeter(access2.getCoordinate(), geom2.getCoordinate());
                if (!StringUtil.isBlank(location1.getStreet()) && location1.isSameAddress(location2)) {
                    return 0;
                }
                if (g12 <= Math.max(a1, a2)) {
                    return a1.compareTo(a2);
                }
                if (geom1.getX() == geom2.getX()) {
                    return (int)(geom1.getY() - geom2.getY());
                }
                return (int)(geom1.getX() - geom2.getX());
            }
            return Double.compare(NumericUtil.getDoubleValue(o1.getElement2()), NumericUtil.getDoubleValue(o2.getElement2()));
        }
    }
}

