/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic.type;

import de.datomino.logistic.type.RoutingType;

public enum OptimizationType implements RoutingType,
Cloneable
{
    NONFIX,
    STARTPOINTFIX,
    ENDPOINTFIX,
    BOTHPOINTFIX,
    STARTWITHPOI,
    STARTWITHPOIENDFIX,
    ENDWITHPOI,
    STARTFIXENDWITHPOI,
    BOTHWITHPOI,
    ALLFIX;


    public static OptimizationType createOptimizationType(boolean poi, boolean startFix, boolean endFix) {
        return OptimizationType.createOptimizationType(poi, startFix, endFix, false);
    }

    public static OptimizationType createOptimizationType(boolean poi, boolean startFix, boolean endFix, boolean back) {
        OptimizationType type = null;
        if (poi && !endFix) {
            type = STARTWITHPOI;
        } else if (poi && endFix) {
            type = STARTWITHPOIENDFIX;
        } else if (!poi && startFix && !endFix) {
            type = STARTPOINTFIX;
        } else if (!poi && startFix && endFix) {
            type = BOTHPOINTFIX;
        } else if (!poi && !endFix) {
            type = NONFIX;
        } else if (!poi && endFix) {
            type = ENDPOINTFIX;
        }
        if (poi && back) {
            type = type.addEndPoi();
        }
        return type;
    }

    @Override
    public OptimizationType removeStartPoi(int blockSize) {
        OptimizationType newType = null;
        switch (this) {
            case STARTWITHPOI: {
                if (blockSize > 0) {
                    newType = STARTPOINTFIX;
                    break;
                }
                newType = NONFIX;
                break;
            }
            case STARTWITHPOIENDFIX: {
                if (blockSize > 0) {
                    newType = BOTHPOINTFIX;
                    break;
                }
                newType = ENDPOINTFIX;
                break;
            }
            case BOTHWITHPOI: {
                if (blockSize > 0) {
                    newType = STARTFIXENDWITHPOI;
                    break;
                }
                newType = ENDWITHPOI;
                break;
            }
            default: {
                return this;
            }
        }
        return newType;
    }

    @Override
    public OptimizationType removeEndPoi(int blockSize) {
        OptimizationType newType = null;
        switch (this) {
            case ENDWITHPOI: {
                if (blockSize > 0) {
                    newType = ENDPOINTFIX;
                    break;
                }
                newType = NONFIX;
                break;
            }
            case BOTHWITHPOI: {
                if (blockSize > 0) {
                    newType = STARTPOINTFIX;
                    break;
                }
                newType = STARTWITHPOI;
                break;
            }
            default: {
                newType = this;
            }
        }
        return newType;
    }

    @Override
    public OptimizationType addStartBlock() {
        OptimizationType newType = null;
        switch (this) {
            case NONFIX: {
                newType = STARTPOINTFIX;
                break;
            }
            case ENDPOINTFIX: {
                newType = BOTHPOINTFIX;
                break;
            }
            case ENDWITHPOI: {
                newType = STARTFIXENDWITHPOI;
                break;
            }
            default: {
                return this;
            }
        }
        return newType;
    }

    @Override
    public OptimizationType addStartPoi() {
        OptimizationType newType = null;
        switch (this) {
            case NONFIX: 
            case STARTPOINTFIX: {
                newType = STARTWITHPOI;
                break;
            }
            case ENDPOINTFIX: 
            case BOTHPOINTFIX: {
                newType = STARTWITHPOIENDFIX;
                break;
            }
            case ENDWITHPOI: 
            case STARTFIXENDWITHPOI: {
                newType = BOTHWITHPOI;
                break;
            }
            default: {
                return this;
            }
        }
        return newType;
    }

    @Override
    public OptimizationType addEndPoi() {
        OptimizationType newType = null;
        switch (this) {
            case NONFIX: 
            case ENDPOINTFIX: {
                newType = ENDWITHPOI;
                break;
            }
            case STARTPOINTFIX: 
            case BOTHPOINTFIX: {
                newType = STARTFIXENDWITHPOI;
                break;
            }
            case STARTWITHPOI: 
            case STARTWITHPOIENDFIX: {
                newType = BOTHWITHPOI;
                break;
            }
            default: {
                return this;
            }
        }
        return newType;
    }

    @Override
    public boolean isStartFix() {
        switch (this) {
            case STARTWITHPOI: 
            case STARTWITHPOIENDFIX: 
            case BOTHWITHPOI: 
            case STARTPOINTFIX: 
            case BOTHPOINTFIX: 
            case STARTFIXENDWITHPOI: 
            case ALLFIX: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEndFix() {
        switch (this) {
            case STARTWITHPOIENDFIX: 
            case BOTHWITHPOI: 
            case ENDWITHPOI: 
            case ENDPOINTFIX: 
            case BOTHPOINTFIX: 
            case STARTFIXENDWITHPOI: 
            case ALLFIX: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isWithPoi() {
        return this.isStartWithPoi() || this.isEndWithPoi();
    }

    @Override
    public boolean isStartWithPoi() {
        switch (this) {
            case STARTWITHPOI: 
            case STARTWITHPOIENDFIX: 
            case BOTHWITHPOI: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEndWithPoi() {
        switch (this) {
            case BOTHWITHPOI: 
            case ENDWITHPOI: 
            case STARTFIXENDWITHPOI: {
                return true;
            }
        }
        return false;
    }
}

