/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic.tsp.aglorithm;

import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.tsp.aglorithm.AbstractSimulatedAnnealingAlgorithm;
import de.datomino.logistic.type.StopType;
import de.datomino.logistic.util.LogisticServicesUtil;
import de.datomino.logistic.util.StreetSideEntity;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.util.algorithm.AlgorithmException;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ArrangementSAMinTspFinder<N extends LogisticStopDto<Long>>
extends AbstractSimulatedAnnealingAlgorithm<N, N> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrangementSAMinTspFinder.class);
    private Map<Node<N>, Node<N>> pairMap = new HashMap<Node<N>, Node<N>>();

    public ArrangementSAMinTspFinder(Graph graph, N start, N end, Long randomSeed) {
        this(graph, start, end, 0, -1, randomSeed);
    }

    public ArrangementSAMinTspFinder(Graph graph, N start, N target, int costIndexEdge, int costIndexNode, Long randomSeed) {
        super(graph, LogisticServicesUtil.createNode(start, StopType.POI_START, new double[0]), LogisticServicesUtil.createNode(target, StopType.POI_END, new double[0]), costIndexEdge, costIndexNode, randomSeed);
    }

    @Override
    public void findMinTsp(Random random) {
        int minIndex = 0;
        int maxIndex = this.tour.size();
        LOGGER.info("The tour size: " + (maxIndex + 1));
        LOGGER.info("Length of Tour: " + this.getPathLength(this.tour) + " (before)");
        if (this.startFix) {
            minIndex = 1;
        }
        if (this.targetFix) {
            --maxIndex;
        }
        int step = this.algoImpl(minIndex, maxIndex, random);
        LOGGER.info("Length of the tour: " + this.getPathLength(this.tour) + " (after " + step + " steps)");
        if (this.tour == null) {
            return;
        }
        LOGGER.info("Length of the tour: " + this.getPathLength(this.tour));
    }

    @Override
    public void buildInitializedTour() throws AlgorithmException {
        Node<N> target;
        Edge maxEdge = this.getMaxEdge();
        if (maxEdge == null) {
            return;
        }
        this.tour = new Vector();
        Iterator<Node<?>> nodeIter = this.graph.getNodeIterator();
        while (nodeIter.hasNext()) {
            StreetSideEntity streetSide;
            Node<?> next = nodeIter.next();
            LogisticStopDto key = (LogisticStopDto)next.getAssociatedObject();
            if (key.equals((streetSide = key.getStreetSide()).getStart())) {
                this.pairMap.put(next, new Node(streetSide.getEnd()));
                continue;
            }
            this.pairMap.put(next, new Node(streetSide.getStart()));
        }
        Node<N> targetOfStart = this.getTargetOfStreeSide(this.start);
        if (targetOfStart.equals(this.target)) {
            if (this.startFix && this.targetFix) {
                throw new AlgorithmException("failed start or target");
            }
            this.edgeTabuSet.add(maxEdge);
            this.buildInitializedTour();
        }
        this.start = targetOfStart;
        Node targetSideStart = this.target;
        this.target = this.getTargetOfStreeSide(targetSideStart);
        Node<N> pred = this.start;
        while (true) {
            target = this.getTargetOfStreeSide(pred);
            this.tour.add(super.getEdge(pred, target));
            Node<N> succ = this.findNextStreeSide(target, CollectionUtil.buildHashSet(this.target, this.pairMap.get(this.target)));
            if (succ == null) break;
            pred = succ;
        }
        pred = target;
        this.tour.add(super.getEdge(pred, targetSideStart));
        this.tour.add(super.getEdge(targetSideStart, this.target));
        while (!(super.checkFeasibility(this.tour) && super.checkCompleteness() || this.tour == null)) {
            this.edgeTabuSet.add(maxEdge);
            this.buildInitializedTour();
        }
    }

    private Node<N> findNextStreeSide(Node<N> node, Set<Node<? extends Object>> targets) {
        Edge lastEdage = (Edge)this.tour.get(this.tour.size() - 1);
        LogisticStopDto lastStart = (LogisticStopDto)lastEdage.getStart().getAssociatedObject();
        ImmutablePoint lastStartPoint = (ImmutablePoint)lastStart.getLocation().getAccessGeom().getGeoObject();
        ImmutablePoint point = (ImmutablePoint)((LogisticStopDto)node.getAssociatedObject()).getLocation().getAccessGeom().getGeoObject();
        Edge<Tupel<N, N>> reciprocalEdge = null;
        Edge<Tupel<N, N>> shortestEdge = null;
        double minCost = Double.MAX_VALUE;
        double minAngle = Math.PI * 2;
        for (int i = 0; i < this.graph.getOutEdgeCount(node); ++i) {
            double angle;
            Edge<Tupel<N, N>> edge = this.graph.getOutEdgeAt(node, i);
            if (this.isNodeOnPath(edge.getTarget(), this.tour) || targets.contains(edge.getTarget()) || !this.checkFeasibility(new Vector(Arrays.asList(edge)))) continue;
            LogisticStopDto target = (LogisticStopDto)edge.getTarget().getAssociatedObject();
            ImmutablePoint targetPoint = (ImmutablePoint)target.getLocation().getAccessGeom().getGeoObject();
            if (GeoUtils.getDistanceInMeter(lastStartPoint.getCoordinate(), targetPoint.getCoordinate()) < 0.1) {
                reciprocalEdge = edge;
                break;
            }
            Double edgeCost = this.getMaxCost(edge);
            if (shortestEdge == null || minCost > edgeCost) {
                shortestEdge = edge;
                minCost = edgeCost;
            } else if (minCost == edgeCost && minAngle > (angle = GeoUtils.calculateAngle(point, lastStartPoint, targetPoint))) {
                shortestEdge = edge;
                minAngle = angle;
            }
            shortestEdge = edge;
            break;
        }
        if (shortestEdge == null && reciprocalEdge == null) {
            return null;
        }
        shortestEdge = shortestEdge == null ? reciprocalEdge : shortestEdge;
        this.tour.add(shortestEdge);
        return shortestEdge.getOther(node);
    }

    private Node<N> getTargetOfStreeSide(Node<N> node) throws AlgorithmException {
        Node<N> other = this.pairMap.get(node);
        if (other == null) {
            String error = "found no target - " + ((LogisticStopDto)node.getAssociatedObject()).toString();
            LOGGER.error(error);
            throw new AlgorithmException(error);
        }
        return other;
    }

    @Override
    public Vector<Edge<?>> randomInterchange(Vector<Edge<?>> edges, int minIndex, int maxIndex, boolean changeEdge, Random random) throws Exception {
        int endIndex;
        int size = maxIndex - minIndex;
        long random1 = Math.round(random.nextDouble() * (double)size) + (long)minIndex;
        long random2 = Math.round(random.nextDouble() * (double)size) + (long)minIndex;
        while (random1 == random2) {
            random1 = Math.round(random.nextDouble() * (double)size) + (long)minIndex;
            random2 = Math.round(random.nextDouble() * (double)size) + (long)minIndex;
        }
        int startIndex = (int)Math.min(random1, random2);
        Edge<Tupel<N, N>> edge = edges.get(startIndex - 1);
        if (this.samedSide(edge)) {
            int oldIndex = startIndex - 1;
            startIndex = startIndex > minIndex ? startIndex - 1 : startIndex + 1;
            super.interchangeNodes(edges, oldIndex, oldIndex + 1);
        }
        if ((endIndex = (int)Math.max(random1, random2)) == startIndex) {
            ++endIndex;
        } else if ((endIndex - startIndex) % 2 == 0) {
            ++endIndex;
        }
        if (endIndex > maxIndex) {
            endIndex -= 2;
        }
        if (startIndex >= endIndex) {
            return edges;
        }
        int insertIndex = (int)(Math.round(random.nextDouble() * (double)(size - endIndex + startIndex - 1)) + (long)minIndex);
        if (this.startFix && insertIndex % 2 != 0 || !this.startFix && insertIndex % 2 == 0) {
            int n = insertIndex = insertIndex - 1 == minIndex ? insertIndex + 1 : insertIndex - 1;
            if (insertIndex > maxIndex) {
                return edges;
            }
        }
        return super.interchangeEdges(edges, startIndex, endIndex, insertIndex);
    }

    private boolean samedSide(Edge<Tupel<N, N>> edge) {
        Node<?> s = edge.getStart();
        Node<?> t = edge.getTarget();
        LogisticStopDto sObject = (LogisticStopDto)s.getAssociatedObject();
        LogisticStopDto tObject = (LogisticStopDto)t.getAssociatedObject();
        return sObject.getStreetSide().equals(tObject.getStreetSide());
    }

    @Override
    public Double getMaxCost(Edge<Tupel<N, N>> edge) {
        Double length = 0.0;
        length = this.samedSide(edge) ? Double.valueOf(0.0) : Double.valueOf(length + edge.getCostAt(this.costIndexEdge));
        return length;
    }

    @Override
    protected List<N> getNodeObjectList(List<Edge<?>> edges) {
        ArrayList<LogisticStopDto> ls = new ArrayList<LogisticStopDto>(edges.size() + 1);
        for (Edge<?> edge : edges) {
            if (ls.isEmpty()) {
                ls.add((LogisticStopDto)edge.getStart().getAssociatedObject());
            }
            ls.add((LogisticStopDto)edge.getTarget().getAssociatedObject());
        }
        return ls;
    }
}

