/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic.tsp;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.dto.LogisticTimeWindowDto;
import de.datomino.logistic.tsp.LogisticMinTspFinder;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.graph.algo.AbstractPathFinder;
import org.ktde.util.algorithm.AlgorithmException;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractLogisticMinTspFinder<N, R>
extends AbstractPathFinder
implements LogisticMinTspFinder<N, R> {
    protected static final long NO_TIME = -1L;
    protected long tourStartTime = -1L;
    protected long tourEndTime = -1L;
    protected boolean startFix;
    protected boolean targetFix;
    protected String errorMessage;
    protected boolean checkTimeWindow = false;

    public AbstractLogisticMinTspFinder(Graph graph, Node<N> start, Node<N> target, int costIndexEdge, int costIndexNode) {
        super(graph, start, target, costIndexEdge, costIndexNode);
    }

    @Override
    public List<R> getTour() throws LogisticException {
        super.findTour();
        if (this.tour == null) {
            throw new LogisticException(this.errorMessage);
        }
        return this.getNodeObjectList(this.tour);
    }

    protected abstract List<R> getNodeObjectList(List<Edge<?>> var1);

    @Override
    public int preCalcSteps() {
        return 0;
    }

    @Override
    public void findMinTsp(Random random) {
    }

    @Override
    public Vector<Edge<?>> randomInterchange(Vector<Edge<?>> edges, int minIndex, int maxIndex, boolean changeEdge, Random random) throws Exception {
        return null;
    }

    @Override
    public void buildInitializedTour() throws AlgorithmException {
    }

    @Override
    public Double getMaxCost(Edge<Tupel<N, N>> edge) {
        return null;
    }

    @Override
    public boolean checkFeasibility(Vector<Edge<?>> edges) {
        return true;
    }

    protected Tupel<Long, Long> getNearbyTimeWindow(LogisticStopDto<?> n, long time) {
        long nearbyStart = -1L;
        long nearbyEnd = -1L;
        if (this.hasTimeWindow(n)) {
            for (LogisticTimeWindowDto timeWindow : n.getTimeWindows()) {
                long e;
                Date startTime = timeWindow.getStartTime();
                Date endTime = timeWindow.getEndTime();
                long s = startTime == null ? -1L : startTime.getTime() / 1000L;
                long l = e = endTime == null ? -1L : endTime.getTime() / 1000L;
                if (time >= s && time <= e) {
                    nearbyStart = s;
                    nearbyEnd = e;
                    break;
                }
                if (time < s) {
                    if (time <= nearbyEnd && nearbyStart - time <= nearbyStart - s) continue;
                    nearbyStart = s;
                    nearbyEnd = e;
                    continue;
                }
                if (nearbyStart != -1L || nearbyEnd != -1L) continue;
                nearbyStart = s;
                nearbyEnd = e;
            }
        }
        return new Tupel<Long, Long>(nearbyStart, nearbyEnd);
    }

    protected boolean hasTimeWindow(LogisticStopDto<?> n) {
        List<LogisticTimeWindowDto> tws = n.getTimeWindows();
        if (tws == null || tws.isEmpty()) {
            return false;
        }
        boolean b = false;
        for (LogisticTimeWindowDto tw : tws) {
            if (tw.getStartTime() == null && tw.getEndTime() == null) continue;
            b = true;
            break;
        }
        return b;
    }

    protected boolean checkTimeFeasibility(long arrivalTime, List<LogisticTimeWindowDto> timeWindows) {
        if (timeWindows == null || timeWindows.isEmpty()) {
            return true;
        }
        for (LogisticTimeWindowDto timeWindow : timeWindows) {
            if (arrivalTime > timeWindow.getEndTime().getTime() / 1000L) continue;
            return true;
        }
        return false;
    }

    public void setTourStartTime(Date tourStartTime) {
        this.tourStartTime = tourStartTime.getTime() / 1000L;
    }

    public void setTourEndTime(Date tourEndTime) {
        this.tourEndTime = tourEndTime.getTime() / 1000L;
    }

    public void setCheckTimeWindow(boolean checkTimeWindow) {
        this.checkTimeWindow = checkTimeWindow;
    }
}

