/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic.searchevaluation;

import de.datomino.logistic.searchevaluation.MultipleSearchEvaluationAddressWrapper;
import de.datomino.logistic.searchevaluation.SearchEvaluationAddressWrapper;
import de.datomino.logistic.searchevaluation.SearchEvaluationWeights;
import de.datomino.util.international.country.Country;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.ktde.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchEvaluation {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchEvaluation.class);

    private SearchEvaluation() {
    }

    public static double matching(MultipleSearchEvaluationAddressWrapper foundAddress, SearchEvaluationAddressWrapper searched, int weight, SearchEvaluationWeights searchEvaluationWeights) {
        return SearchEvaluation.matching(foundAddress, searched, weight, searchEvaluationWeights, false);
    }

    public static double matching(MultipleSearchEvaluationAddressWrapper foundAddress, SearchEvaluationAddressWrapper searched, int weight, SearchEvaluationWeights searchEvaluationWeights, boolean considerWildcard) {
        Country searchedCountry;
        String[] streets;
        String[] districts;
        double[] weightValues = SearchEvaluation.flatWeights(searchEvaluationWeights);
        boolean[] ignoreEmpties = SearchEvaluation.flatEmpties(searchEvaluationWeights);
        boolean[] noMatchForced = new boolean[7];
        boolean[] isWildCard = new boolean[7];
        Arrays.fill(noMatchForced, false);
        Arrays.fill(isWildCard, false);
        String[] cities = foundAddress.getCity();
        if (cities == null || cities.length == 0) {
            cities = new String[]{null};
            noMatchForced[1] = true;
        }
        if ((districts = foundAddress.getDistrict()) == null || districts.length == 0) {
            districts = new String[]{null};
            noMatchForced[2] = true;
        }
        if ((streets = foundAddress.getStreet()) == null || streets.length == 0) {
            streets = new String[]{null};
            noMatchForced[3] = true;
        }
        if (considerWildcard) {
            String street;
            String district;
            String city;
            String postcode = searched.getPostcode();
            if (StringUtil.nullToEmpty(postcode).contains("*")) {
                isWildCard[4] = true;
            }
            if (StringUtil.nullToEmpty(city = searched.getCity()).contains("*")) {
                isWildCard[1] = true;
            }
            if (StringUtil.nullToEmpty(district = searched.getDistrict()).contains("*")) {
                isWildCard[2] = true;
            }
            if (StringUtil.nullToEmpty(street = searched.getStreet()).contains("*")) {
                isWildCard[3] = true;
            }
        }
        String searchedCountryString = (searchedCountry = searched.getCountry()) == null ? null : searchedCountry.getVehicleSign();
        Country foundCountry = foundAddress.getCountry();
        String foundCountryString = foundCountry == null ? null : foundCountry.getVehicleSign();
        String searchedStreet = searched.getStreet();
        String[] eing = new String[]{searchedCountryString, searched.getCity(), searched.getDistrict(), searchedStreet, searched.getPostcode(), searched.getHousenumber(), searched.getExtension()};
        double best = 0.0;
        for (String city : cities) {
            for (String district : districts) {
                String[] stringArray = streets;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String street;
                    String foundStreet = street = stringArray[i];
                    String[] stringArray2 = new String[]{foundCountryString, city, district, foundStreet, foundAddress.getPostcode(), foundAddress.getHousenumber(), foundAddress.getExtension()};
                    String[] orig = stringArray2;
                    double match = SearchEvaluation.matching(orig, eing, weightValues, weight, ignoreEmpties, noMatchForced, isWildCard);
                    if (!(match > best)) continue;
                    best = match;
                }
            }
        }
        return best;
    }

    public static double matching(SearchEvaluationAddressWrapper foundAddress, SearchEvaluationAddressWrapper searched, int weight, SearchEvaluationWeights searchEvaluationWeights) {
        boolean[] ignoreEmpties = SearchEvaluation.flatEmpties(searchEvaluationWeights);
        return SearchEvaluation.matching(foundAddress, searched, weight, searchEvaluationWeights, ignoreEmpties);
    }

    public static double matching(SearchEvaluationAddressWrapper foundAddress, SearchEvaluationAddressWrapper searched, int weight, SearchEvaluationWeights searchEvaluationWeights, boolean[] ignoreEmpties) {
        double[] weightValues = SearchEvaluation.flatWeights(searchEvaluationWeights);
        Country searchedCountry = searched.getCountry();
        String searchedCountryString = searchedCountry == null ? null : searchedCountry.getVehicleSign();
        Country foundCountry = foundAddress.getCountry();
        String foundCountryString = foundCountry == null ? null : foundCountry.getVehicleSign();
        String searchedStreet = searched.getStreet();
        Object[] eing = new String[]{searchedCountryString, searched.getCity(), searched.getDistrict(), searchedStreet, searched.getPostcode(), searched.getHousenumber(), searched.getExtension()};
        String foundStreet = foundAddress.getStreet();
        Object[] orig = new String[]{foundCountryString, foundAddress.getCity(), foundAddress.getDistrict(), foundStreet, foundAddress.getPostcode(), foundAddress.getHousenumber(), foundAddress.getExtension()};
        double matching = SearchEvaluation.matching((String[])orig, (String[])eing, weightValues, weight, ignoreEmpties);
        LOGGER.info("Matching of [" + StringUtil.implode(eing, ", ") + "] and [" + StringUtil.implode(orig, ", ") + "\n->" + matching);
        return matching;
    }

    private static boolean[] flatEmpties(SearchEvaluationWeights searchEvaluationWeights) {
        boolean[] ignores = new boolean[]{searchEvaluationWeights.isCountryIgnoreEmpty(), searchEvaluationWeights.isCityIgnoreEmpty(), searchEvaluationWeights.isDistrictIgnoreEmpty(), searchEvaluationWeights.isStreetIgnoreEmpty(), searchEvaluationWeights.isPostcodeIgnoreEmpty(), searchEvaluationWeights.isHouseNumberIgnoreEmpty(), searchEvaluationWeights.isHousenumberExtensionIgnoreEmpty()};
        return ignores;
    }

    private static double[] flatWeights(SearchEvaluationWeights searchEvaluationWeights) {
        double[] weightValues = new double[]{searchEvaluationWeights.getCountryWeight(), searchEvaluationWeights.getCityWeight(), searchEvaluationWeights.getDistrictWeight(), searchEvaluationWeights.getStreetWeight(), searchEvaluationWeights.getPostcodeWeight(), searchEvaluationWeights.getHousenumberWeight(), searchEvaluationWeights.getHousenumberExtensionWeight()};
        return weightValues;
    }

    private static double matching2(String[] orig, String[] eing, double[] parts, int weightAlias) {
        double matching = 0.0;
        for (int i = 0; i < orig.length; ++i) {
            double subMatching = 0.0;
            if (orig[i] == null) {
                subMatching = 100.0;
            } else {
                LOGGER.debug("Evaluating " + orig[i] + " - " + eing[i]);
                String origNorm = StringUtil.normalize(orig[i]);
                String inputNorm = StringUtil.normalize(eing[i]);
                LOGGER.debug("Evaluating " + origNorm + " - " + inputNorm);
                int lengthOfOrigNorm = origNorm == null ? 0 : origNorm.length();
                int lengthOfInputNorm = inputNorm == null ? 0 : inputNorm.length();
                int maxLength = Math.max(lengthOfOrigNorm, lengthOfInputNorm);
                if (maxLength == 0 || lengthOfInputNorm == 0) {
                    subMatching = 100.0;
                } else {
                    int levenshteinDistance = StringUtils.getLevenshteinDistance(origNorm, inputNorm);
                    subMatching = 1.0 - (double)levenshteinDistance / (double)maxLength;
                }
            }
            matching += subMatching * parts[i] / 100.0;
        }
        return matching;
    }

    private static double matching(String[] orig, String[] eing, double[] weight, int weightAlias, boolean[] ignoreEmpties) {
        boolean[] noMatchForced = new boolean[7];
        Arrays.fill(noMatchForced, false);
        return SearchEvaluation.matching(orig, eing, weight, weightAlias, ignoreEmpties, noMatchForced, noMatchForced);
    }

    private static double matching(String[] orig, String[] eing, double[] weight, int weightAlias, boolean[] ignoreEmpties, boolean[] noMatchForced, boolean[] isWildcard) {
        double sumWeight = 0.0;
        for (double element : weight) {
            sumWeight += element;
        }
        if (sumWeight == 0.0) {
            return 100.0;
        }
        double matching = 0.0;
        for (int i = 0; i < orig.length; ++i) {
            if (!noMatchForced[i] && !isWildcard[i]) {
                if (orig[i] == null || eing[i] == null) {
                    matching += weight[i];
                    continue;
                }
                LOGGER.debug("Evaluating " + orig[i] + " - " + eing[i]);
                String origNorm = StringUtil.normalize(StringUtil.nullToEmpty(orig[i]));
                String inputNorm = StringUtil.normalize(StringUtil.nullToEmpty(eing[i]));
                LOGGER.debug("Evaluating " + origNorm + " - " + inputNorm);
                int lengthOfOrigNorm = origNorm == null ? 0 : origNorm.length();
                int lengthOfInputNorm = inputNorm == null ? 0 : inputNorm.length();
                int maxLength = Math.max(lengthOfOrigNorm, lengthOfInputNorm);
                boolean ignoreEmpty = ignoreEmpties[i];
                if (maxLength == 0 || ignoreEmpty && lengthOfInputNorm == 0) {
                    matching += weight[i];
                    continue;
                }
                int levenshteinDistance = StringUtils.getLevenshteinDistance(origNorm, inputNorm);
                matching += (1.0 - (double)levenshteinDistance / (double)maxLength) * weight[i];
                continue;
            }
            matching += weight[i];
        }
        matching = matching / sumWeight * 100.0 * ((double)weightAlias / 100.0);
        BigDecimal matchingBD = new BigDecimal(matching);
        matchingBD = matchingBD.setScale(1, 1);
        matching = matchingBD.doubleValue();
        LOGGER.debug("Matching for [" + StringUtil.implode(orig, ", ") + "] and [" + StringUtil.implode(eing, ", ") + "] -> " + matching);
        return matching;
    }

    public static double matching(String[] orig, String[] eing, double[] weight, int weightAlias) {
        SearchEvaluationWeights searchEvaluationWeights = new SearchEvaluationWeights();
        boolean[] ignoreEmpties = SearchEvaluation.flatEmpties(searchEvaluationWeights);
        return SearchEvaluation.matching(orig, eing, weight, weightAlias, ignoreEmpties);
    }
}

