/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic.dto;

public enum OptimizationAlgorithmType {
    DEFAULT,
    CHRISTOFIDES,
    DEFAULT_SEGMENT_MIDDLE,
    CLUSTERING,
    NONE,
    DEFAULT_STREET_SIDE,
    CLUSTERING_STREET_SIDE,
    TOURPARTS_SEGMENT_MIDDLE,
    TIME_WINDOW,
    AREA_GROUP,
    DEFAULT_TIME,
    SEGMENT_TIME,
    CLUSTERING_TIME;


    public boolean withSide() {
        switch (this) {
            case DEFAULT: 
            case DEFAULT_TIME: 
            case CHRISTOFIDES: 
            case DEFAULT_SEGMENT_MIDDLE: 
            case SEGMENT_TIME: 
            case CLUSTERING: 
            case CLUSTERING_TIME: 
            case TOURPARTS_SEGMENT_MIDDLE: 
            case TIME_WINDOW: 
            case AREA_GROUP: 
            case NONE: {
                return false;
            }
            case CLUSTERING_STREET_SIDE: 
            case DEFAULT_STREET_SIDE: {
                return true;
            }
        }
        return false;
    }

    public OptimizationAlgorithmType getTimeType() {
        switch (this) {
            case DEFAULT: {
                return DEFAULT_TIME;
            }
            case DEFAULT_SEGMENT_MIDDLE: {
                return SEGMENT_TIME;
            }
            case CLUSTERING: {
                return CLUSTERING_TIME;
            }
        }
        return this;
    }

    public boolean isTimeType() {
        switch (this) {
            case DEFAULT_TIME: 
            case SEGMENT_TIME: 
            case CLUSTERING_TIME: {
                return true;
            }
        }
        return false;
    }
}

