/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic.dto;

import de.datomino.logistic.dto.AbstractLogisticDto;
import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.dto.TourPartType;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.logistic.type.RoutingType;
import de.datomino.util.geo.dto.ImmutableLineStringDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LogisticTourPartDto<T extends Serializable>
extends AbstractLogisticDto<Long> {
    private static final long serialVersionUID = -3949886747202992002L;
    private RouteVehicleType routeVehicleType;
    private RouteType routeType;
    private Date startTime;
    private Date endTime;
    private Integer durationSum;
    private Integer distanceSum;
    private Integer accessSum;
    private RoutingType routingType;
    private List<LogisticStopDto<T>> stopDtos;
    private Integer sizeOfStartBlock = 0;
    private Integer sizeOfEndBlock = 0;
    private ImmutableLineStringDto lineString;
    private Double difficultLevel;
    private Double parcelLocation;
    private Integer sizeOfStartPoi = 0;
    private Integer sizeOfEndPoi = 0;
    private TourPartType tourPartType;
    private Long areaId;

    public LogisticTourPartDto(Long id) {
        super(id);
    }

    public boolean isAllFix() {
        boolean b = false;
        if (this.getRoutingType() == OptimizationType.ALLFIX) {
            b = true;
        } else if (this.sizeOfStartBlock + this.sizeOfEndBlock >= this.getStopDtos().size()) {
            b = true;
        }
        return b;
    }

    public RouteVehicleType getRouteVehicleType() {
        if (this.routeVehicleType == null) {
            this.routeVehicleType = RouteVehicleType.MOTORCAR;
        }
        return this.routeVehicleType;
    }

    public void setRouteVehicleType(RouteVehicleType routeVehicleType) {
        this.routeVehicleType = routeVehicleType;
    }

    public RouteType getRouteType() {
        if (this.routeType == null) {
            this.routeType = RouteType.FASTEST;
        }
        return this.routeType;
    }

    public void setRouteType(RouteType routeType) {
        this.routeType = routeType;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getDurationSum() {
        return this.durationSum;
    }

    public void setDurationSum(Integer durationSum) {
        this.durationSum = durationSum;
    }

    public Integer getDistanceSum() {
        return this.distanceSum;
    }

    public void setDistanceSum(Integer distanceSum) {
        this.distanceSum = distanceSum;
    }

    public Integer getAccessSum() {
        return this.accessSum;
    }

    public void setAccessSum(Integer accessSum) {
        this.accessSum = accessSum;
    }

    public RoutingType getRoutingType() {
        if (this.routingType == null) {
            this.routingType = OptimizationType.NONFIX;
        }
        return this.routingType;
    }

    public void setRoutingType(RoutingType routingType) {
        this.routingType = routingType;
    }

    public List<LogisticStopDto<T>> getStopDtos() {
        if (this.stopDtos == null) {
            this.stopDtos = new ArrayList<LogisticStopDto<T>>();
        }
        return this.stopDtos;
    }

    public void setStopDtos(List<LogisticStopDto<T>> stopDtos) {
        this.stopDtos = stopDtos;
    }

    public Integer getSizeOfStartBlock() {
        return this.sizeOfStartBlock;
    }

    public void setSizeOfStartBlock(Integer sizeOfStartBlock) {
        this.sizeOfStartBlock = sizeOfStartBlock;
    }

    public Integer getSizeOfEndBlock() {
        return this.sizeOfEndBlock;
    }

    public void setSizeOfEndBlock(Integer sizeOfEndBlock) {
        this.sizeOfEndBlock = sizeOfEndBlock;
    }

    public ImmutableLineStringDto getLineString() {
        return this.lineString;
    }

    public void setLineString(ImmutableLineStringDto lineString) {
        this.lineString = lineString;
    }

    public Double getDifficultLevel() {
        if (this.difficultLevel == null) {
            this.difficultLevel = 100.0;
        }
        return this.difficultLevel;
    }

    public void setDifficultLevel(Double difficultLevel) {
        this.difficultLevel = difficultLevel;
    }

    public Double getParcelLocation() {
        if (this.parcelLocation == null) {
            this.parcelLocation = 100.0;
        }
        return this.parcelLocation;
    }

    public void setParcelLocation(Double parcelLocation) {
        this.parcelLocation = parcelLocation;
    }

    public Integer getSizeOfStartPoi() {
        return this.sizeOfStartPoi;
    }

    public void setSizeOfStartPoi(Integer sizeOfStartPoi) {
        this.sizeOfStartPoi = sizeOfStartPoi;
    }

    public Integer getSizeOfEndPoi() {
        return this.sizeOfEndPoi;
    }

    public void setSizeOfEndPoi(Integer sizeOfEndPoi) {
        this.sizeOfEndPoi = sizeOfEndPoi;
    }

    public TourPartType getTourPartType() {
        if (this.tourPartType == null) {
            this.tourPartType = TourPartType.NO_LINK;
        }
        return this.tourPartType;
    }

    public void setTourPartType(TourPartType tourPartType) {
        this.tourPartType = tourPartType;
    }

    public Long getAreaId() {
        return this.areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }
}

