/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic;

import de.datomino.logistic.LocationQualifier;
import de.datomino.logistic.LogisticException;
import de.datomino.logistic.LogisticRoute;
import de.datomino.logistic.LogisticServicesInterface;
import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.logistic.dto.LogisticServiceRouteDto;
import de.datomino.logistic.dto.LogisticServiceTourDto;
import de.datomino.logistic.dto.LogisticServiceTourLocationDto;
import de.datomino.logistic.dto.LogisticServiceTourResultDto;
import de.datomino.logistic.dto.LogisticTimeWindowDto;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.logistic.type.RangeType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.util.algorithm.tsp.ExactTsp;
import de.datomino.util.geo.ImmutablePoint;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ktde.util.datatypes.Tupel;

public class ExactTourLogisticServiceInterface
implements LogisticServicesInterface {
    private LocationQualifier locationQualifier;
    private LogisticRoute logisticRouteService;

    @Override
    public LogisticServiceTourResultDto optimizeTour(LogisticServiceTourDto tourFullDto, OptimizationType typ) throws LogisticException {
        HashMap adjacencyLists = new HashMap();
        HashMap<Long, Double> stopWeight = new HashMap<Long, Double>();
        HashMap wayLimits = new HashMap();
        int size = tourFullDto.getLogisticServiceRouteLocationDtos().size();
        for (LogisticServiceTourLocationDto logisticServiceTourLocationDto1 : tourFullDto.getLogisticServiceRouteLocationDtos()) {
            Long id1 = (Long)logisticServiceTourLocationDto1.getId();
            ArrayList<Tupel<Long, Double>> adacenyList = new ArrayList<Tupel<Long, Double>>(size - 1);
            for (LogisticServiceTourLocationDto logisticServiceTourLocationDto2 : tourFullDto.getLogisticServiceRouteLocationDtos()) {
                Long id2 = (Long)logisticServiceTourLocationDto2.getId();
                if (id1.equals(id2)) continue;
                LogisticServiceRouteDto logisticServiceRouteDto = this.logisticRouteService.calculateRouteBetweenCoordinate(((ImmutablePoint)logisticServiceTourLocationDto1.getAccessGeom().getGeoObject()).getCoordinate(), ((ImmutablePoint)logisticServiceTourLocationDto2.getAccessGeom().getGeoObject()).getCoordinate(), RouteVehicleType.MOTORCAR, RouteType.FASTEST);
                adacenyList.add(new Tupel<Long, Double>(id2, logisticServiceRouteDto.getTimeInSeconds().doubleValue()));
            }
            adjacencyLists.put(id1, adacenyList);
            stopWeight.put(id1, 0.0);
            ArrayList<Tupel<Double, Double>> wayLimit = new ArrayList<Tupel<Double, Double>>(logisticServiceTourLocationDto1.getLogisticServiceTimeWindowDtos().size());
            for (LogisticTimeWindowDto logisticServiceTimeWindowDto : logisticServiceTourLocationDto1.getLogisticServiceTimeWindowDtos()) {
                wayLimit.add(new Tupel<Double, Double>(this.extractDaySeconds(logisticServiceTimeWindowDto.getStartTime()).doubleValue(), this.extractDaySeconds(logisticServiceTimeWindowDto.getEndTime()).doubleValue()));
            }
        }
        Long startPoint = null;
        Long endPoint = null;
        switch (typ) {
            case BOTHPOINTFIX: {
                startPoint = (Long)tourFullDto.getLogisticServiceRouteLocationDtos().get(0).getId();
                endPoint = (Long)tourFullDto.getLogisticServiceRouteLocationDtos().get(size - 1).getId();
                break;
            }
        }
        ExactTsp<Object> exactTsp = new ExactTsp<Object>(adjacencyLists, wayLimits, (Map<Object, Double>)stopWeight, startPoint, endPoint);
        exactTsp.start(false);
        List solution = exactTsp.getSolution();
        return null;
    }

    private Integer extractDaySeconds(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(13) + cal.get(12) * 60 + cal.get(11) * 60 * 60;
    }

    @Override
    public LogisticServiceTourResultDto calculateTour(LogisticServiceTourDto tourFullDto) throws LogisticException {
        return this.optimizeTour(tourFullDto, OptimizationType.NONFIX);
    }

    @Override
    public List<LogisticQualifiedLocationDto> findLocations(LogisticLocationDto<?> logisticLocationDto, Integer maxCount, boolean exact, String userLoginName) throws LogisticException {
        return this.locationQualifier.findLocations(logisticLocationDto, maxCount, exact, userLoginName);
    }

    @Override
    public List<LogisticQualifiedLocationDto> findRange(LogisticLocationDto<?> logisticLocationDto, Tupel<Tupel<Integer, String>, Tupel<Integer, String>> range, RangeType rangeType, Integer maxCount) throws LogisticException {
        return this.locationQualifier.findRange(logisticLocationDto, range, rangeType, maxCount);
    }

    @Override
    public LogisticQualifiedLocationDto validateLocation(LogisticLocationDto<?> logisticLocationDto) throws LogisticException {
        return this.locationQualifier.validateLocation(logisticLocationDto);
    }

    public void setLocationQualifier(LocationQualifier locationQualifier) {
        this.locationQualifier = locationQualifier;
    }

    @Override
    public boolean isIdentifyable() {
        return this.locationQualifier.isIdentifyable();
    }

    @Override
    public boolean isRangeable() {
        return this.locationQualifier.isRangeable();
    }

    @Override
    public String getName() {
        return this.locationQualifier.getName();
    }

    @Override
    public Long getGap() {
        return this.locationQualifier.getGap();
    }

    @Override
    public List<LogisticQualifiedLocationDto> findLocationsWithWildcard(LogisticLocationDto<?> logisticLocationDto, Integer maxCount, String userLoginName) throws LogisticException {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public boolean supportsWildcard() {
        return false;
    }
}

