/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.debug;

import de.datomino.debug.AbstractIndexedDebugWatch;

public class MemoryDebugWatch
extends AbstractIndexedDebugWatch {
    private static final long serialVersionUID = -538462692667350903L;

    public MemoryDebugWatch() {
        super("JVM Memory", null, "Free", "Avail", "Used", "Alloc", "Max");
    }

    @Override
    protected String getValue(int index) {
        long maxMemory = Runtime.getRuntime().maxMemory() / 1000000L;
        long freeMemory = Runtime.getRuntime().freeMemory() / 1000000L;
        long allocMemory = Runtime.getRuntime().totalMemory() / 1000000L;
        long usedMemory = allocMemory - freeMemory;
        long availMemory = maxMemory - usedMemory;
        switch (index) {
            case 0: {
                return freeMemory + "MB";
            }
            case 1: {
                return availMemory + "MB";
            }
            case 2: {
                return usedMemory + "MB";
            }
            case 3: {
                return allocMemory + "MB";
            }
            case 4: {
                return maxMemory + "MB";
            }
        }
        return "";
    }
}

