/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance3d;

import com.vividsolutions.jts.algorithm.RayCrossingCounter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.math.Plane3D;
import com.vividsolutions.jts.math.Vector3D;
import com.vividsolutions.jts.operation.distance3d.AxisPlaneCoordinateSequence;

public class PlanarPolygon3D {
    private Plane3D plane;
    private Polygon poly;
    private int facingPlane = -1;

    public PlanarPolygon3D(Polygon poly) {
        this.poly = poly;
        this.plane = this.findBestFitPlane(poly);
        this.facingPlane = this.plane.closestAxisPlane();
    }

    private Plane3D findBestFitPlane(Polygon poly) {
        CoordinateSequence seq = poly.getExteriorRing().getCoordinateSequence();
        Coordinate basePt = this.averagePoint(seq);
        Vector3D normal = this.averageNormal(seq);
        return new Plane3D(normal, basePt);
    }

    private Vector3D averageNormal(CoordinateSequence seq) {
        int n = seq.size();
        Coordinate sum = new Coordinate(0.0, 0.0, 0.0);
        Coordinate p1 = new Coordinate(0.0, 0.0, 0.0);
        Coordinate p2 = new Coordinate(0.0, 0.0, 0.0);
        int i = 0;
        while (i < n - 1) {
            seq.getCoordinate(i, p1);
            seq.getCoordinate(i + 1, p2);
            sum.x += (p1.y - p2.y) * (p1.z + p2.z);
            sum.y += (p1.z - p2.z) * (p1.x + p2.x);
            sum.z += (p1.x - p2.x) * (p1.y + p2.y);
            ++i;
        }
        sum.x /= (double)n;
        sum.y /= (double)n;
        sum.z /= (double)n;
        Vector3D norm = Vector3D.create(sum).normalize();
        return norm;
    }

    private Coordinate averagePoint(CoordinateSequence seq) {
        Coordinate a = new Coordinate(0.0, 0.0, 0.0);
        int n = seq.size();
        int i = 0;
        while (i < n) {
            a.x += seq.getOrdinate(i, 0);
            a.y += seq.getOrdinate(i, 1);
            a.z += seq.getOrdinate(i, 2);
            ++i;
        }
        a.x /= (double)n;
        a.y /= (double)n;
        a.z /= (double)n;
        return a;
    }

    public Plane3D getPlane() {
        return this.plane;
    }

    public Polygon getPolygon() {
        return this.poly;
    }

    public boolean intersects(Coordinate intPt) {
        if (2 == this.locate(intPt, this.poly.getExteriorRing())) {
            return false;
        }
        int i = 0;
        while (i < this.poly.getNumInteriorRing()) {
            if (this.locate(intPt, this.poly.getInteriorRingN(i)) == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int locate(Coordinate pt, LineString ring) {
        CoordinateSequence seq = ring.getCoordinateSequence();
        CoordinateSequence seqProj = PlanarPolygon3D.project(seq, this.facingPlane);
        Coordinate ptProj = PlanarPolygon3D.project(pt, this.facingPlane);
        return RayCrossingCounter.locatePointInRing((Coordinate)ptProj, (CoordinateSequence)seqProj);
    }

    public boolean intersects(Coordinate pt, LineString ring) {
        CoordinateSequence seq = ring.getCoordinateSequence();
        CoordinateSequence seqProj = PlanarPolygon3D.project(seq, this.facingPlane);
        Coordinate ptProj = PlanarPolygon3D.project(pt, this.facingPlane);
        return 2 != RayCrossingCounter.locatePointInRing((Coordinate)ptProj, (CoordinateSequence)seqProj);
    }

    private static CoordinateSequence project(CoordinateSequence seq, int facingPlane) {
        switch (facingPlane) {
            case 1: {
                return AxisPlaneCoordinateSequence.projectToXY(seq);
            }
            case 3: {
                return AxisPlaneCoordinateSequence.projectToXZ(seq);
            }
        }
        return AxisPlaneCoordinateSequence.projectToYZ(seq);
    }

    private static Coordinate project(Coordinate p, int facingPlane) {
        switch (facingPlane) {
            case 1: {
                return new Coordinate(p.x, p.y);
            }
            case 3: {
                return new Coordinate(p.x, p.z);
            }
        }
        return new Coordinate(p.y, p.z);
    }
}

