/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.details.AbstractPathDetailsBuilder;

public class TimeDetails
extends AbstractPathDetailsBuilder {
    private final Weighting weighting;
    private int edgeId = -1;
    private long time = 0L;

    public TimeDetails(Weighting weighting) {
        super("time");
        this.weighting = weighting;
    }

    @Override
    public boolean isEdgeDifferentToLastEdge(EdgeIteratorState edge) {
        if (edge.getEdge() != this.edgeId) {
            this.edgeId = edge.getEdge();
            this.time = this.weighting.calcMillis(edge, false, -1);
            return true;
        }
        return false;
    }

    @Override
    public Object getCurrentValue() {
        return this.time;
    }
}

