/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.GHPoint3D;

public class GPXEntry
extends GHPoint3D {
    private long time;

    public GPXEntry(GHPoint p, long millis) {
        this(p.lat, p.lon, millis);
    }

    public GPXEntry(double lat, double lon, long millis) {
        super(lat, lon, Double.NaN);
        this.time = millis;
    }

    public GPXEntry(double lat, double lon, double ele, long millis) {
        super(lat, lon, ele);
        this.time = millis;
    }

    boolean is3D() {
        return !Double.isNaN(this.ele);
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public int hashCode() {
        return 59 * super.hashCode() + (int)(this.time ^ this.time >>> 32);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        GPXEntry other = (GPXEntry)obj;
        return this.time == other.time && super.equals(obj);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", " + this.time;
    }
}

