/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.AbstractDataAccess;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.util.Constants;
import com.graphhopper.util.Helper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class MMapDataAccess
extends AbstractDataAccess {
    private final boolean allowWrites;
    private RandomAccessFile raFile;
    private List<ByteBuffer> segments = new ArrayList<ByteBuffer>();

    MMapDataAccess(String name, String location, ByteOrder order, boolean allowWrites) {
        super(name, location, order);
        this.allowWrites = allowWrites;
    }

    private void initRandomAccessFile() {
        if (this.raFile != null) {
            return;
        }
        try {
            this.raFile = new RandomAccessFile(this.getFullName(), this.allowWrites ? "rw" : "r");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public MMapDataAccess create(long bytes) {
        if (!this.segments.isEmpty()) {
            throw new IllegalThreadStateException("already created");
        }
        this.initRandomAccessFile();
        bytes = Math.max(40L, bytes);
        this.setSegmentSize(this.segmentSizeInBytes);
        this.ensureCapacity(bytes);
        return this;
    }

    @Override
    public DataAccess copyTo(DataAccess da) {
        return super.copyTo(da);
    }

    @Override
    public boolean ensureCapacity(long bytes) {
        return this.mapIt(100L, bytes);
    }

    private boolean mapIt(long offset, long byteCount) {
        if (byteCount < 0L) {
            throw new IllegalArgumentException("new capacity has to be strictly positive");
        }
        if (byteCount <= this.getCapacity()) {
            return false;
        }
        long longSegmentSize = this.segmentSizeInBytes;
        int segmentsToMap = (int)(byteCount / longSegmentSize);
        if (segmentsToMap < 0) {
            throw new IllegalStateException("Too many segments needs to be allocated. Increase segmentSize.");
        }
        if (byteCount % longSegmentSize != 0L) {
            ++segmentsToMap;
        }
        if (segmentsToMap == 0) {
            throw new IllegalStateException("0 segments are not allowed.");
        }
        long bufferStart = offset;
        int i = 0;
        long newFileLength = offset + (long)segmentsToMap * longSegmentSize;
        try {
            bufferStart += (long)this.segments.size() * longSegmentSize;
            int newSegments = segmentsToMap - this.segments.size();
            while (i < newSegments) {
                this.segments.add(this.newByteBuffer(bufferStart, longSegmentSize));
                bufferStart += longSegmentSize;
                ++i;
            }
            return true;
        }
        catch (IOException ex) {
            throw new RuntimeException("Couldn't map buffer " + i + " of " + segmentsToMap + " for " + this.name + " at position " + bufferStart + " for " + byteCount + " bytes with offset " + offset + ", new fileLength:" + newFileLength, ex);
        }
    }

    private ByteBuffer newByteBuffer(long offset, long byteCount) throws IOException {
        ByteBuffer buf = null;
        IOException ioex = null;
        for (int trial = 0; trial < 1; ++trial) {
            try {
                buf = this.raFile.getChannel().map(this.allowWrites ? FileChannel.MapMode.READ_WRITE : FileChannel.MapMode.READ_ONLY, offset, byteCount);
                break;
            }
            catch (IOException tmpex) {
                ioex = tmpex;
                Helper.cleanHack();
                try {
                    Thread.sleep(5L);
                    continue;
                }
                catch (InterruptedException iex) {
                    throw new IOException(iex);
                }
            }
        }
        if (buf == null) {
            if (ioex == null) {
                throw new AssertionError((Object)"internal problem as the exception 'ioex' shouldn't be null");
            }
            throw ioex;
        }
        buf.order(this.byteOrder);
        return buf;
    }

    @Override
    public boolean loadExisting() {
        long byteCount;
        block6: {
            if (this.segments.size() > 0) {
                throw new IllegalStateException("already initialized");
            }
            if (this.isClosed()) {
                throw new IllegalStateException("already closed");
            }
            File file = new File(this.getFullName());
            if (!file.exists() || file.length() == 0L) {
                return false;
            }
            this.initRandomAccessFile();
            try {
                byteCount = this.readHeader(this.raFile);
                if (byteCount >= 0L) break block6;
                return false;
            }
            catch (IOException ex) {
                throw new RuntimeException("Problem while loading " + this.getFullName(), ex);
            }
        }
        this.mapIt(100L, byteCount - 100L);
        return true;
    }

    @Override
    public void flush() {
        if (this.isClosed()) {
            throw new IllegalStateException("already closed");
        }
        try {
            if (!this.segments.isEmpty() && this.segments.get(0) instanceof MappedByteBuffer) {
                for (ByteBuffer bb : this.segments) {
                    ((MappedByteBuffer)bb).force();
                }
            }
            this.writeHeader(this.raFile, this.raFile.length(), this.segmentSizeInBytes);
            this.raFile.getFD().sync();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        super.close();
        this.close(true);
    }

    void close(boolean forceClean) {
        this.clean(0, this.segments.size());
        this.segments.clear();
        Helper.close(this.raFile);
        if (forceClean) {
            Helper.cleanHack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setInt(long bytePos, int value) {
        ByteBuffer byteBuffer;
        int bufferIndex = (int)(bytePos >> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        ByteBuffer byteBuffer2 = byteBuffer = this.segments.get(bufferIndex);
        synchronized (byteBuffer2) {
            byteBuffer.putInt(index, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getInt(long bytePos) {
        ByteBuffer byteBuffer;
        int bufferIndex = (int)(bytePos >> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        ByteBuffer byteBuffer2 = byteBuffer = this.segments.get(bufferIndex);
        synchronized (byteBuffer2) {
            return byteBuffer.getInt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setShort(long bytePos, short value) {
        ByteBuffer byteBuffer;
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        ByteBuffer byteBuffer2 = byteBuffer = this.segments.get(bufferIndex);
        synchronized (byteBuffer2) {
            byteBuffer.putShort(index, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final short getShort(long bytePos) {
        ByteBuffer byteBuffer;
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        ByteBuffer byteBuffer2 = byteBuffer = this.segments.get(bufferIndex);
        synchronized (byteBuffer2) {
            return byteBuffer.getShort(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(long bytePos, byte[] values, int length) {
        ByteBuffer bb1;
        assert (length <= this.segmentSizeInBytes) : "the length has to be smaller or equal to the segment size: " + length + " vs. " + this.segmentSizeInBytes;
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        int delta = index + length - this.segmentSizeInBytes;
        ByteBuffer byteBuffer = bb1 = this.segments.get(bufferIndex);
        synchronized (byteBuffer) {
            bb1.position(index);
            if (delta > 0) {
                bb1.put(values, 0, length -= delta);
            } else {
                bb1.put(values, 0, length);
            }
        }
        if (delta > 0) {
            ByteBuffer bb2;
            ByteBuffer byteBuffer2 = bb2 = this.segments.get(bufferIndex + 1);
            synchronized (byteBuffer2) {
                bb2.position(0);
                bb2.put(values, length, delta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBytes(long bytePos, byte[] values, int length) {
        ByteBuffer bb1;
        assert (length <= this.segmentSizeInBytes) : "the length has to be smaller or equal to the segment size: " + length + " vs. " + this.segmentSizeInBytes;
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        int delta = index + length - this.segmentSizeInBytes;
        ByteBuffer byteBuffer = bb1 = this.segments.get(bufferIndex);
        synchronized (byteBuffer) {
            bb1.position(index);
            if (delta > 0) {
                bb1.get(values, 0, length -= delta);
            } else {
                bb1.get(values, 0, length);
            }
        }
        if (delta > 0) {
            ByteBuffer bb2;
            ByteBuffer byteBuffer2 = bb2 = this.segments.get(bufferIndex + 1);
            synchronized (byteBuffer2) {
                bb2.position(0);
                bb2.get(values, length, delta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCapacity() {
        long cap = 0L;
        Iterator<ByteBuffer> iterator = this.segments.iterator();
        while (iterator.hasNext()) {
            ByteBuffer bb;
            ByteBuffer byteBuffer = bb = iterator.next();
            synchronized (byteBuffer) {
                cap += (long)bb.capacity();
            }
        }
        return cap;
    }

    @Override
    public int getSegments() {
        return this.segments.size();
    }

    private void clean(int from, int to) {
        int i = from;
        while (i < to) {
            ByteBuffer bb = this.segments.get(i);
            Helper.cleanMappedByteBuffer(bb);
            this.segments.set(i, null);
            ++i;
        }
    }

    @Override
    public void trimTo(long capacity) {
        if (capacity < (long)this.segmentSizeInBytes) {
            capacity = this.segmentSizeInBytes;
        }
        int remainingSegNo = (int)(capacity / (long)this.segmentSizeInBytes);
        if (capacity % (long)this.segmentSizeInBytes != 0L) {
            ++remainingSegNo;
        }
        this.clean(remainingSegNo, this.segments.size());
        Helper.cleanHack();
        this.segments = new ArrayList<ByteBuffer>(this.segments.subList(0, remainingSegNo));
        try {
            if (!Constants.WINDOWS) {
                this.raFile.setLength(100 + remainingSegNo * this.segmentSizeInBytes);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void rename(String newName) {
        if (!this.checkBeforeRename(newName)) {
            return;
        }
        this.close();
        super.rename(newName);
        this.raFile = null;
        this.closed = false;
        this.loadExisting();
    }

    @Override
    public DAType getType() {
        return DAType.MMAP;
    }
}

