/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.BreadthFirstSearch;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.Circle;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.Shape;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.List;

public class GraphEdgeIdFinder {
    private final Graph graph;
    private final LocationIndex locationIndex;

    public GraphEdgeIdFinder(Graph graph, LocationIndex locationIndex) {
        this.graph = graph;
        this.locationIndex = locationIndex;
    }

    public void findClosestEdgeToPoint(GHIntHashSet edgeIds, GHPoint point, EdgeFilter filter) {
        this.findClosestEdge(edgeIds, point.getLat(), point.getLon(), filter);
    }

    public void findClosestEdge(GHIntHashSet edgeIds, double lat, double lon, EdgeFilter filter) {
        QueryResult qr = this.locationIndex.findClosest(lat, lon, filter);
        if (qr.isValid()) {
            edgeIds.add(qr.getClosestEdge().getEdge());
        }
    }

    public void findEdgesInShape(final GHIntHashSet edgeIds, Shape shape, EdgeFilter filter) {
        GHPoint center = shape.getCenter();
        QueryResult qr = this.locationIndex.findClosest(center.getLat(), center.getLon(), filter);
        if (!qr.isValid()) {
            throw new IllegalArgumentException("Shape " + shape + " does not cover graph");
        }
        if (shape.contains(qr.getSnappedPoint().lat, qr.getSnappedPoint().lon)) {
            edgeIds.add(qr.getClosestEdge().getEdge());
        }
        BreadthFirstSearch bfs = new BreadthFirstSearch(shape){
            final NodeAccess na;
            final Shape localShape;
            {
                this.na = GraphEdgeIdFinder.this.graph.getNodeAccess();
                this.localShape = shape;
            }

            @Override
            protected boolean goFurther(int nodeId) {
                return this.localShape.contains(this.na.getLatitude(nodeId), this.na.getLongitude(nodeId));
            }

            @Override
            protected boolean checkAdjacent(EdgeIteratorState edge) {
                if (this.localShape.contains(this.na.getLatitude(edge.getAdjNode()), this.na.getLongitude(edge.getAdjNode()))) {
                    edgeIds.add(edge.getEdge());
                    return true;
                }
                return false;
            }
        };
        bfs.start(this.graph.createEdgeExplorer(filter), qr.getClosestNode());
    }

    public void fillEdgeIDs(GHIntHashSet edgeIds, Geometry geometry, EdgeFilter filter) {
        if (geometry instanceof Point) {
            GHPoint point = GHPoint.create((Point)geometry);
            this.findClosestEdgeToPoint(edgeIds, point, filter);
        } else if (geometry instanceof LineString) {
            PointList pl = PointList.from((LineString)geometry);
            int lastIdx = pl.size() - 1;
            if (pl.size() >= 2) {
                double meanLat = (pl.getLatitude(0) + pl.getLatitude(lastIdx)) / 2.0;
                double meanLon = (pl.getLongitude(0) + pl.getLongitude(lastIdx)) / 2.0;
                this.findClosestEdge(edgeIds, meanLat, meanLon, filter);
            }
        } else if (geometry instanceof MultiPoint) {
            Coordinate[] coordinateArray = geometry.getCoordinates();
            int n = coordinateArray.length;
            int n2 = 0;
            while (n2 < n) {
                Coordinate coordinate = coordinateArray[n2];
                this.findClosestEdge(edgeIds, coordinate.y, coordinate.x, filter);
                ++n2;
            }
        }
    }

    public BlockArea parseBlockArea(String blockAreaString, EdgeFilter filter, double useEdgeIdsUntilAreaSize) {
        String objectSeparator = ";";
        String innerObjSep = ",";
        BlockArea blockArea = new BlockArea(this.graph);
        if (!blockAreaString.isEmpty()) {
            String[] blockedCircularAreasArr = blockAreaString.split(";");
            int i = 0;
            while (i < blockedCircularAreasArr.length) {
                double lon;
                String objectAsString = blockedCircularAreasArr[i];
                String[] splittedObject = objectAsString.split(",");
                if (splittedObject.length == 4) {
                    BBox bbox = BBox.parseTwoPoints(objectAsString);
                    if (bbox.calculateArea() > useEdgeIdsUntilAreaSize) {
                        blockArea.add(bbox);
                    } else {
                        this.findEdgesInShape(blockArea.blockedEdges, bbox, filter);
                    }
                } else if (splittedObject.length == 3) {
                    int radius;
                    double lat = Double.parseDouble(splittedObject[0]);
                    Circle circle = new Circle(lat, lon = Double.parseDouble(splittedObject[1]), radius = Integer.parseInt(splittedObject[2]));
                    if (circle.calculateArea() > useEdgeIdsUntilAreaSize) {
                        blockArea.add(circle);
                    } else {
                        this.findEdgesInShape(blockArea.blockedEdges, circle, filter);
                    }
                } else if (splittedObject.length == 2) {
                    double lat = Double.parseDouble(splittedObject[0]);
                    lon = Double.parseDouble(splittedObject[1]);
                    this.findClosestEdge(blockArea.blockedEdges, lat, lon, filter);
                } else {
                    throw new IllegalArgumentException(String.valueOf(objectAsString) + " at index " + i + " need to be defined as lat,lon " + "or as a circle lat,lon,radius or rectangular lat1,lon1,lat2,lon2");
                }
                ++i;
            }
        }
        return blockArea;
    }

    public static class BlockArea {
        final GHIntHashSet blockedEdges = new GHIntHashSet();
        final List<Shape> blockedShapes = new ArrayList<Shape>();
        private final NodeAccess na;

        public BlockArea(Graph g) {
            this.na = g.getNodeAccess();
        }

        public void add(int edgeId) {
            this.blockedEdges.addAll(edgeId);
        }

        public void add(Shape shape) {
            this.blockedShapes.add(shape);
        }

        public final boolean contains(EdgeIteratorState edgeState) {
            if (!this.blockedEdges.isEmpty() && this.blockedEdges.contains(edgeState.getEdge())) {
                return true;
            }
            if (!this.blockedShapes.isEmpty() && this.na != null) {
                for (Shape shape : this.blockedShapes) {
                    if (!shape.contains(this.na.getLatitude(edgeState.getAdjNode()), this.na.getLongitude(edgeState.getAdjNode()))) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

