/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.CarFlagEncoder;
import com.graphhopper.routing.util.EncodedDoubleValue;
import com.graphhopper.routing.util.EncodedValue;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.weighting.CurvatureWeighting;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;
import java.util.HashSet;
import java.util.Set;

public class MotorcycleFlagEncoder
extends CarFlagEncoder {
    public static final int CURVATURE_KEY = 112;
    private final HashSet<String> avoidSet = new HashSet();
    private final HashSet<String> preferSet = new HashSet();
    private EncodedDoubleValue reverseSpeedEncoder;
    private EncodedValue priorityWayEncoder;
    private EncodedValue curvatureEncoder;

    public MotorcycleFlagEncoder() {
        this(5, 5.0, 0);
    }

    public MotorcycleFlagEncoder(PMap properties) {
        this((int)properties.getLong("speed_bits", 5L), properties.getDouble("speed_factor", 5.0), properties.getBool("turn_costs", false) ? 1 : 0);
        this.properties = properties;
        this.setBlockFords(properties.getBool("block_fords", true));
    }

    public MotorcycleFlagEncoder(String propertiesStr) {
        this(new PMap(propertiesStr));
    }

    public MotorcycleFlagEncoder(int speedBits, double speedFactor, int maxTurnCosts) {
        super(speedBits, speedFactor, maxTurnCosts);
        this.restrictions.remove("motorcar");
        this.restrictions.add("motorcycle");
        this.absoluteBarriers.remove("bus_trap");
        this.absoluteBarriers.remove("sump_buster");
        this.trackTypeSpeedMap.clear();
        this.defaultSpeedMap.clear();
        this.trackTypeSpeedMap.put("grade1", 20);
        this.trackTypeSpeedMap.put("grade2", 15);
        this.trackTypeSpeedMap.put("grade3", 10);
        this.trackTypeSpeedMap.put("grade4", 5);
        this.trackTypeSpeedMap.put("grade5", 5);
        this.avoidSet.add("motorway");
        this.avoidSet.add("trunk");
        this.avoidSet.add("motorroad");
        this.avoidSet.add("residential");
        this.preferSet.add("primary");
        this.preferSet.add("secondary");
        this.preferSet.add("tertiary");
        this.maxPossibleSpeed = 120;
        this.defaultSpeedMap.put("motorway", 100);
        this.defaultSpeedMap.put("motorway_link", 70);
        this.defaultSpeedMap.put("motorroad", 90);
        this.defaultSpeedMap.put("trunk", 80);
        this.defaultSpeedMap.put("trunk_link", 75);
        this.defaultSpeedMap.put("primary", 65);
        this.defaultSpeedMap.put("primary_link", 60);
        this.defaultSpeedMap.put("secondary", 60);
        this.defaultSpeedMap.put("secondary_link", 50);
        this.defaultSpeedMap.put("tertiary", 50);
        this.defaultSpeedMap.put("tertiary_link", 40);
        this.defaultSpeedMap.put("unclassified", 30);
        this.defaultSpeedMap.put("residential", 30);
        this.defaultSpeedMap.put("living_street", 5);
        this.defaultSpeedMap.put("service", 20);
        this.defaultSpeedMap.put("road", 20);
        this.defaultSpeedMap.put("track", 15);
        this.init();
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public int defineWayBits(int index, int shift) {
        shift = super.defineWayBits(index, shift);
        this.reverseSpeedEncoder = new EncodedDoubleValue("Reverse Speed", shift, this.speedBits, this.speedFactor, ((Integer)this.defaultSpeedMap.get("secondary")).intValue(), this.maxPossibleSpeed);
        this.priorityWayEncoder = new EncodedValue("PreferWay", shift += this.reverseSpeedEncoder.getBits(), 3, 1.0, 3L, 7);
        this.curvatureEncoder = new EncodedValue("Curvature", shift += this.priorityWayEncoder.getBits(), 4, 1.0, 10L, 10);
        return shift += this.curvatureEncoder.getBits();
    }

    @Override
    public long acceptWay(ReaderWay way) {
        String tt;
        String highwayValue = way.getTag("highway");
        String firstValue = way.getFirstPriorityTag(this.restrictions);
        if (highwayValue == null) {
            if (way.hasTag("route", (Set<String>)this.ferries)) {
                if (this.restrictedValues.contains(firstValue)) {
                    return 0L;
                }
                if (this.intendedValues.contains(firstValue) || firstValue.isEmpty() && !way.hasTag("foot", new String[0]) && !way.hasTag("bicycle", new String[0])) {
                    return this.acceptBit | this.ferryBit;
                }
            }
            return 0L;
        }
        if ("track".equals(highwayValue) && (tt = way.getTag("tracktype")) != null && !tt.equals("grade1")) {
            return 0L;
        }
        if (!this.defaultSpeedMap.containsKey(highwayValue)) {
            return 0L;
        }
        if (way.hasTag("impassable", (Object)"yes") || way.hasTag("status", (Object)"impassable")) {
            return 0L;
        }
        if (!firstValue.isEmpty()) {
            if (this.restrictedValues.contains(firstValue) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
                return 0L;
            }
            if (this.intendedValues.contains(firstValue)) {
                return this.acceptBit;
            }
        }
        if (this.isBlockFords() && ("ford".equals(highwayValue) || way.hasTag("ford", new String[0]))) {
            return 0L;
        }
        if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way)) {
            return 0L;
        }
        return this.acceptBit;
    }

    @Override
    public long handleWayTags(ReaderWay way, long allowed, long priorityFromRelation) {
        if (!this.isAccept(allowed)) {
            return 0L;
        }
        long flags = 0L;
        if (!this.isFerry(allowed)) {
            boolean isRoundabout;
            double speed = this.getSpeed(way);
            speed = this.applyMaxSpeed(way, speed);
            double maxMCSpeed = this.parseSpeed(way.getTag("maxspeed:motorcycle"));
            if (maxMCSpeed > 0.0 && maxMCSpeed < speed) {
                speed = maxMCSpeed * 0.9;
            }
            if (speed > 30.0 && way.hasTag("surface", (Set<String>)this.badSurfaceSpeedMap)) {
                speed = 30.0;
            }
            boolean bl = isRoundabout = way.hasTag("junction", (Object)"roundabout") || way.hasTag("junction", (Object)"circular");
            if (isRoundabout) {
                flags = this.setBool(0L, 2, true);
            }
            if (way.hasTag("oneway", (Set<String>)this.oneways) || isRoundabout) {
                if (way.hasTag("oneway", (Object)"-1")) {
                    flags = this.setReverseSpeed(flags, speed);
                    flags |= this.backwardBit;
                } else {
                    flags = this.setSpeed(flags, speed);
                    flags |= this.forwardBit;
                }
            } else {
                flags = this.setSpeed(flags, speed);
                flags = this.setReverseSpeed(flags, speed);
                flags |= this.directionBitMask;
            }
        } else {
            double ferrySpeed = this.getFerrySpeed(way);
            flags = this.setSpeed(flags, ferrySpeed);
            flags = this.setReverseSpeed(flags, ferrySpeed);
            flags |= this.directionBitMask;
        }
        flags = this.priorityWayEncoder.setValue(flags, this.handlePriority(way, priorityFromRelation));
        flags = this.curvatureEncoder.setValue(flags, 10L);
        return flags;
    }

    @Override
    public double getReverseSpeed(long flags) {
        return this.reverseSpeedEncoder.getDoubleValue(flags);
    }

    @Override
    public long setReverseSpeed(long flags, double speed) {
        if (speed < 0.0) {
            throw new IllegalArgumentException("Speed cannot be negative: " + speed + ", flags:" + BitUtil.LITTLE.toBitString(flags));
        }
        if (speed < this.speedEncoder.factor / 2.0) {
            return this.setLowSpeed(flags, speed, true);
        }
        if (speed > this.getMaxSpeed()) {
            speed = this.getMaxSpeed();
        }
        return this.reverseSpeedEncoder.setDoubleValue(flags, speed);
    }

    @Override
    protected long setLowSpeed(long flags, double speed, boolean reverse) {
        if (reverse) {
            return this.setBool(this.reverseSpeedEncoder.setDoubleValue(flags, 0.0), 1, false);
        }
        return this.setBool(this.speedEncoder.setDoubleValue(flags, 0.0), 0, false);
    }

    @Override
    public long flagsDefault(boolean forward, boolean backward) {
        long flags = super.flagsDefault(forward, backward);
        if (backward) {
            return this.reverseSpeedEncoder.setDefaultValue(flags);
        }
        return flags;
    }

    @Override
    public long setProperties(double speed, boolean forward, boolean backward) {
        long flags = super.setProperties(speed, forward, backward);
        if (backward) {
            return this.setReverseSpeed(flags, speed);
        }
        return flags;
    }

    @Override
    public long reverseFlags(long flags) {
        flags = super.reverseFlags(flags);
        double otherValue = this.reverseSpeedEncoder.getDoubleValue(flags);
        flags = this.setReverseSpeed(flags, this.speedEncoder.getDoubleValue(flags));
        return this.setSpeed(flags, otherValue);
    }

    @Override
    public double getDouble(long flags, int key) {
        switch (key) {
            case 101: {
                return (double)this.priorityWayEncoder.getValue(flags) / (double)PriorityCode.BEST.getValue();
            }
            case 112: {
                return (double)this.curvatureEncoder.getValue(flags) / 10.0;
            }
        }
        return super.getDouble(flags, key);
    }

    private int handlePriority(ReaderWay way, long relationFlags) {
        String highway = way.getTag("highway", "");
        if (this.avoidSet.contains(highway)) {
            return PriorityCode.WORST.getValue();
        }
        if (this.preferSet.contains(highway)) {
            return PriorityCode.BEST.getValue();
        }
        return PriorityCode.UNCHANGED.getValue();
    }

    @Override
    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
        double speed = this.getSpeed(edge.getFlags());
        double roadDistance = edge.getDistance();
        double beelineDistance = this.getBeelineDistance(way);
        double bendiness = beelineDistance / roadDistance;
        bendiness = this.discriminateSlowStreets(bendiness, speed);
        bendiness = this.increaseBendinessImpact(bendiness);
        bendiness = this.correctErrors(bendiness);
        edge.setFlags(this.curvatureEncoder.setValue(edge.getFlags(), this.convertToInt(bendiness)));
    }

    private double getBeelineDistance(ReaderWay way) {
        return way.getTag("estimated_distance", Double.POSITIVE_INFINITY);
    }

    protected double discriminateSlowStreets(double bendiness, double speed) {
        if (speed < 51.0) {
            return 1.0;
        }
        return bendiness;
    }

    protected double correctErrors(double bendiness) {
        if (bendiness < 0.01 || bendiness > 1.0) {
            return 1.0;
        }
        return bendiness;
    }

    protected double increaseBendinessImpact(double bendiness) {
        return Math.pow(bendiness, 2.0);
    }

    @Override
    public boolean supports(Class<?> feature) {
        if (super.supports(feature)) {
            return true;
        }
        if (CurvatureWeighting.class.isAssignableFrom(feature)) {
            return true;
        }
        return PriorityWeighting.class.isAssignableFrom(feature);
    }

    protected int convertToInt(double bendiness) {
        return (int)(bendiness *= 10.0);
    }

    @Override
    public String toString() {
        return "motorcycle";
    }
}

