/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm.conditional;

import com.graphhopper.reader.osm.conditional.ConditionalValueParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalParser {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<String> restrictedTags;
    private final List<ConditionalValueParser> valueParsers = new ArrayList<ConditionalValueParser>(5);
    private final boolean enabledLogs;

    public ConditionalParser(Set<String> restrictedTags) {
        this(restrictedTags, false);
    }

    public ConditionalParser(Set<String> restrictedTags, boolean enabledLogs) {
        this.restrictedTags = restrictedTags;
        this.enabledLogs = enabledLogs;
    }

    public static ConditionalValueParser createNumberParser(final String assertKey, final Number obj) {
        return new ConditionalValueParser(){

            @Override
            public ConditionalValueParser.ConditionState checkCondition(String conditionalValue) throws ParseException {
                int indexLT = conditionalValue.indexOf("<");
                if (indexLT > 0 && conditionalValue.length() > 2) {
                    String key = conditionalValue.substring(0, indexLT).trim();
                    if (!assertKey.equals(key)) {
                        return ConditionalValueParser.ConditionState.INVALID;
                    }
                    if (conditionalValue.charAt(indexLT + 1) == '=') {
                        ++indexLT;
                    }
                    double value = ConditionalParser.parseNumber(conditionalValue.substring(indexLT + 1));
                    if (obj.doubleValue() < value) {
                        return ConditionalValueParser.ConditionState.TRUE;
                    }
                    return ConditionalValueParser.ConditionState.FALSE;
                }
                int indexGT = conditionalValue.indexOf(">");
                if (indexGT > 0 && conditionalValue.length() > 2) {
                    String key = conditionalValue.substring(0, indexGT).trim();
                    if (!assertKey.equals(key)) {
                        return ConditionalValueParser.ConditionState.INVALID;
                    }
                    if (conditionalValue.charAt(indexGT + 1) == '=') {
                        ++indexGT;
                    }
                    double value = ConditionalParser.parseNumber(conditionalValue.substring(indexGT + 1));
                    if (obj.doubleValue() > value) {
                        return ConditionalValueParser.ConditionState.TRUE;
                    }
                    return ConditionalValueParser.ConditionState.FALSE;
                }
                return ConditionalValueParser.ConditionState.INVALID;
            }
        };
    }

    public ConditionalParser addConditionalValueParser(ConditionalValueParser vp) {
        this.valueParsers.add(0, vp);
        return this;
    }

    public ConditionalParser setConditionalValueParser(ConditionalValueParser vp) {
        this.valueParsers.clear();
        this.valueParsers.add(vp);
        return this;
    }

    public boolean checkCondition(String conditionalTag) throws ParseException {
        if (conditionalTag == null || conditionalTag.isEmpty() || !conditionalTag.contains("@")) {
            return false;
        }
        if (conditionalTag.contains(";")) {
            if (this.enabledLogs) {
                this.logger.warn("We do not support multiple conditions yet: " + conditionalTag);
            }
            return false;
        }
        String[] conditionalArr = conditionalTag.split("@");
        if (conditionalArr.length != 2) {
            throw new IllegalStateException("could not split this condition: " + conditionalTag);
        }
        String restrictiveValue = conditionalArr[0].trim();
        if (!this.restrictedTags.contains(restrictiveValue)) {
            return false;
        }
        String conditionalValue = conditionalArr[1];
        conditionalValue = conditionalValue.replace('(', ' ');
        conditionalValue = conditionalValue.replace(')', ' ');
        conditionalValue = conditionalValue.trim();
        for (ConditionalValueParser valueParser : this.valueParsers) {
            ConditionalValueParser.ConditionState c = valueParser.checkCondition(conditionalValue);
            if (!c.isValid()) continue;
            return c.isCheckPassed();
        }
        return false;
    }

    protected static double parseNumber(String str) {
        int untilIndex = str.length() - 1;
        while (untilIndex >= 0) {
            if (Character.isDigit(str.charAt(untilIndex))) break;
            --untilIndex;
        }
        return Double.parseDouble(str.substring(0, untilIndex + 1));
    }
}

