/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;

public class GraphElevationSmoothing {
    private static final int MAX_SEARCH_DISTANCE = 150;

    public static PointList smoothElevation(PointList geometry) {
        int i = 1;
        while (i < geometry.size() - 1) {
            int start = i;
            int j = i - 1;
            while (j >= 0) {
                if (!(150.0 > Helper.DIST_PLANE.calcDist(geometry.getLat(i), geometry.getLon(i), geometry.getLat(j), geometry.getLon(j)))) break;
                start = j--;
            }
            int end = i;
            int j2 = i + 1;
            while (j2 < geometry.size()) {
                if (!(150.0 > Helper.DIST_PLANE.calcDist(geometry.getLat(i), geometry.getLon(i), geometry.getLat(j2), geometry.getLon(j2)))) break;
                end = j2 + 1;
                ++j2;
            }
            if (start != end) {
                double sum = 0.0;
                int j3 = start;
                while (j3 < end) {
                    if (150.0 > Helper.DIST_PLANE.calcDist(geometry.getLat(i), geometry.getLon(i), geometry.getLat(j3), geometry.getLon(j3))) {
                        sum += geometry.getEle(j3);
                    }
                    ++j3;
                }
                double smoothed = sum / (double)(end - start);
                geometry.setElevation(i, smoothed);
            }
            ++i;
        }
        return geometry;
    }
}

