/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.AbstractElevationProvider;
import com.graphhopper.reader.dem.HeightTile;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.util.Downloader;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTiffElevationProvider
extends AbstractElevationProvider {
    private final Map<String, HeightTile> cacheData = new HashMap<String, HeightTile>();
    final double precision = 1.0E7;
    private final int WIDTH;
    private final int HEIGHT;
    final int LAT_DEGREE;
    final int LON_DEGREE;

    public AbstractTiffElevationProvider(String baseUrl, String cacheDir, String downloaderName, int width, int height, int latDegree, int lonDegree) {
        super(cacheDir);
        this.baseUrl = baseUrl;
        this.downloader = new Downloader(downloaderName).setTimeout(10000);
        this.WIDTH = width;
        this.HEIGHT = height;
        this.LAT_DEGREE = latDegree;
        this.LON_DEGREE = lonDegree;
    }

    @Override
    public void release() {
        this.cacheData.clear();
        if (this.autoRemoveTemporary && this.dir != null) {
            this.dir.clear();
        }
    }

    abstract boolean isOutsideSupportedArea(double var1, double var3);

    abstract int getMinLatForTile(double var1);

    abstract int getMinLonForTile(double var1);

    abstract String getFileNameOfLocalFile(double var1, double var3);

    @Override
    public double getEle(double lat, double lon) {
        if (this.isOutsideSupportedArea(lat, lon)) {
            return 0.0;
        }
        String name = this.getFileName(lat = (double)((int)(lat * 1.0E7)) / 1.0E7, lon = (double)((int)(lon * 1.0E7)) / 1.0E7);
        HeightTile demProvider = this.cacheData.get(name);
        if (demProvider == null) {
            if (!this.cacheDir.exists()) {
                this.cacheDir.mkdirs();
            }
            int minLat = this.getMinLatForTile(lat);
            int minLon = this.getMinLonForTile(lon);
            demProvider = new HeightTile(minLat, minLon, this.WIDTH, this.HEIGHT, (double)this.LON_DEGREE * 1.0E7, this.LON_DEGREE, this.LAT_DEGREE);
            demProvider.setCalcMean(this.calcMean);
            this.cacheData.put(name, demProvider);
            DataAccess heights = this.getDirectory().find(String.valueOf(name) + ".gh");
            demProvider.setHeights(heights);
            boolean loadExisting = false;
            try {
                loadExisting = heights.loadExisting();
            }
            catch (Exception ex) {
                this.logger.warn("cannot load " + name + ", error: " + ex.getMessage());
            }
            if (!loadExisting) {
                String zippedURL = this.getDownloadURL(lat, lon);
                File file = new File(this.cacheDir, new File(this.getFileNameOfLocalFile(lat, lon)).getName());
                try {
                    this.downloadFile(file, zippedURL);
                }
                catch (IOException e) {
                    demProvider.setSeaLevel(true);
                    heights.setSegmentSize(100).create(10L).flush();
                    return 0.0;
                }
                heights.create(2 * this.WIDTH * this.HEIGHT);
                Raster raster = this.generateRasterFromFile(file, String.valueOf(name) + ".tif");
                this.fillDataAccessWithElevationData(raster, heights, this.WIDTH);
            }
        }
        if (demProvider.isSeaLevel()) {
            return 0.0;
        }
        return demProvider.getHeight(lat, lon);
    }

    abstract Raster generateRasterFromFile(File var1, String var2);

    private void downloadFile(File downloadFile, String url) throws IOException {
        if (!downloadFile.exists()) {
            int max = 3;
            int trial = 0;
            while (trial < max) {
                try {
                    this.downloader.downloadFile(url, downloadFile.getAbsolutePath());
                    return;
                }
                catch (SocketTimeoutException ex) {
                    if (trial >= max - 1) {
                        throw new RuntimeException(ex);
                    }
                    try {
                        Thread.sleep(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++trial;
                }
            }
        }
    }

    private void fillDataAccessWithElevationData(Raster raster, DataAccess heights, int dataAccessWidth) {
        int height = raster.getHeight();
        int width = raster.getWidth();
        int x = 0;
        int y = 0;
        try {
            y = 0;
            while (y < height) {
                x = 0;
                while (x < width) {
                    short val = (short)raster.getPixel(x, y, (int[])null)[0];
                    if (val < -1000 || val > 12000) {
                        val = Short.MIN_VALUE;
                    }
                    heights.setShort(2 * (y * dataAccessWidth + x), val);
                    ++x;
                }
                ++y;
            }
            heights.flush();
        }
        catch (Exception ex) {
            throw new RuntimeException("Problem at x:" + x + ", y:" + y, ex);
        }
    }

    @Override
    public void setAutoRemoveTemporaryFiles(boolean autoRemoveTemporary) {
        this.autoRemoveTemporary = autoRemoveTemporary;
    }
}

