/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.apache.commons.collections;

import com.graphhopper.coll.BinHeapWrapper;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class IntDoubleBinaryHeap
implements BinHeapWrapper<Number, Integer> {
    private static final int GROW_FACTOR = 2;
    private int size;
    private int[] elements;
    private float[] keys;

    public IntDoubleBinaryHeap() {
        this(1000);
    }

    public IntDoubleBinaryHeap(int initialCapacity) {
        this.elements = new int[initialCapacity + 1];
        this.keys = new float[initialCapacity + 1];
        this.keys[0] = Float.NEGATIVE_INFINITY;
    }

    private boolean isFull() {
        return this.elements.length == this.size + 1;
    }

    @Override
    public void update(Number key, Integer element) {
        this.update_(key.doubleValue(), element);
    }

    public void update_(double key, int element) {
        int i = 1;
        while (i <= this.size) {
            if (this.elements[i] == element) break;
            ++i;
        }
        if (i > this.size) {
            return;
        }
        if (key > (double)this.keys[i]) {
            this.keys[i] = (float)key;
            this.percolateDownMinHeap(i);
        } else {
            this.keys[i] = (float)key;
            this.percolateUpMinHeap(i);
        }
    }

    @Override
    public void insert(Number key, Integer element) {
        this.insert_(key.doubleValue(), element);
    }

    public void insert_(double key, int element) {
        if (this.isFull()) {
            this.ensureCapacity(this.elements.length * 2);
        }
        ++this.size;
        this.elements[this.size] = element;
        this.keys[this.size] = (float)key;
        this.percolateUpMinHeap(this.size);
    }

    @Override
    public Integer peekElement() {
        return this.peek_element();
    }

    public int peek_element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Heap is empty. Cannot peek element.");
        }
        return this.elements[1];
    }

    @Override
    public Number peekKey() {
        return Float.valueOf(this.peek_key());
    }

    public float peek_key() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Heap is empty. Cannot peek key.");
        }
        return this.keys[1];
    }

    @Override
    public Integer pollElement() {
        return this.poll_element();
    }

    public int poll_element() {
        int result = this.peek_element();
        this.elements[1] = this.elements[this.size];
        this.keys[1] = this.keys[this.size];
        --this.size;
        if (this.size != 0) {
            this.percolateDownMinHeap(1);
        }
        return result;
    }

    final void percolateDownMinHeap(int index) {
        int element = this.elements[index];
        float key = this.keys[index];
        int hole = index;
        while (hole * 2 <= this.size) {
            int child = hole * 2;
            if (child != this.size && this.keys[child + 1] < this.keys[child]) {
                ++child;
            }
            if (this.keys[child] >= key) break;
            this.elements[hole] = this.elements[child];
            this.keys[hole] = this.keys[child];
            hole = child;
        }
        this.elements[hole] = element;
        this.keys[hole] = key;
    }

    final void percolateUpMinHeap(int index) {
        int hole = index;
        int element = this.elements[hole];
        float key = this.keys[hole];
        while (key < this.keys[hole / 2]) {
            int next = hole / 2;
            this.elements[hole] = this.elements[next];
            this.keys[hole] = this.keys[next];
            hole = next;
        }
        this.elements[hole] = element;
        this.keys[hole] = key;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void clear() {
        this.trimTo(0);
    }

    void trimTo(int toSize) {
        this.size = toSize++;
        Arrays.fill(this.elements, toSize, this.size + 1, 0);
    }

    @Override
    public void ensureCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalStateException("IntDoubleBinaryHeap contains too many elements to fit in new capacity.");
        }
        this.elements = Arrays.copyOf(this.elements, capacity + 1);
        this.keys = Arrays.copyOf(this.keys, capacity + 1);
    }

    public long getCapacity() {
        return this.elements.length;
    }
}

