/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperAPI;
import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.reader.DataReader;
import com.graphhopper.reader.dem.BridgeElevationInterpolator;
import com.graphhopper.reader.dem.CGIARProvider;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.dem.GMTEDProvider;
import com.graphhopper.reader.dem.MultiSourceElevationProvider;
import com.graphhopper.reader.dem.SRTMGL1Provider;
import com.graphhopper.reader.dem.SRTMProvider;
import com.graphhopper.reader.dem.TunnelElevationInterpolator;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactoryDecorator;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.ch.CHAlgoFactoryDecorator;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.lm.LMAlgoFactoryDecorator;
import com.graphhopper.routing.subnetwork.PrepareRoutingSubnetworks;
import com.graphhopper.routing.template.AbstractRoutingTemplate;
import com.graphhopper.routing.template.AlternativeRoutingTemplate;
import com.graphhopper.routing.template.RoundTripRoutingTemplate;
import com.graphhopper.routing.template.ViaRoutingTemplate;
import com.graphhopper.routing.util.DataFlagEncoder;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.FlagEncoderFactory;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.BlockAreaWeighting;
import com.graphhopper.routing.weighting.CurvatureWeighting;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.routing.weighting.GenericWeighting;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.routing.weighting.ShortFastestWeighting;
import com.graphhopper.routing.weighting.ShortestWeighting;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.GHLock;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphEdgeIdFinder;
import com.graphhopper.storage.GraphExtension;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.LockFactory;
import com.graphhopper.storage.NativeFSLockFactory;
import com.graphhopper.storage.SimpleFSLockFactory;
import com.graphhopper.storage.TurnCostExtension;
import com.graphhopper.storage.change.ChangeGraphHelper;
import com.graphhopper.storage.change.ChangeGraphResponse;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.CmdArgs;
import com.graphhopper.util.Constants;
import com.graphhopper.util.DistanceCalc3D;
import com.graphhopper.util.DouglasPeucker;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.Unzipper;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.exceptions.PointDistanceExceededException;
import com.graphhopper.util.exceptions.PointOutOfBoundsException;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopper
implements GraphHopperAPI {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String fileLockName = "gh.lock";
    private final Set<RoutingAlgorithmFactoryDecorator> algoDecorators = new LinkedHashSet<RoutingAlgorithmFactoryDecorator>();
    private final TranslationMap trMap = new TranslationMap().doImport();
    boolean removeZipped = true;
    boolean enableInstructions = true;
    private GraphHopperStorage ghStorage;
    private EncodingManager encodingManager;
    private int defaultSegmentSize = -1;
    private String ghLocation = "";
    private DAType dataAccessType = DAType.RAM_STORE;
    private boolean sortGraph = false;
    private boolean elevation = false;
    private LockFactory lockFactory = new NativeFSLockFactory();
    private boolean allowWrites = true;
    private String preferredLanguage = "";
    private boolean fullyLoaded = false;
    private boolean smoothElevation = false;
    private int maxRoundTripRetries = 3;
    private boolean simplifyResponse = true;
    private TraversalMode traversalMode = TraversalMode.NODE_BASED;
    private int maxVisitedNodes = Integer.MAX_VALUE;
    private int nonChMaxWaypointDistance = Integer.MAX_VALUE;
    private LocationIndex locationIndex;
    private int preciseIndexResolution = 300;
    private int maxRegionSearch = 4;
    private int minNetworkSize = 200;
    private int minOneWayNetworkSize = 0;
    private final LMAlgoFactoryDecorator lmFactoryDecorator = new LMAlgoFactoryDecorator();
    private final CHAlgoFactoryDecorator chFactoryDecorator = new CHAlgoFactoryDecorator();
    private String dataReaderFile;
    private double dataReaderWayPointMaxDistance = 1.0;
    private int dataReaderWorkerThreads = 2;
    private boolean calcPoints = true;
    private ElevationProvider eleProvider = ElevationProvider.NOOP;
    private FlagEncoderFactory flagEncoderFactory = FlagEncoderFactory.DEFAULT;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private PathDetailsBuilderFactory pathBuilderFactory = new PathDetailsBuilderFactory();

    public GraphHopper() {
        this.chFactoryDecorator.setEnabled(true);
        this.lmFactoryDecorator.setEnabled(false);
        this.algoDecorators.add(this.chFactoryDecorator);
        this.algoDecorators.add(this.lmFactoryDecorator);
    }

    protected GraphHopper loadGraph(GraphHopperStorage g) {
        this.ghStorage = g;
        this.fullyLoaded = true;
        this.initLocationIndex();
        return this;
    }

    FlagEncoder getDefaultVehicle() {
        if (this.encodingManager == null) {
            throw new IllegalStateException("No encoding manager specified or loaded");
        }
        return this.encodingManager.fetchEdgeEncoders().get(0);
    }

    public EncodingManager getEncodingManager() {
        return this.encodingManager;
    }

    public GraphHopper setEncodingManager(EncodingManager em) {
        this.ensureNotLoaded();
        this.encodingManager = em;
        if (em.needsTurnCostsSupport()) {
            this.traversalMode = TraversalMode.EDGE_BASED_2DIR;
        }
        return this;
    }

    public ElevationProvider getElevationProvider() {
        return this.eleProvider;
    }

    public GraphHopper setElevationProvider(ElevationProvider eleProvider) {
        if (eleProvider == null || eleProvider == ElevationProvider.NOOP) {
            this.setElevation(false);
        } else {
            this.setElevation(true);
        }
        this.eleProvider = eleProvider;
        return this;
    }

    protected int getWorkerThreads() {
        return this.dataReaderWorkerThreads;
    }

    protected double getWayPointMaxDistance() {
        return this.dataReaderWayPointMaxDistance;
    }

    public GraphHopper setWayPointMaxDistance(double wayPointMaxDistance) {
        this.dataReaderWayPointMaxDistance = wayPointMaxDistance;
        return this;
    }

    public TraversalMode getTraversalMode() {
        return this.traversalMode;
    }

    public GraphHopper setTraversalMode(TraversalMode traversalMode) {
        this.traversalMode = traversalMode;
        return this;
    }

    public GraphHopper setPathDetailsBuilderFactory(PathDetailsBuilderFactory pathBuilderFactory) {
        this.pathBuilderFactory = pathBuilderFactory;
        return this;
    }

    public PathDetailsBuilderFactory getPathDetailsBuilderFactory() {
        return this.pathBuilderFactory;
    }

    public GraphHopper forServer() {
        this.setSimplifyResponse(true);
        return this.setInMemory();
    }

    public GraphHopper forDesktop() {
        this.setSimplifyResponse(false);
        return this.setInMemory();
    }

    public GraphHopper forMobile() {
        this.setSimplifyResponse(false);
        return this.setMemoryMapped();
    }

    public GraphHopper setPreciseIndexResolution(int precision) {
        this.ensureNotLoaded();
        this.preciseIndexResolution = precision;
        return this;
    }

    public GraphHopper setMinNetworkSize(int minNetworkSize, int minOneWayNetworkSize) {
        this.minNetworkSize = minNetworkSize;
        this.minOneWayNetworkSize = minOneWayNetworkSize;
        return this;
    }

    public GraphHopper setInMemory() {
        this.ensureNotLoaded();
        this.dataAccessType = DAType.RAM_STORE;
        return this;
    }

    public GraphHopper setStoreOnFlush(boolean storeOnFlush) {
        this.ensureNotLoaded();
        this.dataAccessType = storeOnFlush ? DAType.RAM_STORE : DAType.RAM;
        return this;
    }

    public GraphHopper setMemoryMapped() {
        this.ensureNotLoaded();
        this.dataAccessType = DAType.MMAP;
        return this;
    }

    private GraphHopper setUnsafeMemory() {
        this.ensureNotLoaded();
        this.dataAccessType = DAType.UNSAFE_STORE;
        return this;
    }

    public GraphHopper setCHEnable(boolean enable) {
        return this.setCHEnabled(enable);
    }

    public final boolean isCHEnabled() {
        return this.chFactoryDecorator.isEnabled();
    }

    public GraphHopper setCHEnabled(boolean enable) {
        this.ensureNotLoaded();
        this.chFactoryDecorator.setEnabled(enable);
        return this;
    }

    public int getMaxVisitedNodes() {
        return this.maxVisitedNodes;
    }

    public void setMaxVisitedNodes(int maxVisitedNodes) {
        this.maxVisitedNodes = maxVisitedNodes;
    }

    public boolean hasElevation() {
        return this.elevation;
    }

    public GraphHopper setElevation(boolean includeElevation) {
        this.elevation = includeElevation;
        return this;
    }

    public boolean isEnableInstructions() {
        return this.enableInstructions;
    }

    public GraphHopper setEnableInstructions(boolean b) {
        this.ensureNotLoaded();
        this.enableInstructions = b;
        return this;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public GraphHopper setPreferredLanguage(String preferredLanguage) {
        this.ensureNotLoaded();
        if (preferredLanguage == null) {
            throw new IllegalArgumentException("preferred language cannot be null");
        }
        this.preferredLanguage = preferredLanguage;
        return this;
    }

    public GraphHopper setEnableCalcPoints(boolean b) {
        this.calcPoints = b;
        return this;
    }

    private GraphHopper setSimplifyResponse(boolean doSimplify) {
        this.simplifyResponse = doSimplify;
        return this;
    }

    public String getGraphHopperLocation() {
        return this.ghLocation;
    }

    public GraphHopper setGraphHopperLocation(String ghLocation) {
        this.ensureNotLoaded();
        if (ghLocation == null) {
            throw new IllegalArgumentException("graphhopper location cannot be null");
        }
        this.ghLocation = ghLocation;
        return this;
    }

    public String getDataReaderFile() {
        return this.dataReaderFile;
    }

    public GraphHopper setDataReaderFile(String dataReaderFileStr) {
        this.ensureNotLoaded();
        if (Helper.isEmpty(dataReaderFileStr)) {
            throw new IllegalArgumentException("Data reader file cannot be empty.");
        }
        this.dataReaderFile = dataReaderFileStr;
        return this;
    }

    public GraphHopperStorage getGraphHopperStorage() {
        if (this.ghStorage == null) {
            throw new IllegalStateException("GraphHopper storage not initialized");
        }
        return this.ghStorage;
    }

    public void setGraphHopperStorage(GraphHopperStorage ghStorage) {
        this.ghStorage = ghStorage;
        this.fullyLoaded = true;
    }

    public LocationIndex getLocationIndex() {
        if (this.locationIndex == null) {
            throw new IllegalStateException("Location index not initialized");
        }
        return this.locationIndex;
    }

    protected void setLocationIndex(LocationIndex locationIndex) {
        this.locationIndex = locationIndex;
    }

    public GraphHopper setSortGraph(boolean sortGraph) {
        this.ensureNotLoaded();
        this.sortGraph = sortGraph;
        return this;
    }

    public boolean isAllowWrites() {
        return this.allowWrites;
    }

    public GraphHopper setAllowWrites(boolean allowWrites) {
        this.allowWrites = allowWrites;
        return this;
    }

    public TranslationMap getTranslationMap() {
        return this.trMap;
    }

    public GraphHopper setFlagEncoderFactory(FlagEncoderFactory factory) {
        this.flagEncoderFactory = factory;
        return this;
    }

    public FlagEncoderFactory getFlagEncoderFactory() {
        return this.flagEncoderFactory;
    }

    public GraphHopper init(CmdArgs args) {
        String baseURL;
        String graphHopperFolder;
        if ((args = CmdArgs.readFromConfigAndMerge(args, "config", "graphhopper.config")).has("osmreader.osm")) {
            throw new IllegalArgumentException("Instead osmreader.osm use datareader.file, for other changes see core/files/changelog.txt");
        }
        String tmpOsmFile = args.get("datareader.file", "");
        if (!Helper.isEmpty(tmpOsmFile)) {
            this.dataReaderFile = tmpOsmFile;
        }
        if (Helper.isEmpty(graphHopperFolder = args.get("graph.location", "")) && Helper.isEmpty(this.ghLocation)) {
            if (Helper.isEmpty(this.dataReaderFile)) {
                throw new IllegalArgumentException("If no graph.location is provided you need to specify an OSM file.");
            }
            graphHopperFolder = String.valueOf(Helper.pruneFileEnd(this.dataReaderFile)) + "-gh";
        }
        this.setGraphHopperLocation(graphHopperFolder);
        this.defaultSegmentSize = args.getInt("graph.dataaccess.segment_size", this.defaultSegmentSize);
        String graphDATypeStr = args.get("graph.dataaccess", "RAM_STORE");
        this.dataAccessType = DAType.fromString(graphDATypeStr);
        this.sortGraph = args.getBool("graph.do_sort", this.sortGraph);
        this.removeZipped = args.getBool("graph.remove_zipped", this.removeZipped);
        int bytesForFlags = args.getInt("graph.bytes_for_flags", 4);
        String flagEncodersStr = args.get("graph.flag_encoders", "");
        if (!flagEncodersStr.isEmpty()) {
            this.setEncodingManager(new EncodingManager(this.flagEncoderFactory, flagEncodersStr, bytesForFlags));
        }
        this.lockFactory = args.get("graph.locktype", "native").equals("simple") ? new SimpleFSLockFactory() : new NativeFSLockFactory();
        String eleProviderStr = Helper.toLowerCase(args.get("graph.elevation.provider", "noop"));
        this.smoothElevation = args.getBool("graph.elevation.smoothing", false);
        boolean eleCalcMean = args.has("graph.elevation.calcmean") ? args.getBool("graph.elevation.calcmean", false) : args.getBool("graph.elevation.calc_mean", false);
        String cacheDirStr = args.get("graph.elevation.cache_dir", "");
        if (cacheDirStr.isEmpty()) {
            cacheDirStr = args.get("graph.elevation.cachedir", "");
        }
        if ((baseURL = args.get("graph.elevation.base_url", "")).isEmpty()) {
            args.get("graph.elevation.baseurl", "");
        }
        boolean removeTempElevationFiles = args.getBool("graph.elevation.cgiar.clear", true);
        removeTempElevationFiles = args.getBool("graph.elevation.clear", removeTempElevationFiles);
        DAType elevationDAType = DAType.fromString(args.get("graph.elevation.dataaccess", "MMAP"));
        ElevationProvider tmpProvider = ElevationProvider.NOOP;
        if (eleProviderStr.equalsIgnoreCase("srtm")) {
            tmpProvider = new SRTMProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("cgiar")) {
            tmpProvider = new CGIARProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("gmted")) {
            tmpProvider = new GMTEDProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("srtmgl1")) {
            tmpProvider = new SRTMGL1Provider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("multi")) {
            tmpProvider = new MultiSourceElevationProvider(cacheDirStr);
        }
        tmpProvider.setAutoRemoveTemporaryFiles(removeTempElevationFiles);
        tmpProvider.setCalcMean(eleCalcMean);
        if (!baseURL.isEmpty()) {
            tmpProvider.setBaseURL(baseURL);
        }
        tmpProvider.setDAType(elevationDAType);
        this.setElevationProvider(tmpProvider);
        this.minNetworkSize = args.getInt("prepare.min_network_size", this.minNetworkSize);
        this.minOneWayNetworkSize = args.getInt("prepare.min_one_way_network_size", this.minOneWayNetworkSize);
        for (RoutingAlgorithmFactoryDecorator decorator : this.algoDecorators) {
            decorator.init(args);
        }
        this.dataReaderWayPointMaxDistance = args.getDouble("routing.way_point_max_distance", this.dataReaderWayPointMaxDistance);
        this.dataReaderWorkerThreads = args.getInt("datareader.worker_threads", this.dataReaderWorkerThreads);
        this.enableInstructions = args.getBool("datareader.instructions", this.enableInstructions);
        this.preferredLanguage = args.get("datareader.preferred_language", this.preferredLanguage);
        this.preciseIndexResolution = args.getInt("index.high_resolution", this.preciseIndexResolution);
        this.maxRegionSearch = args.getInt("index.max_region_search", this.maxRegionSearch);
        this.maxVisitedNodes = args.getInt("routing.max_visited_nodes", Integer.MAX_VALUE);
        this.maxRoundTripRetries = args.getInt("routing.round_trip.max_retries", this.maxRoundTripRetries);
        this.nonChMaxWaypointDistance = args.getInt("routing.non_ch.max_waypoint_distance", Integer.MAX_VALUE);
        return this;
    }

    private void printInfo() {
        this.logger.info("version " + Constants.VERSION + "|" + Constants.BUILD_DATE + " (" + Constants.getVersions() + ")");
        if (this.ghStorage != null) {
            this.logger.info("graph " + this.ghStorage.toString() + ", details:" + this.ghStorage.toDetailsString());
        }
    }

    public GraphHopper importOrLoad() {
        if (!this.load(this.ghLocation)) {
            this.printInfo();
            this.process(this.ghLocation);
        } else {
            this.printInfo();
        }
        return this;
    }

    private GraphHopper process(String graphHopperLocation) {
        this.setGraphHopperLocation(graphHopperLocation);
        GHLock lock = null;
        try {
            if (this.ghStorage.getDirectory().getDefaultType().isStoring()) {
                this.lockFactory.setLockDir(new File(graphHopperLocation));
                lock = this.lockFactory.create("gh.lock", true);
                if (!lock.tryLock()) {
                    throw new RuntimeException("To avoid multiple writers we need to obtain a write lock but it failed. In " + graphHopperLocation, lock.getObtainFailedReason());
                }
            }
            try {
                DataReader reader = this.importData();
                DateFormat f = Helper.createFormatter();
                this.ghStorage.getProperties().put("datareader.import.date", f.format(new Date()));
                if (reader.getDataDate() != null) {
                    this.ghStorage.getProperties().put("datareader.data.date", f.format(reader.getDataDate()));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Cannot read file " + this.getDataReaderFile(), ex);
            }
            this.cleanUp();
            this.postProcessing();
            this.flush();
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
        return this;
    }

    protected DataReader importData() throws IOException {
        this.ensureWriteAccess();
        if (this.ghStorage == null) {
            throw new IllegalStateException("Load graph before importing OSM data");
        }
        if (this.dataReaderFile == null) {
            throw new IllegalStateException("Couldn't load from existing folder: " + this.ghLocation + " but also cannot use file for DataReader as it wasn't specified!");
        }
        this.encodingManager.setEnableInstructions(this.enableInstructions);
        this.encodingManager.setPreferredLanguage(this.preferredLanguage);
        DataReader reader = this.createReader(this.ghStorage);
        this.logger.info("using " + this.ghStorage.toString() + ", memory:" + Helper.getMemInfo());
        reader.readGraph();
        return reader;
    }

    protected DataReader createReader(GraphHopperStorage ghStorage) {
        throw new UnsupportedOperationException("Cannot create DataReader. Solutions: avoid import via calling load directly, provide a DataReader or use e.g. GraphHopperOSM or a different subclass");
    }

    protected DataReader initDataReader(DataReader reader) {
        if (this.dataReaderFile == null) {
            throw new IllegalArgumentException("No file for DataReader specified");
        }
        this.logger.info("start creating graph from " + this.dataReaderFile);
        return reader.setFile(new File(this.dataReaderFile)).setElevationProvider(this.eleProvider).setWorkerThreads(this.dataReaderWorkerThreads).setWayPointMaxDistance(this.dataReaderWayPointMaxDistance).setSmoothElevation(this.smoothElevation);
    }

    @Override
    public boolean load(String graphHopperFolder) {
        GraphExtension ext;
        if (Helper.isEmpty(graphHopperFolder)) {
            throw new IllegalStateException("GraphHopperLocation is not specified. Call setGraphHopperLocation or init before");
        }
        if (this.fullyLoaded) {
            throw new IllegalStateException("graph is already successfully loaded");
        }
        File tmpFileOrFolder = new File(graphHopperFolder);
        if (!tmpFileOrFolder.isDirectory() && tmpFileOrFolder.exists()) {
            throw new IllegalArgumentException("GraphHopperLocation cannot be an existing file. Has to be either non-existing or a folder.");
        }
        File compressed = new File(String.valueOf(graphHopperFolder) + ".ghz");
        if (compressed.exists() && !compressed.isDirectory()) {
            try {
                new Unzipper().unzip(compressed.getAbsolutePath(), graphHopperFolder, this.removeZipped);
            }
            catch (IOException ex) {
                throw new RuntimeException("Couldn't extract file " + compressed.getAbsolutePath() + " to " + graphHopperFolder, ex);
            }
        }
        this.setGraphHopperLocation(graphHopperFolder);
        if (this.encodingManager == null) {
            this.setEncodingManager(EncodingManager.create(this.flagEncoderFactory, this.ghLocation));
        }
        if (!this.allowWrites && this.dataAccessType.isMMap()) {
            this.dataAccessType = DAType.MMAP_RO;
        }
        GHDirectory dir = new GHDirectory(this.ghLocation, this.dataAccessType);
        GraphExtension graphExtension = ext = this.encodingManager.needsTurnCostsSupport() ? new TurnCostExtension() : new GraphExtension.NoOpExtension();
        if (this.lmFactoryDecorator.isEnabled()) {
            this.initLMAlgoFactoryDecorator();
        }
        if (this.chFactoryDecorator.isEnabled()) {
            this.initCHAlgoFactoryDecorator();
            this.ghStorage = new GraphHopperStorage(this.chFactoryDecorator.getWeightings(), dir, this.encodingManager, this.hasElevation(), ext);
        } else {
            this.ghStorage = new GraphHopperStorage(dir, this.encodingManager, this.hasElevation(), ext);
        }
        this.ghStorage.setSegmentSize(this.defaultSegmentSize);
        if (!new File(graphHopperFolder).exists()) {
            return false;
        }
        GHLock lock = null;
        try {
            if (this.ghStorage.getDirectory().getDefaultType().isStoring() && this.isAllowWrites()) {
                this.lockFactory.setLockDir(new File(this.ghLocation));
                lock = this.lockFactory.create("gh.lock", false);
                if (!lock.tryLock()) {
                    throw new RuntimeException("To avoid reading partial data we need to obtain the read lock but it failed. In " + this.ghLocation, lock.getObtainFailedReason());
                }
            }
            if (!this.ghStorage.loadExisting()) {
                return false;
            }
            this.postProcessing();
            this.fullyLoaded = true;
            return true;
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    public RoutingAlgorithmFactory getAlgorithmFactory(HintsMap map) {
        RoutingAlgorithmFactory routingAlgorithmFactory = new RoutingAlgorithmFactorySimple();
        for (RoutingAlgorithmFactoryDecorator decorator : this.algoDecorators) {
            if (!decorator.isEnabled()) continue;
            routingAlgorithmFactory = decorator.getDecoratedAlgorithmFactory(routingAlgorithmFactory, map);
        }
        return routingAlgorithmFactory;
    }

    public GraphHopper addAlgorithmFactoryDecorator(RoutingAlgorithmFactoryDecorator algoFactoryDecorator) {
        if (!this.algoDecorators.add(algoFactoryDecorator)) {
            throw new IllegalArgumentException("Decorator was already added " + algoFactoryDecorator.getClass());
        }
        return this;
    }

    public final CHAlgoFactoryDecorator getCHFactoryDecorator() {
        return this.chFactoryDecorator;
    }

    private void initCHAlgoFactoryDecorator() {
        if (!this.chFactoryDecorator.hasWeightings()) {
            for (FlagEncoder encoder : this.encodingManager.fetchEdgeEncoders()) {
                for (String chWeightingStr : this.chFactoryDecorator.getWeightingsAsStrings()) {
                    Weighting weighting = this.createWeighting(new HintsMap(chWeightingStr), encoder, null);
                    this.chFactoryDecorator.addWeighting(weighting);
                }
            }
        }
    }

    public final LMAlgoFactoryDecorator getLMFactoryDecorator() {
        return this.lmFactoryDecorator;
    }

    private void initLMAlgoFactoryDecorator() {
        if (this.lmFactoryDecorator.hasWeightings()) {
            return;
        }
        for (FlagEncoder encoder : this.encodingManager.fetchEdgeEncoders()) {
            for (String lmWeightingStr : this.lmFactoryDecorator.getWeightingsAsStrings()) {
                Weighting weighting = this.createWeighting(new HintsMap(lmWeightingStr), encoder, null);
                this.lmFactoryDecorator.addWeighting(weighting);
            }
        }
    }

    public void postProcessing() {
        if (this.sortGraph) {
            if (this.ghStorage.isCHPossible() && this.isCHPrepared()) {
                throw new IllegalArgumentException("Sorting a prepared CHGraph is not possible yet. See #12");
            }
            GraphHopperStorage newGraph = GHUtility.newStorage(this.ghStorage);
            GHUtility.sortDFS(this.ghStorage, newGraph);
            this.logger.info("graph sorted (" + Helper.getMemInfo() + ")");
            this.ghStorage = newGraph;
        }
        if (this.hasElevation()) {
            this.interpolateBridgesAndOrTunnels();
        }
        this.initLocationIndex();
        if (this.chFactoryDecorator.isEnabled()) {
            this.chFactoryDecorator.createPreparations(this.ghStorage, this.traversalMode);
        }
        if (!this.isCHPrepared()) {
            this.prepareCH();
        }
        if (this.lmFactoryDecorator.isEnabled()) {
            this.lmFactoryDecorator.createPreparations(this.ghStorage, this.locationIndex);
        }
        this.loadOrPrepareLM();
    }

    private void interpolateBridgesAndOrTunnels() {
        if (this.ghStorage.getEncodingManager().supports("generic")) {
            FlagEncoder genericFlagEncoder = this.ghStorage.getEncodingManager().getEncoder("generic");
            if (!(genericFlagEncoder instanceof DataFlagEncoder)) {
                throw new IllegalStateException("'generic' flag encoder for elevation interpolation of bridges and tunnels is enabled but does not have the expected type " + DataFlagEncoder.class.getName() + ".");
            }
            DataFlagEncoder dataFlagEncoder = (DataFlagEncoder)genericFlagEncoder;
            StopWatch sw = new StopWatch().start();
            new TunnelElevationInterpolator(this.ghStorage, dataFlagEncoder).execute();
            float tunnel = sw.stop().getSeconds();
            sw = new StopWatch().start();
            new BridgeElevationInterpolator(this.ghStorage, dataFlagEncoder).execute();
            this.logger.info("Bridge interpolation " + (int)sw.stop().getSeconds() + "s, " + "tunnel interpolation " + (int)tunnel + "s");
        }
    }

    public Weighting createWeighting(HintsMap hintsMap, FlagEncoder encoder, Graph graph) {
        String weightingStr = Helper.toLowerCase(hintsMap.getWeighting());
        AbstractWeighting weighting = null;
        if (encoder.supports(GenericWeighting.class)) {
            weighting = new GenericWeighting((DataFlagEncoder)encoder, hintsMap);
        } else if ("shortest".equalsIgnoreCase(weightingStr)) {
            weighting = new ShortestWeighting(encoder);
        } else if ("fastest".equalsIgnoreCase(weightingStr) || weightingStr.isEmpty()) {
            weighting = encoder.supports(PriorityWeighting.class) ? new PriorityWeighting(encoder, hintsMap) : new FastestWeighting(encoder, hintsMap);
        } else if ("curvature".equalsIgnoreCase(weightingStr)) {
            if (encoder.supports(CurvatureWeighting.class)) {
                weighting = new CurvatureWeighting(encoder, hintsMap);
            }
        } else if ("short_fastest".equalsIgnoreCase(weightingStr)) {
            weighting = new ShortFastestWeighting(encoder, hintsMap);
        }
        if (weighting == null) {
            throw new IllegalArgumentException("weighting " + weightingStr + " not supported");
        }
        if (hintsMap.has("block_area")) {
            String blockAreaStr = hintsMap.get("block_area", "");
            GraphEdgeIdFinder.BlockArea blockArea = new GraphEdgeIdFinder(graph, this.locationIndex).parseBlockArea(blockAreaStr, new DefaultEdgeFilter(encoder), hintsMap.getDouble("block_area.edge_id_max_area", 1000000.0));
            return new BlockAreaWeighting(weighting, blockArea);
        }
        return weighting;
    }

    public Weighting createTurnWeighting(Graph graph, Weighting weighting, TraversalMode tMode) {
        FlagEncoder encoder = weighting.getFlagEncoder();
        if (encoder.supports(TurnWeighting.class) && !tMode.equals((Object)TraversalMode.NODE_BASED)) {
            return new TurnWeighting(weighting, (TurnCostExtension)graph.getExtension());
        }
        return weighting;
    }

    @Override
    public GHResponse route(GHRequest request) {
        GHResponse response = new GHResponse();
        this.calcPaths(request, response);
        return response;
    }

    public List<Path> calcPaths(GHRequest request, GHResponse ghRsp) {
        if (this.ghStorage == null || !this.fullyLoaded) {
            throw new IllegalStateException("Do a successful call to load or importOrLoad before routing");
        }
        if (this.ghStorage.isClosed()) {
            throw new IllegalStateException("You need to create a new GraphHopper instance as it is already closed");
        }
        String vehicle = request.getVehicle();
        if (vehicle.isEmpty()) {
            vehicle = this.getDefaultVehicle().toString();
            request.setVehicle(vehicle);
        }
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            if (!this.encodingManager.supports(vehicle)) {
                throw new IllegalArgumentException("Vehicle " + vehicle + " unsupported. " + "Supported are: " + this.getEncodingManager());
            }
            HintsMap hints = request.getHints();
            String tModeStr = hints.get("traversal_mode", this.traversalMode.toString());
            TraversalMode tMode = TraversalMode.fromString(tModeStr);
            if (hints.has("edge_based")) {
                tMode = hints.getBool("edge_based", false) ? TraversalMode.EDGE_BASED_2DIR : TraversalMode.NODE_BASED;
            }
            FlagEncoder encoder = this.encodingManager.getEncoder(vehicle);
            boolean disableCH = hints.getBool("ch.disable", false);
            if (!this.chFactoryDecorator.isDisablingAllowed() && disableCH) {
                throw new IllegalArgumentException("Disabling CH not allowed on the server-side");
            }
            boolean disableLM = hints.getBool("lm.disable", false);
            if (!this.lmFactoryDecorator.isDisablingAllowed() && disableLM) {
                throw new IllegalArgumentException("Disabling LM not allowed on the server-side");
            }
            String algoStr = request.getAlgorithm();
            if (algoStr.isEmpty()) {
                algoStr = this.chFactoryDecorator.isEnabled() && !disableCH ? "dijkstrabi" : "astarbi";
            }
            List<GHPoint> points = request.getPoints();
            this.checkIfPointsAreInBounds(points);
            AbstractRoutingTemplate routingTemplate = "round_trip".equalsIgnoreCase(algoStr) ? new RoundTripRoutingTemplate(request, ghRsp, this.locationIndex, this.maxRoundTripRetries) : ("alternative_route".equalsIgnoreCase(algoStr) ? new AlternativeRoutingTemplate(request, ghRsp, this.locationIndex) : new ViaRoutingTemplate(request, ghRsp, this.locationIndex));
            List<Path> altPaths = null;
            int maxRetries = routingTemplate.getMaxRetries();
            Locale locale = request.getLocale();
            Translation tr = this.trMap.getWithFallBack(locale);
            int i = 0;
            while (i < maxRetries) {
                QueryGraph queryGraph;
                Weighting weighting;
                StopWatch sw = new StopWatch().start();
                List<QueryResult> qResults = routingTemplate.lookup(points, encoder);
                ghRsp.addDebugInfo("idLookup:" + sw.stop().getSeconds() + "s");
                if (ghRsp.hasErrors()) {
                    List<Path> list = Collections.emptyList();
                    return list;
                }
                RoutingAlgorithmFactory tmpAlgoFactory = this.getAlgorithmFactory(hints);
                if (this.chFactoryDecorator.isEnabled() && !disableCH) {
                    boolean forceCHHeading = hints.getBool("ch.force_heading", false);
                    if (!forceCHHeading && request.hasFavoredHeading(0)) {
                        throw new IllegalArgumentException("Heading is not (fully) supported for CHGraph. See issue #483");
                    }
                    RoutingAlgorithmFactory chAlgoFactory = tmpAlgoFactory;
                    if (tmpAlgoFactory instanceof LMAlgoFactoryDecorator.LMRAFactory) {
                        chAlgoFactory = ((LMAlgoFactoryDecorator.LMRAFactory)tmpAlgoFactory).getDefaultAlgoFactory();
                    }
                    if (!(chAlgoFactory instanceof PrepareContractionHierarchies)) {
                        throw new IllegalStateException("Although CH was enabled a non-CH algorithm factory was returned " + tmpAlgoFactory);
                    }
                    weighting = ((PrepareContractionHierarchies)chAlgoFactory).getWeighting();
                    tMode = this.getCHFactoryDecorator().getNodeBase();
                    queryGraph = new QueryGraph(this.ghStorage.getGraph(CHGraph.class, weighting));
                    queryGraph.lookup(qResults);
                } else {
                    this.checkNonChMaxWaypointDistance(points);
                    queryGraph = new QueryGraph(this.ghStorage);
                    queryGraph.lookup(qResults);
                    weighting = this.createWeighting(hints, encoder, queryGraph);
                    ghRsp.addDebugInfo("tmode:" + tMode.toString());
                }
                int maxVisitedNodesForRequest = hints.getInt("max_visited_nodes", this.maxVisitedNodes);
                if (maxVisitedNodesForRequest > this.maxVisitedNodes) {
                    throw new IllegalArgumentException("The max_visited_nodes parameter has to be below or equal to:" + this.maxVisitedNodes);
                }
                weighting = this.createTurnWeighting(queryGraph, weighting, tMode);
                AlgorithmOptions algoOpts = AlgorithmOptions.start().algorithm(algoStr).traversalMode(tMode).weighting(weighting).maxVisitedNodes(maxVisitedNodesForRequest).hints(hints).build();
                altPaths = routingTemplate.calcPaths(queryGraph, tmpAlgoFactory, algoOpts);
                boolean tmpEnableInstructions = hints.getBool("instructions", this.enableInstructions);
                boolean tmpCalcPoints = hints.getBool("calc_points", this.calcPoints);
                double wayPointMaxDistance = hints.getDouble("way_point_max_distance", 1.0);
                DouglasPeucker peucker = new DouglasPeucker().setMaxDistance(wayPointMaxDistance);
                PathMerger pathMerger = new PathMerger().setCalcPoints(tmpCalcPoints).setDouglasPeucker(peucker).setEnableInstructions(tmpEnableInstructions).setPathDetailsBuilders(this.pathBuilderFactory, request.getPathDetails()).setSimplifyResponse(this.simplifyResponse && wayPointMaxDistance > 0.0);
                if (request.hasFavoredHeading(0)) {
                    pathMerger.setFavoredHeading(request.getFavoredHeading(0));
                }
                if (routingTemplate.isReady(pathMerger, tr)) break;
                ++i;
            }
            List<Path> list = altPaths;
            return list;
        }
        catch (IllegalArgumentException ex) {
            ghRsp.addError(ex);
            List<Path> list = Collections.emptyList();
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    public ChangeGraphResponse changeGraph(Collection<JsonFeature> collection) {
        if (this.getCHFactoryDecorator().isEnabled()) {
            throw new IllegalArgumentException("To use the changeGraph API you need to turn off CH");
        }
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            ChangeGraphHelper overlay = this.createChangeGraphHelper(this.ghStorage, this.locationIndex);
            long updateCount = overlay.applyChanges(this.encodingManager, collection);
            ChangeGraphResponse changeGraphResponse = new ChangeGraphResponse(updateCount);
            return changeGraphResponse;
        }
        finally {
            writeLock.unlock();
        }
    }

    protected ChangeGraphHelper createChangeGraphHelper(Graph graph, LocationIndex locationIndex) {
        return new ChangeGraphHelper(graph, locationIndex);
    }

    private void checkIfPointsAreInBounds(List<GHPoint> points) {
        BBox bounds = this.getGraphHopperStorage().getBounds();
        int i = 0;
        while (i < points.size()) {
            GHPoint point = points.get(i);
            if (!bounds.contains(point.getLat(), point.getLon())) {
                throw new PointOutOfBoundsException("Point " + i + " is out of bounds: " + point, i);
            }
            ++i;
        }
    }

    private void checkNonChMaxWaypointDistance(List<GHPoint> points) {
        if (this.nonChMaxWaypointDistance == Integer.MAX_VALUE) {
            return;
        }
        GHPoint lastPoint = points.get(0);
        DistanceCalc3D calc = Helper.DIST_3D;
        int i = 1;
        while (i < points.size()) {
            GHPoint point = points.get(i);
            double dist = calc.calcDist(lastPoint.getLat(), lastPoint.getLon(), point.getLat(), point.getLon());
            if (dist > (double)this.nonChMaxWaypointDistance) {
                HashMap<String, Object> detailMap = new HashMap<String, Object>(2);
                detailMap.put("from", i - 1);
                detailMap.put("to", i);
                throw new PointDistanceExceededException("Point " + i + " is too far from Point " + (i - 1) + ": " + point, detailMap);
            }
            lastPoint = point;
            ++i;
        }
    }

    protected LocationIndex createLocationIndex(Directory dir) {
        LocationIndexTree tmpIndex = new LocationIndexTree(this.ghStorage, dir);
        tmpIndex.setResolution(this.preciseIndexResolution);
        tmpIndex.setMaxRegionSearch(this.maxRegionSearch);
        if (!tmpIndex.loadExisting()) {
            this.ensureWriteAccess();
            tmpIndex.prepareIndex();
        }
        return tmpIndex;
    }

    protected void initLocationIndex() {
        if (this.locationIndex != null) {
            throw new IllegalStateException("Cannot initialize locationIndex twice!");
        }
        this.locationIndex = this.createLocationIndex(this.ghStorage.getDirectory());
    }

    private boolean isCHPrepared() {
        return "true".equals(this.ghStorage.getProperties().get("prepare.ch.done")) || "true".equals(this.ghStorage.getProperties().get("prepare.done"));
    }

    private boolean isLMPrepared() {
        return "true".equals(this.ghStorage.getProperties().get("prepare.lm.done"));
    }

    protected void prepareCH() {
        boolean tmpPrepare = this.chFactoryDecorator.isEnabled();
        if (tmpPrepare) {
            this.ensureWriteAccess();
            this.ghStorage.freeze();
            this.chFactoryDecorator.prepare(this.ghStorage.getProperties());
            this.ghStorage.getProperties().put("prepare.ch.done", true);
        }
    }

    protected void loadOrPrepareLM() {
        boolean tmpPrepare;
        boolean bl = tmpPrepare = this.lmFactoryDecorator.isEnabled() && !this.lmFactoryDecorator.getPreparations().isEmpty();
        if (tmpPrepare) {
            this.ensureWriteAccess();
            this.ghStorage.freeze();
            if (this.lmFactoryDecorator.loadOrDoWork(this.ghStorage.getProperties())) {
                this.ghStorage.getProperties().put("prepare.lm.done", true);
            }
        }
    }

    protected void cleanUp() {
        int prevNodeCount = this.ghStorage.getNodes();
        PrepareRoutingSubnetworks preparation = new PrepareRoutingSubnetworks(this.ghStorage, this.encodingManager.fetchEdgeEncoders());
        preparation.setMinNetworkSize(this.minNetworkSize);
        preparation.setMinOneWayNetworkSize(this.minOneWayNetworkSize);
        preparation.doWork();
        int currNodeCount = this.ghStorage.getNodes();
        this.logger.info("edges: " + this.ghStorage.getAllEdges().getMaxId() + ", nodes " + currNodeCount + ", there were " + preparation.getMaxSubnetworks() + " subnetworks. removed them => " + (prevNodeCount - currNodeCount) + " less nodes");
    }

    protected void flush() {
        this.logger.info("flushing graph " + this.ghStorage.toString() + ", details:" + this.ghStorage.toDetailsString() + ", " + Helper.getMemInfo() + ")");
        this.ghStorage.flush();
        this.logger.info("flushed graph " + Helper.getMemInfo() + ")");
        this.fullyLoaded = true;
    }

    public void close() {
        if (this.ghStorage != null) {
            this.ghStorage.close();
        }
        if (this.locationIndex != null) {
            this.locationIndex.close();
        }
        try {
            this.lockFactory.forceRemove("gh.lock", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clean() {
        if (this.getGraphHopperLocation().isEmpty()) {
            throw new IllegalStateException("Cannot clean GraphHopper without specified graphHopperLocation");
        }
        File folder = new File(this.getGraphHopperLocation());
        Helper.removeDir(folder);
    }

    protected void ensureNotLoaded() {
        if (this.fullyLoaded) {
            throw new IllegalStateException("No configuration changes are possible after loading the graph");
        }
    }

    protected void ensureWriteAccess() {
        if (!this.allowWrites) {
            throw new IllegalStateException("Writes are not allowed!");
        }
    }

    public void setNonChMaxWaypointDistance(int nonChMaxWaypointDistance) {
        this.nonChMaxWaypointDistance = nonChMaxWaypointDistance;
    }
}

