/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.graphhopper.PathWrapper;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.List;

public class GHResponse {
    private final List<Throwable> errors = new ArrayList<Throwable>(4);
    private final PMap hintsMap = new PMap();
    private final List<PathWrapper> pathWrappers = new ArrayList<PathWrapper>(5);
    private String debugInfo = "";

    public void add(PathWrapper altResponse) {
        this.pathWrappers.add(altResponse);
    }

    public PathWrapper getBest() {
        if (this.pathWrappers.isEmpty()) {
            throw new RuntimeException("Cannot fetch best response if list is empty");
        }
        return this.pathWrappers.get(0);
    }

    public List<PathWrapper> getAll() {
        return this.pathWrappers;
    }

    public boolean hasAlternatives() {
        return this.pathWrappers.size() > 1;
    }

    public void addDebugInfo(String debugInfo) {
        if (debugInfo == null) {
            throw new IllegalStateException("Debug information has to be none null");
        }
        if (!this.debugInfo.isEmpty()) {
            this.debugInfo = String.valueOf(this.debugInfo) + "; ";
        }
        this.debugInfo = String.valueOf(this.debugInfo) + debugInfo;
    }

    public String getDebugInfo() {
        String str = this.debugInfo;
        for (PathWrapper ar : this.pathWrappers) {
            if (!str.isEmpty()) {
                str = String.valueOf(str) + "; ";
            }
            str = String.valueOf(str) + ar.getDebugInfo();
        }
        return str;
    }

    public boolean hasErrors() {
        if (!this.errors.isEmpty()) {
            return true;
        }
        for (PathWrapper ar : this.pathWrappers) {
            if (!ar.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public List<Throwable> getErrors() {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        list.addAll(this.errors);
        for (PathWrapper ar : this.pathWrappers) {
            list.addAll(ar.getErrors());
        }
        return list;
    }

    public GHResponse addErrors(List<Throwable> errors) {
        this.errors.addAll(errors);
        return this;
    }

    public GHResponse addError(Throwable error) {
        this.errors.add(error);
        return this;
    }

    public String toString() {
        String str = "";
        for (PathWrapper a : this.pathWrappers) {
            str = String.valueOf(str) + "; " + a.toString();
        }
        if (this.pathWrappers.isEmpty()) {
            str = "no paths";
        }
        if (!this.errors.isEmpty()) {
            str = String.valueOf(str) + ", main errors: " + this.errors.toString();
        }
        return str;
    }

    public PMap getHints() {
        return this.hintsMap;
    }
}

