/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.swing;

import java.text.DateFormat;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.xBaseJ.DBF;
import org.xBaseJ.fields.Field;
import org.xBaseJ.swing.dbfViewer;

class dbfTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    DBF currentDBF;
    int inRow;
    String[] columnName;
    int columnCount;
    int rowCount;
    DateFormat df;
    Object[][] fld;
    Boolean[] deleted;
    dbfViewer parent;

    public dbfTableModel(String tableName, dbfViewer inParent) {
        try {
            this.currentDBF = new DBF(tableName);
            this.df = DateFormat.getDateInstance(3);
            this.parent = inParent;
            this.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public dbfTableModel() {
        this.columnCount = 0;
        this.rowCount = 0;
    }

    public void save() {
        String inString = "not set yet";
        try {
            for (int r = 0; r < this.rowCount; ++r) {
                this.currentDBF.gotoRecord(r + 1);
                for (int k = 0; k < this.columnCount - 1; ++k) {
                    inString = "Field " + k;
                    if (this.fld[r][k] instanceof String) {
                        this.currentDBF.getField(k + 1).put((String)this.fld[r][k]);
                        continue;
                    }
                    if (!(this.fld[r][k] instanceof Boolean)) continue;
                    Boolean bf = (Boolean)this.fld[r][k];
                    this.currentDBF.getField(k + 1).put(bf != false ? "T" : "F");
                }
                Boolean b = this.deleted[r];
                if (b.booleanValue()) {
                    this.currentDBF.delete();
                } else {
                    this.currentDBF.undelete();
                }
                this.currentDBF.update();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.parent, inString + " caused an exception: " + e.getMessage(), "Error Setting Field", 0);
        }
    }

    @Override
    public String getColumnName(int c) {
        return this.columnName[c];
    }

    @Override
    public void setValueAt(Object in, int r, int c) {
        if (c == this.columnCount - 1) {
            this.deleted[r] = (Boolean)in;
            return;
        }
        try {
            this.fld[r][c] = this.currentDBF.getField(c + 1).getType() == 'L' ? (Boolean)in : (String)in;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.parent, "row: " + r + " col: " + c + " " + in + " caused an exception: " + e.getMessage(), "Error Setting Field", 0);
        }
    }

    @Override
    public Object getValueAt(int r, int c) {
        if (c == this.columnCount - 1) {
            return this.deleted[r];
        }
        return this.fld[r][c];
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public Field getColumnField(int c) throws Exception {
        return this.currentDBF.getField(c + 1);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    public void getData() throws Exception {
        int k;
        this.rowCount = this.currentDBF.getRecordCount();
        this.columnCount = this.currentDBF.getFieldCount() + 1;
        this.columnName = new String[this.columnCount];
        this.columnName[this.columnCount - 1] = "Deleted";
        for (k = 1; k < this.columnCount; ++k) {
            this.columnName[k - 1] = this.currentDBF.getField(k).getName();
        }
        this.deleted = new Boolean[this.rowCount];
        this.fld = new Object[this.rowCount][this.columnCount];
        try {
            for (int r = 0; r < this.rowCount; ++r) {
                this.currentDBF.gotoRecord(r + 1);
                for (k = 0; k < this.columnCount - 1; ++k) {
                    this.fld[r][k] = this.currentDBF.getField(k + 1).getType() == 'L' ? Boolean.valueOf(this.currentDBF.getField(k + 1).get().compareTo("T") == 0) : this.currentDBF.getField(k + 1).get();
                }
                this.deleted[r] = this.currentDBF.deleted();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

