/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.fields;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.xBaseJ.fields.Field;
import org.xBaseJ.xBaseJException;

public class CurrencyField
extends Field {
    public static final char type = 'Y';

    public CurrencyField(String iName, ByteBuffer inBuffer) throws xBaseJException {
        this.setField(iName, 8, inBuffer);
    }

    public CurrencyField(String iName) throws xBaseJException {
        this.setField(iName, 8, null);
    }

    @Override
    public char getType() {
        return 'Y';
    }

    @Override
    public String get() {
        BigDecimal val = this.currencyFromByteArray(super.getBytes());
        return new String(val.toString());
    }

    public void put(BigDecimal value) throws xBaseJException {
        super.put(this.currencyToByteArray(value));
    }

    private final BigDecimal currencyFromByteArray(byte[] bytes) {
        long d = (long)bytes[7] << 56 | (long)(bytes[6] & 0xFF) << 48 | (long)(bytes[5] & 0xFF) << 40 | (long)(bytes[4] & 0xFF) << 32 | (long)(bytes[3] & 0xFF) << 24 | (long)(bytes[2] & 0xFF) << 16 | (long)(bytes[1] & 0xFF) << 8 | (long)(bytes[0] & 0xFF);
        return new BigDecimal(BigInteger.valueOf(d), 4);
    }

    private final byte[] currencyToByteArray(BigDecimal currencyValue) {
        byte[] bytes = new byte[8];
        long v = currencyValue.multiply(new BigDecimal(10000L)).longValue();
        bytes[0] = (byte)v;
        bytes[1] = (byte)(v >> 8);
        bytes[2] = (byte)(v >> 16);
        bytes[3] = (byte)(v >> 24);
        bytes[4] = (byte)(v >> 32);
        bytes[5] = (byte)(v >> 40);
        bytes[6] = (byte)(v >> 48);
        bytes[7] = (byte)(v >> 56);
        return bytes;
    }
}

