/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xsd.commons;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.ValidationEventHandler;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.resolver.DefaultURIResolver;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xml.sax.SaxUtils;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;
import org.springframework.xml.xsd.XsdSchema;
import org.springframework.xml.xsd.XsdSchemaCollection;
import org.springframework.xml.xsd.commons.CommonsXsdSchema;
import org.springframework.xml.xsd.commons.CommonsXsdSchemaException;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsXsdSchemaCollection
implements XsdSchemaCollection,
InitializingBean,
ResourceLoaderAware {
    private static final Log logger = LogFactory.getLog(CommonsXsdSchemaCollection.class);
    private final XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
    private final List<XmlSchema> xmlSchemas = new ArrayList<XmlSchema>();
    private Resource[] xsdResources;
    private boolean inline = false;
    private ValidationEventHandler validationEventHandler;
    private URIResolver uriResolver = new ClasspathUriResolver();
    private ResourceLoader resourceLoader;

    public CommonsXsdSchemaCollection() {
    }

    public CommonsXsdSchemaCollection(Resource[] resources) {
        this.xsdResources = resources;
    }

    public void setXsds(Resource[] xsdResources) {
        this.xsdResources = xsdResources;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
    }

    public void setUriResolver(URIResolver uriResolver) {
        Assert.notNull(uriResolver, "'uriResolver' must not be null");
        this.uriResolver = uriResolver;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void afterPropertiesSet() throws IOException {
        Assert.notEmpty(this.xsdResources, "'xsds' must not be empty");
        this.schemaCollection.setSchemaResolver(this.uriResolver);
        HashSet<XmlSchema> processedIncludes = new HashSet<XmlSchema>();
        HashSet<XmlSchema> processedImports = new HashSet<XmlSchema>();
        for (Resource xsdResource : this.xsdResources) {
            Assert.isTrue(xsdResource.exists(), xsdResource + " does not exit");
            try {
                XmlSchema xmlSchema = this.schemaCollection.read(SaxUtils.createInputSource(xsdResource), this.validationEventHandler);
                this.xmlSchemas.add(xmlSchema);
                if (!this.inline) continue;
                this.inlineIncludes(xmlSchema, processedIncludes, processedImports);
                this.findImports(xmlSchema, processedImports, processedIncludes);
            }
            catch (Exception ex) {
                throw new CommonsXsdSchemaException("Schema [" + xsdResource + "] could not be loaded", ex);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Loaded " + StringUtils.arrayToCommaDelimitedString(this.xsdResources));
        }
    }

    @Override
    public XsdSchema[] getXsdSchemas() {
        XsdSchema[] result = new XsdSchema[this.xmlSchemas.size()];
        for (int i = 0; i < this.xmlSchemas.size(); ++i) {
            XmlSchema xmlSchema = this.xmlSchemas.get(i);
            result[i] = new CommonsXsdSchema(xmlSchema, this.schemaCollection);
        }
        return result;
    }

    @Override
    public XmlValidator createValidator() throws IOException {
        Resource[] resources = new Resource[this.xmlSchemas.size()];
        for (int i = this.xmlSchemas.size() - 1; i >= 0; --i) {
            XmlSchema xmlSchema = this.xmlSchemas.get(i);
            resources[i] = new UrlResource(xmlSchema.getSourceURI());
        }
        return XmlValidatorFactory.createValidator(resources, "http://www.w3.org/2001/XMLSchema");
    }

    private void inlineIncludes(XmlSchema schema, Set<XmlSchema> processedIncludes, Set<XmlSchema> processedImports) {
        processedIncludes.add(schema);
        XmlSchemaObjectCollection schemaItems = schema.getItems();
        for (int i = 0; i < schemaItems.getCount(); ++i) {
            XmlSchemaObject schemaObject = schemaItems.getItem(i);
            if (!(schemaObject instanceof XmlSchemaInclude)) continue;
            XmlSchema includedSchema = ((XmlSchemaInclude)schemaObject).getSchema();
            if (!processedIncludes.contains(includedSchema)) {
                this.inlineIncludes(includedSchema, processedIncludes, processedImports);
                this.findImports(includedSchema, processedImports, processedIncludes);
                XmlSchemaObjectCollection includeItems = includedSchema.getItems();
                for (int j = 0; j < includeItems.getCount(); ++j) {
                    XmlSchemaObject includedItem = includeItems.getItem(j);
                    schemaItems.add(includedItem);
                }
            }
            schemaItems.removeAt(i);
            --i;
        }
    }

    private void findImports(XmlSchema schema, Set<XmlSchema> processedImports, Set<XmlSchema> processedIncludes) {
        processedImports.add(schema);
        XmlSchemaObjectCollection includes = schema.getIncludes();
        for (int i = 0; i < includes.getCount(); ++i) {
            XmlSchemaExternal external = (XmlSchemaExternal)includes.getItem(i);
            if (!(external instanceof XmlSchemaImport)) continue;
            XmlSchemaImport schemaImport = (XmlSchemaImport)external;
            XmlSchema importedSchema = schemaImport.getSchema();
            if (!"http://www.w3.org/XML/1998/namespace".equals(schemaImport.getNamespace()) && importedSchema != null && !processedImports.contains(importedSchema)) {
                this.inlineIncludes(importedSchema, processedIncludes, processedImports);
                this.findImports(importedSchema, processedImports, processedIncludes);
                this.xmlSchemas.add(importedSchema);
            }
            external.setSchemaLocation(null);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CommonsXsdSchemaCollection");
        builder.append('{');
        for (int i = 0; i < this.xmlSchemas.size(); ++i) {
            XmlSchema schema = this.xmlSchemas.get(i);
            builder.append(schema.getTargetNamespace());
            if (i >= this.xmlSchemas.size() - 1) continue;
            builder.append(',');
        }
        builder.append('}');
        return builder.toString();
    }

    private class ClasspathUriResolver
    extends DefaultURIResolver {
        private ClasspathUriResolver() {
        }

        public InputSource resolveEntity(String namespace, String schemaLocation, String baseUri) {
            if (CommonsXsdSchemaCollection.this.resourceLoader != null) {
                Resource resource = CommonsXsdSchemaCollection.this.resourceLoader.getResource(schemaLocation);
                if (resource.exists()) {
                    return this.createInputSource(resource);
                }
                if (StringUtils.hasLength(baseUri)) {
                    try {
                        UrlResource baseUriResource = new UrlResource(baseUri);
                        resource = baseUriResource.createRelative(schemaLocation);
                        if (resource.exists()) {
                            return this.createInputSource(resource);
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                String classpathLocation = "classpath:/" + schemaLocation;
                resource = CommonsXsdSchemaCollection.this.resourceLoader.getResource(classpathLocation);
                if (resource.exists()) {
                    return this.createInputSource(resource);
                }
            }
            return super.resolveEntity(namespace, schemaLocation, baseUri);
        }

        private InputSource createInputSource(Resource resource) {
            try {
                return SaxUtils.createInputSource(resource);
            }
            catch (IOException ex) {
                throw new CommonsXsdSchemaException("Could not resolve location", ex);
            }
        }
    }
}

