/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.namespace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNamespaceContext
implements NamespaceContext {
    private Map<String, String> prefixToNamespaceUri = new HashMap<String, String>();
    private MultiValueMap<String, String> namespaceUriToPrefixes = new LinkedMultiValueMap<String, String>();

    @Override
    public String getNamespaceURI(String prefix) {
        Assert.notNull(prefix, "prefix is null");
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.prefixToNamespaceUri.containsKey(prefix)) {
            return this.prefixToNamespaceUri.get(prefix);
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceUri) {
        List<String> prefixes = this.getPrefixesInternal(namespaceUri);
        return prefixes.isEmpty() ? null : prefixes.get(0);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceUri) {
        return this.getPrefixesInternal(namespaceUri).iterator();
    }

    public void setBindings(Map<String, String> bindings) {
        for (Map.Entry<String, String> entry : bindings.entrySet()) {
            this.bindNamespaceUri(entry.getKey(), entry.getValue());
        }
    }

    public void bindDefaultNamespaceUri(String namespaceUri) {
        this.bindNamespaceUri("", namespaceUri);
    }

    public void bindNamespaceUri(String prefix, String namespaceUri) {
        Assert.notNull(prefix, "No prefix given");
        Assert.notNull(namespaceUri, "No namespaceUri given");
        if ("xml".equals(prefix)) {
            Assert.isTrue("http://www.w3.org/XML/1998/namespace".equals(namespaceUri), "Prefix \"" + prefix + "\" bound to namespace \"" + namespaceUri + "\" (should be \"" + "http://www.w3.org/XML/1998/namespace" + "\")");
        } else if ("xmlns".equals(prefix)) {
            Assert.isTrue("http://www.w3.org/2000/xmlns/".equals(namespaceUri), "Prefix \"" + prefix + "\" bound to namespace \"" + namespaceUri + "\" (should be \"" + "http://www.w3.org/2000/xmlns/" + "\")");
        } else {
            this.prefixToNamespaceUri.put(prefix, namespaceUri);
            this.getPrefixesInternal(namespaceUri).add(prefix);
        }
    }

    public void clear() {
        this.prefixToNamespaceUri.clear();
        this.namespaceUriToPrefixes.clear();
    }

    public Iterator<String> getBoundPrefixes() {
        HashSet<String> prefixes = new HashSet<String>(this.prefixToNamespaceUri.keySet());
        prefixes.remove("");
        return prefixes.iterator();
    }

    private List<String> getPrefixesInternal(String namespaceUri) {
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceUri)) {
            return Collections.singletonList("xml");
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceUri)) {
            return Collections.singletonList("xmlns");
        }
        ArrayList list = (ArrayList)this.namespaceUriToPrefixes.get(namespaceUri);
        if (list == null) {
            list = new ArrayList();
            this.namespaceUriToPrefixes.put(namespaceUri, (String)((Object)list));
        }
        return list;
    }

    public void removeBinding(String prefix) {
        String namespaceUri = this.prefixToNamespaceUri.get(prefix);
        List<String> prefixes = this.getPrefixesInternal(namespaceUri);
        prefixes.remove(prefix);
    }

    public boolean hasBinding(String prefix) {
        return this.prefixToNamespaceUri.containsKey(prefix);
    }
}

