/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.ws.transport.http.LastModifiedHelper;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.springframework.xml.xsd.XsdSchema;

public class XsdSchemaHandlerAdapter
extends TransformerObjectSupport
implements HandlerAdapter {
    private static final String CONTENT_TYPE = "text/xml";

    public boolean supports(Object handler) {
        return handler instanceof XsdSchema;
    }

    public long getLastModified(HttpServletRequest request, Object handler) {
        Source schemaSource = ((XsdSchema)handler).getSource();
        return LastModifiedHelper.getLastModified(schemaSource);
    }

    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if ("GET".equals(request.getMethod())) {
            response.setContentType(CONTENT_TYPE);
            Transformer transformer = this.createTransformer();
            Source schemaSource = this.getSchemaSource((XsdSchema)handler);
            StreamResult responseResult = new StreamResult(response.getOutputStream());
            transformer.transform(schemaSource, responseResult);
        } else {
            response.setStatus(405);
        }
        return null;
    }

    protected Source getSchemaSource(XsdSchema schema) throws Exception {
        return schema.getSource();
    }
}

