/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.ws.transport.http.LastModifiedHelper;
import org.springframework.ws.wsdl.WsdlDefinition;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WsdlDefinitionHandlerAdapter
extends TransformerObjectSupport
implements HandlerAdapter,
InitializingBean {
    public static final String DEFAULT_LOCATION_EXPRESSION = "//@location";
    private static final String CONTENT_TYPE = "text/xml";
    private static final Log logger = LogFactory.getLog(WsdlDefinitionHandlerAdapter.class);
    private Map<String, String> expressionNamespaces = new HashMap<String, String>();
    private String locationExpression = "//@location";
    private XPathExpression locationXPathExpression;
    private boolean transformLocations = false;

    public void setLocationExpression(String locationExpression) {
        this.locationExpression = locationExpression;
    }

    public void setTransformLocations(boolean transformLocations) {
        this.transformLocations = transformLocations;
    }

    public long getLastModified(HttpServletRequest request, Object handler) {
        Source definitionSource = ((WsdlDefinition)handler).getSource();
        return LastModifiedHelper.getLastModified(definitionSource);
    }

    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if ("GET".equals(request.getMethod())) {
            response.setContentType(CONTENT_TYPE);
            Transformer transformer = this.createTransformer();
            WsdlDefinition definition = (WsdlDefinition)handler;
            Source definitionSource = definition.getSource();
            if (this.transformLocations) {
                DOMResult domResult = new DOMResult();
                transformer.transform(definitionSource, domResult);
                Document definitionDocument = (Document)domResult.getNode();
                this.transformLocations(definitionDocument, request);
                definitionSource = new DOMSource(definitionDocument);
            }
            StreamResult responseResult = new StreamResult(response.getOutputStream());
            transformer.transform(definitionSource, responseResult);
        } else {
            response.setStatus(405);
        }
        return null;
    }

    public boolean supports(Object handler) {
        return handler instanceof WsdlDefinition;
    }

    public void afterPropertiesSet() throws Exception {
        this.locationXPathExpression = XPathExpressionFactory.createXPathExpression(this.locationExpression, this.expressionNamespaces);
    }

    protected String transformLocation(String location, HttpServletRequest request) {
        StringBuilder url = new StringBuilder(request.getScheme());
        url.append("://").append(request.getServerName()).append(':').append(request.getServerPort());
        if (location.startsWith("/")) {
            url.append(request.getContextPath()).append(location);
            return url.toString();
        }
        int idx = location.indexOf("://");
        if (idx != -1 && (idx = location.indexOf(47, idx + 3)) != -1) {
            String path = location.substring(idx);
            url.append(path);
            return url.toString();
        }
        return location;
    }

    protected void transformLocations(Document definitionDocument, HttpServletRequest request) throws Exception {
        List<Node> locationNodes = this.locationXPathExpression.evaluateAsNodeList(definitionDocument);
        for (Node locationNode : locationNodes) {
            Attr location;
            if (!(locationNode instanceof Attr) || !StringUtils.hasLength((location = (Attr)locationNode).getValue())) continue;
            String newLocation = this.transformLocation(location.getValue(), request);
            if (logger.isDebugEnabled()) {
                logger.debug("Transforming [" + location.getValue() + "] to [" + newLocation + "]");
            }
            location.setValue(newLocation);
        }
    }
}

