/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint;

import java.util.Locale;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.AbstractEndpointExceptionResolver;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.SoapMessage;

public class SimpleSoapExceptionResolver
extends AbstractEndpointExceptionResolver {
    private Locale locale = Locale.ENGLISH;

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        Assert.notNull(locale, "locale must not be null");
        this.locale = locale;
    }

    protected final boolean resolveExceptionInternal(MessageContext messageContext, Object endpoint, Exception ex) {
        Assert.isInstanceOf(SoapMessage.class, messageContext.getResponse(), "SimpleSoapExceptionResolver requires a SoapMessage");
        SoapMessage response = (SoapMessage)messageContext.getResponse();
        String faultString = StringUtils.hasLength(ex.getMessage()) ? ex.getMessage() : ex.toString();
        SoapBody body = response.getSoapBody();
        SoapFault fault = body.addServerOrReceiverFault(faultString, this.getLocale());
        this.customizeFault(messageContext, endpoint, ex, fault);
        return true;
    }

    protected void customizeFault(MessageContext messageContext, Object endpoint, Exception ex, SoapFault fault) {
    }
}

