/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFaultElement;
import javax.xml.transform.Result;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapFaultDetail;
import org.springframework.ws.soap.SoapFaultDetailElement;
import org.springframework.ws.soap.saaj.SaajSoapElement;
import org.springframework.ws.soap.saaj.SaajSoapFaultDetailElement;
import org.springframework.ws.soap.saaj.SaajSoapFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SaajSoapFaultDetail
extends SaajSoapElement
implements SoapFaultDetail {
    public SaajSoapFaultDetail(SOAPFaultElement faultElement) {
        super((SOAPElement)faultElement);
    }

    @Override
    public Result getResult() {
        return this.getImplementation().getResult((SOAPElement)this.getSaajDetail());
    }

    @Override
    public SoapFaultDetailElement addFaultDetailElement(QName name) {
        try {
            DetailEntry detailEntry = this.getImplementation().addDetailEntry(this.getSaajDetail(), name);
            return new SaajSoapFaultDetailElement(detailEntry);
        }
        catch (SOAPException ex) {
            throw new SaajSoapFaultException(ex);
        }
    }

    @Override
    public Iterator<SoapFaultDetailElement> getDetailEntries() {
        Iterator<DetailEntry> iterator = this.getImplementation().getDetailEntries(this.getSaajDetail());
        return new SaajSoapFaultDetailElementIterator(iterator);
    }

    protected Detail getSaajDetail() {
        return (Detail)this.getSaajElement();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SaajSoapFaultDetailElementIterator
    implements Iterator<SoapFaultDetailElement> {
        private final Iterator<DetailEntry> iterator;

        private SaajSoapFaultDetailElementIterator(Iterator<DetailEntry> iterator) {
            Assert.notNull(iterator, "No iterator given");
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public SoapFaultDetailElement next() {
            DetailEntry saajDetailEntry = this.iterator.next();
            return new SaajSoapFaultDetailElement(saajDetailEntry);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

