/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.SaajSoap12Fault;
import org.springframework.ws.soap.saaj.SaajSoapBody;
import org.springframework.ws.soap.saaj.SaajSoapFaultException;
import org.springframework.ws.soap.soap12.Soap12Body;
import org.springframework.ws.soap.soap12.Soap12Fault;

class SaajSoap12Body
extends SaajSoapBody
implements Soap12Body {
    SaajSoap12Body(SOAPBody body) {
        super(body);
    }

    public SoapFault getFault() {
        SOAPFault fault = this.getImplementation().getFault(this.getSaajBody());
        return fault != null ? new SaajSoap12Fault(fault) : null;
    }

    public SoapFault addClientOrSenderFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_12.getClientOrSenderFaultName(), faultString, locale);
    }

    public SoapFault addMustUnderstandFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_12.getMustUnderstandFaultName(), faultString, locale);
    }

    public SoapFault addServerOrReceiverFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_12.getServerOrReceiverFaultName(), faultString, locale);
    }

    public SoapFault addVersionMismatchFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_12.getVersionMismatchFaultName(), faultString, locale);
    }

    public Soap12Fault addDataEncodingUnknownFault(QName[] subcodes, String reason, Locale locale) {
        QName name = new QName(SoapVersion.SOAP_12.getEnvelopeNamespaceUri(), "DataEncodingUnknown");
        Soap12Fault fault = this.addFault(name, reason, locale);
        for (QName subcode : subcodes) {
            fault.addFaultSubcode(subcode);
        }
        return fault;
    }

    protected Soap12Fault addFault(QName faultCode, String faultString, Locale faultStringLocale) {
        Assert.notNull(faultCode, "No faultCode given");
        Assert.hasLength(faultString, "faultString cannot be empty");
        Assert.hasLength(faultCode.getLocalPart(), "faultCode's localPart cannot be empty");
        Assert.hasLength(faultCode.getNamespaceURI(), "faultCode's namespaceUri cannot be empty");
        try {
            this.getImplementation().removeContents((SOAPElement)this.getSaajBody());
            SOAPFault saajFault = this.getImplementation().addFault(this.getSaajBody(), faultCode, faultString, faultStringLocale);
            return new SaajSoap12Fault(saajFault);
        }
        catch (SOAPException ex) {
            throw new SaajSoapFaultException(ex);
        }
    }
}

