/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.springframework.util.ObjectUtils;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.SaajImplementation;
import org.springframework.ws.transport.TransportOutputStream;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Saaj13Implementation
extends SaajImplementation {
    private static final Saaj13Implementation INSTANCE = new Saaj13Implementation();

    private Saaj13Implementation() {
    }

    public static Saaj13Implementation getInstance() {
        return INSTANCE;
    }

    @Override
    public QName getName(SOAPElement element) {
        return element.getElementQName();
    }

    @Override
    public QName getFaultCode(SOAPFault fault) {
        return fault.getFaultCodeAsQName();
    }

    public boolean isSoap11(SOAPElement element) {
        return "http://schemas.xmlsoap.org/soap/envelope/".equals(element.getNamespaceURI());
    }

    @Override
    public DetailEntry addDetailEntry(Detail detail, QName name) throws SOAPException {
        return detail.addDetailEntry(name);
    }

    @Override
    public SOAPHeaderElement addHeaderElement(SOAPHeader header, QName name) throws SOAPException {
        return header.addHeaderElement(name);
    }

    @Override
    public String getFaultRole(SOAPFault fault) {
        return fault.getFaultRole();
    }

    @Override
    public void setFaultRole(SOAPFault fault, String role) throws SOAPException {
        fault.setFaultRole(role);
    }

    @Override
    public SOAPHeaderElement addNotUnderstoodHeaderElement(SOAPHeader header, QName name) throws SOAPException {
        return header.addNotUnderstoodHeaderElement(name);
    }

    @Override
    public SOAPHeaderElement addUpgradeHeaderElement(SOAPHeader header, String[] supportedSoapUris) throws SOAPException {
        return header.addUpgradeHeaderElement(supportedSoapUris);
    }

    @Override
    public Iterator<QName> getFaultSubcodes(SOAPFault fault) {
        return fault.getFaultSubcodes();
    }

    @Override
    public void appendFaultSubcode(SOAPFault fault, QName subcode) throws SOAPException {
        fault.appendFaultSubcode(subcode);
    }

    @Override
    public String getFaultNode(SOAPFault fault) {
        return fault.getFaultNode();
    }

    @Override
    public void setFaultNode(SOAPFault fault, String uri) throws SOAPException {
        fault.setFaultNode(uri);
    }

    @Override
    public String getFaultReasonText(SOAPFault fault, Locale locale) throws SOAPException {
        return fault.getFaultReasonText(locale);
    }

    @Override
    public void setFaultReasonText(SOAPFault fault, Locale locale, String text) throws SOAPException {
        fault.addFaultReasonText(text, locale);
    }

    @Override
    public SOAPFault addFault(SOAPBody body, QName faultCode, String faultString, Locale locale) throws SOAPException {
        if (locale == null) {
            return body.addFault(faultCode, faultString);
        }
        return body.addFault(faultCode, faultString, locale);
    }

    @Override
    public Source getSource(SOAPElement element) {
        return new DOMSource((Node)element);
    }

    @Override
    public Result getResult(SOAPElement element) {
        return new DOMResult((Node)element);
    }

    @Override
    public String getText(SOAPElement element) {
        return element.getValue();
    }

    @Override
    public void setText(SOAPElement element, String content) {
        element.setValue(content);
    }

    @Override
    public void addAttribute(SOAPElement element, QName name, String value) throws SOAPException {
        element.addAttribute(name, value);
    }

    @Override
    public void removeAttribute(SOAPElement element, QName name) throws SOAPException {
        element.removeAttribute(name);
    }

    @Override
    public String getAttributeValue(SOAPElement element, QName name) throws SOAPException {
        return element.getAttributeValue(name);
    }

    @Override
    public Iterator<QName> getAllAttributes(SOAPElement element) {
        return element.getAllAttributesAsQNames();
    }

    @Override
    public SOAPEnvelope getEnvelope(SOAPMessage message) throws SOAPException {
        return message.getSOAPPart().getEnvelope();
    }

    @Override
    public SOAPHeader getHeader(SOAPEnvelope envelope) throws SOAPException {
        return envelope.getHeader();
    }

    @Override
    public SOAPBody getBody(SOAPEnvelope envelope) throws SOAPException {
        return envelope.getBody();
    }

    @Override
    public Iterator<SOAPHeaderElement> examineAllHeaderElements(SOAPHeader header) {
        return header.examineAllHeaderElements();
    }

    @Override
    public Iterator<SOAPHeaderElement> examineMustUnderstandHeaderElements(SOAPHeader header, String actorOrRole) {
        return header.examineMustUnderstandHeaderElements(actorOrRole);
    }

    @Override
    public String getActorOrRole(SOAPHeaderElement headerElement) {
        return headerElement.getActor();
    }

    @Override
    public void setActorOrRole(SOAPHeaderElement headerElement, String actorOrRole) {
        headerElement.setActor(actorOrRole);
    }

    @Override
    public boolean getMustUnderstand(SOAPHeaderElement headerElement) {
        return headerElement.getMustUnderstand();
    }

    @Override
    public void setMustUnderstand(SOAPHeaderElement headerElement, boolean mustUnderstand) {
        headerElement.setMustUnderstand(mustUnderstand);
    }

    @Override
    public boolean hasFault(SOAPBody body) {
        return body.hasFault();
    }

    @Override
    public SOAPFault getFault(SOAPBody body) {
        return body.getFault();
    }

    @Override
    public String getFaultActor(SOAPFault fault) {
        return fault.getFaultActor();
    }

    @Override
    public void setFaultActor(SOAPFault fault, String actorOrRole) throws SOAPException {
        fault.setFaultActor(actorOrRole);
    }

    @Override
    public String getFaultString(SOAPFault fault) {
        return fault.getFaultString();
    }

    @Override
    public Locale getFaultStringLocale(SOAPFault fault) {
        return fault.getFaultStringLocale();
    }

    @Override
    public Detail getFaultDetail(SOAPFault fault) {
        return fault.getDetail();
    }

    @Override
    public Detail addFaultDetail(SOAPFault fault) throws SOAPException {
        return fault.addDetail();
    }

    @Override
    public void addTextNode(DetailEntry detailEntry, String text) throws SOAPException {
        detailEntry.addTextNode(text);
    }

    @Override
    public Iterator<DetailEntry> getDetailEntries(Detail detail) {
        return detail.getDetailEntries();
    }

    @Override
    public SOAPElement getFirstBodyElement(SOAPBody body) {
        Iterator iterator = body.getChildElements();
        while (iterator.hasNext()) {
            Object child = iterator.next();
            if (!(child instanceof SOAPElement)) continue;
            return (SOAPElement)child;
        }
        return null;
    }

    @Override
    public void removeContents(SOAPElement element) {
        element.removeContents();
    }

    @Override
    Iterator<SOAPElement> getChildElements(SOAPElement element, QName name) throws SOAPException {
        return element.getChildElements(name);
    }

    @Override
    void addNamespaceDeclaration(SOAPElement element, String prefix, String namespaceUri) throws SOAPException {
        element.addNamespaceDeclaration(prefix, namespaceUri);
    }

    @Override
    public void writeTo(SOAPMessage message, OutputStream outputStream) throws SOAPException, IOException {
        if (message.saveRequired()) {
            message.saveChanges();
        }
        if (outputStream instanceof TransportOutputStream) {
            TransportOutputStream transportOutputStream = (TransportOutputStream)outputStream;
            MimeHeaders headers = message.getMimeHeaders();
            if (ObjectUtils.isEmpty(headers.getHeader("Content-Type"))) {
                SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
                if (envelope.getElementQName().getNamespaceURI().equals(SoapVersion.SOAP_11.getEnvelopeNamespaceUri())) {
                    headers.addHeader("Content-Type", SoapVersion.SOAP_11.getContentType());
                } else {
                    headers.addHeader("Content-Type", SoapVersion.SOAP_12.getContentType());
                }
                if (message.saveRequired()) {
                    message.saveChanges();
                }
            }
            Iterator iterator = headers.getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                transportOutputStream.addHeader(mimeHeader.getName(), mimeHeader.getValue());
            }
        }
        message.writeTo(outputStream);
    }

    @Override
    public MimeHeaders getMimeHeaders(SOAPMessage message) {
        return message.getMimeHeaders();
    }

    @Override
    public Iterator<AttachmentPart> getAttachments(SOAPMessage message) {
        return message.getAttachments();
    }

    @Override
    public Iterator<AttachmentPart> getAttachment(SOAPMessage message, MimeHeaders mimeHeaders) {
        return message.getAttachments(mimeHeaders);
    }

    @Override
    public AttachmentPart addAttachmentPart(SOAPMessage message, DataHandler dataHandler) {
        AttachmentPart attachmentPart = message.createAttachmentPart(dataHandler);
        message.addAttachmentPart(attachmentPart);
        return attachmentPart;
    }
}

