/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.MethodEndpoint;
import org.springframework.ws.server.endpoint.mapping.AbstractEndpointMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMethodEndpointMapping
extends AbstractEndpointMapping {
    private final Map<String, MethodEndpoint> endpointMap = new HashMap<String, MethodEndpoint>();

    @Override
    protected Object getEndpointInternal(MessageContext messageContext) throws Exception {
        String key = this.getLookupKeyForMessage(messageContext);
        if (!StringUtils.hasLength(key)) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking up endpoint for [" + key + "]");
        }
        return this.lookupEndpoint(key);
    }

    protected abstract String getLookupKeyForMessage(MessageContext var1) throws Exception;

    protected MethodEndpoint lookupEndpoint(String key) {
        return this.endpointMap.get(key);
    }

    protected void registerEndpoint(String key, MethodEndpoint endpoint) throws BeansException {
        MethodEndpoint mappedEndpoint = this.endpointMap.get(key);
        if (mappedEndpoint != null) {
            throw new ApplicationContextException("Cannot map endpoint [" + endpoint + "] on registration key [" + key + "]: there's already endpoint [" + mappedEndpoint + "] mapped");
        }
        if (endpoint == null) {
            throw new ApplicationContextException("Could not find endpoint for key [" + key + "]");
        }
        this.endpointMap.put(key, endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mapped key [" + key + "] onto endpoint [" + endpoint + "]");
        }
    }

    protected void registerMethods(final Object endpoint) {
        Assert.notNull(endpoint, "'endpoint' must not be null");
        Class<?> endpointClass = this.getEndpointClass(endpoint);
        ReflectionUtils.doWithMethods(endpointClass, new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                String key = AbstractMethodEndpointMapping.this.getLookupKeyForMethod(method);
                if (StringUtils.hasLength(key)) {
                    AbstractMethodEndpointMapping.this.registerEndpoint(key, new MethodEndpoint(endpoint, method));
                }
            }
        });
    }

    protected void registerMethods(final String beanName) {
        Assert.hasText(beanName, "'beanName' must not be empty");
        Class<?> endpointClass = this.getApplicationContext().getType(beanName);
        ReflectionUtils.doWithMethods(endpointClass, new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                String key = AbstractMethodEndpointMapping.this.getLookupKeyForMethod(method);
                if (StringUtils.hasLength(key)) {
                    AbstractMethodEndpointMapping.this.registerEndpoint(key, new MethodEndpoint(beanName, AbstractMethodEndpointMapping.this.getApplicationContext(), method));
                }
            }
        });
    }

    protected String getLookupKeyForMethod(Method method) {
        return null;
    }

    protected Class<?> getEndpointClass(Object endpoint) {
        if (AopUtils.isJdkDynamicProxy(endpoint)) {
            throw new IllegalArgumentException(ClassUtils.getShortName(this.getClass()) + " does not work with JDK Dynamic Proxies. " + "Please use CGLIB proxies, by setting proxy-target-class=\"true\" on the aop:aspectj-autoproxy " + "or aop:config element.");
        }
        return AopUtils.getTargetClass(endpoint);
    }
}

