/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint;

import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.AbstractMarshallingPayloadEndpoint;

public abstract class AbstractValidatingMarshallingPayloadEndpoint
extends AbstractMarshallingPayloadEndpoint {
    public static final String DEFAULT_REQUEST_NAME = "request";
    private String requestName = "request";
    private Validator[] validators;

    public String getRequestName() {
        return this.requestName;
    }

    public void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    public Validator getValidator() {
        Validator[] validators = this.getValidators();
        return validators != null && validators.length > 0 ? validators[0] : null;
    }

    public void setValidator(Validator validator) {
        this.validators = new Validator[]{validator};
    }

    public Validator[] getValidators() {
        return this.validators;
    }

    public void setValidators(Validator[] validators) {
        this.validators = validators;
    }

    protected boolean onUnmarshalRequest(MessageContext messageContext, Object requestObject) throws Exception {
        Validator[] validators = this.getValidators();
        if (validators != null) {
            BindException errors = new BindException(requestObject, this.getRequestName());
            for (Validator validator : validators) {
                ValidationUtils.invokeValidator(validator, requestObject, errors);
            }
            if (errors.hasErrors()) {
                return this.onValidationErrors(messageContext, requestObject, errors);
            }
        }
        return true;
    }

    protected abstract boolean onValidationErrors(MessageContext var1, Object var2, Errors var3);
}

