/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public abstract class AbstractDetectingUrlHandlerMapping
extends AbstractUrlHandlerMapping {
    private boolean detectHandlersInAncestorContexts = false;

    public void setDetectHandlersInAncestorContexts(boolean detectHandlersInAncestorContexts) {
        this.detectHandlersInAncestorContexts = detectHandlersInAncestorContexts;
    }

    public void initApplicationContext() throws ApplicationContextException {
        super.initApplicationContext();
        this.detectHandlers();
    }

    protected void detectHandlers() throws BeansException {
        String[] beanNames;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking for URL mappings in application context: " + this.getApplicationContext());
        }
        String[] stringArray = beanNames = this.detectHandlersInAncestorContexts ? BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this.getApplicationContext(), Object.class) : this.getApplicationContext().getBeanNamesForType(Object.class);
        int n = beanNames.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            Object[] urls = this.determineUrlsForHandler(beanName);
            if (!ObjectUtils.isEmpty(urls)) {
                this.registerHandler((String[])urls, beanName);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Rejected bean name '" + beanName + "': no URL paths identified");
            }
            ++n2;
        }
    }

    protected abstract String[] determineUrlsForHandler(String var1);
}

